/****************************************/
/* Program m8_10_2.sas                  */
/* Exploritory Factor  Analysis         */
/* Di Vesta and Walls Example           */
/****************************************/

options ls=80 nodate pageno=1 formdlim='o';

title 'EFA Model De Vesta and Wall Example';

data rmat(type=corr);
     Input _TYPE_ $ _NAME_ $ v1 - v8;
label v1='friendly/unfriendly' v2='good/bad' v3='nice/awful' v4='brave/not brave'
	 v5='big/little' v6='strong/weak' v7='moving/still' v8='fast/slow'; 
datalines;
n     .   487 487 487 487 487 487 487 487
corr v1  1.00 .95 .96 .68 .33 .60 .21 .30
corr v2   .  1.00 .98 .70 .35 .63 .19 .31
corr v3   .   .  1.00 .68 .31 .61 .19 .31
corr v4   .   .   .  1.00 .52 .79 .42 .57
corr v5   .   .   .   .  1.00 .61 .31 .29
corr v6   .   .   .   .   .  1.00 .42 .57
corr v7   .   .   .   .   .   .  1.00 .68
corr v8   .   .   .   .   .   .   .  1.00
;
ods output OrthRotFactPat = rotfacpat;
proc factor data=rmat   method=ml
                        priors=smc
                        scree
                        nfact=2
                        msa
                        residual
                        rotate=varimax;
run;
proc format;                        
      picture fuzzflag (round)
      low  - -0.40 = ' 99 *' (prefix='-' mult=100)
	  -.40 -  -.00 = ' 99  ' (prefix='-' mult=100)
      0.00 -  0.39 = ' 99  '  (mult=100)
      0.40 -  high = ' 99 *' (mult=100);           
run; 
proc print data = rotfacpat;
      format factor1-factor2 FuzzFlag.;
run;
