/******************************************/
/* Program m8_2_1.sas                     */
/* Principal Component Analysis           */
/* Simple Example                         */
/******************************************/

options ls=80 nodate pageno=1 formdlim='o';

title 'PCA Example using Proc Factor';

data cmat(type=cov);
    Input _TYPE_ $ _NAME_ $ v1-v3;
    Label v1='var1'
          v2='var2'
          v3='var3';
    datalines;
n    .    151  151   151
cov  v1 26.64  .     .
cov  v2  8.52 9.85   .
cov  v3 18.29 8.27 22.08

;
proc factor data=cmat        method=prin
                             priors=one
                             covariance
                             eigenvectors
                             nfact=3;
var v1-v3;
run;
proc factor data=cmat corr   method=prin
                             priors=one
                             eigenvectors
                             nfact=3;
var v1-v3;
run;

title 'PCA Using Proc Princomp';

proc princomp data=cmat covariance;
var v1-v3;

run;

proc princomp data=cmat;
var v1-v3;
run;



run;
