/**********************************************/
/* Program m8_2_2.sas                         */
/* Principal Component Analysis               */
/* Detecting Outliers                         */
/* Cheese Data Moore and McCabe(1993,p. 792)  */
/**********************************************/

options ls=80 nodate pageno=1 formdlim='o';

filename multnorm 'e:\multnorm.sas';
%include multnorm;

title 'Outlier Dectction Using PCA';

data cheese;
     infile 'e:\Cheese.dat' Firstobs=2 expandtabs;
	 Input ID Taste Acetic H2S Lactic;
     c_val=cinv(.95,3);
run;
Title1 'Multivariate Chi-Square Plot - Cheese';
%multnorm(data=Cheese,
          var= Taste Acetic H2S Lactic,
          plot=yes);
run;
proc univariate data=Cheese normal plot vardef=n;
     var Taste Acetic H2S Lactic;
	 qqplot /normal(mu=est sigma=est);
run;
proc princomp data=cheese covariance std prefix=stdpc out=comp;
var Taste Acetic H2S Lactic;
run;

data new;
set comp;
D_2=Uss(of stdpc2-stdpc4); */Calculate Distances*/
run;

proc print data=new;
var Taste Acetic H2S Lactic D_2 c_val;
run;