/************************************/
/* Program m8_3_1.sas               */
/* Principal Componesnt Analysis    */
/* Shin Data Correlation Matrix     */
/************************************/

options ls=80 nodate pageno=1 formdlim='o';

title 'PCA Model Shin Example';

data rmat(type=corr);
     Input _TYPE_ $ _NAME_ $ v1 - v13;
	 label
	 v1='IQ'
     v2='Ideational fluency' 
     v3='Spontaneous flexibility' 
     v4='Associational fluency' 
     v5='Expressional fluency'
	 v6='Originality' v7='Elaboration' v8='Knowledge' v9='comprehension'
	 v10='Application' v11='Analysis' v12='Synthesis' v13='Evaluation';
datalines;

n     .  116 116 116 116 116 116 116 116 116 116 116 116 116
corr v1  1.00 .16 .32 .24 .43 .30 .43 .67 .63 .57 .59 .45 .24
corr v2   .  1.00 .71 .12 .34 .27 .21 .13 .18 .08 .10 .13 .08
corr v3   .   .  1.00 .12 .45 .33 .11 .27 .24 .14 .16 .23 .15
corr v4   .   .   .  1.00 .43 .24 .42 .21 .15 .09 .09 .42 .36
corr v5   .   .   .   .  1.00 .33 .46 .39 .36 .25 .25 .50 .28
corr v6   .   .   .   .   .  1.00 .32 .27 .33 .13 .12 .41 .21
corr v7   .   .   .   .   .   .  1.00 .38 .26 .23 .28 .47 .26
corr v8   .   .   .   .   .   .   .  1.00 .62 .44 .58 .46 .30
corr v9   .   .   .   .   .   .   .   .  1.00 .66 .66 .47 .24
corr v10  .   .   .   .   .   .   .   .   .  1.00 .64 .37 .19
corr v11  .   .   .   .   .   .   .   .   .   .  1.00 .53 .29
corr v12  .   .   .   .   .   .   .   .   .   .   .  1.00 .59
corr v13  .   .   .   .   .   .   .   .   .   .   .   .  1.00
;
ods output FactorPattern = facpat;
proc factor data=rmat   method=prin
                        priors=one
                        scree;
run;
proc format;                        
      picture fuzzflag (round)
      low  - -0.40 = ' 99 *' (prefix='-' mult=100)
	  -.40 -  -.00 = ' 99  ' (prefix='-' mult=100)
      0.00 -  0.39 = ' 99  '  (mult=100)
      0.40 -  high = ' 99 *' (mult=100);           
run; 
proc print data = facpat;
      format factor1-factor3 FuzzFlag.;
run;