/****************************************/
/* Program m8_3_2.sas                   */
/* Principal Component Analysis         */
/* Di Vesta and Walls Example           */
/****************************************/

options ls=80 nodate pageno=1 formdlim='o';
title 'PCA Model De Vesta and Wall Example';

data rmat(type=corr);
     Input _TYPE_ $ _NAME_ $ v1 - v8;
	 label v1='friendly/unfriendly' v2='good/bad' v3='nice/awful' v4='brave/not brave'
	 v5='big/little' v6='strong/weak' v7='moving/still' v8='fast/slow'; 
datalines;
n     .   487 487 487 487 487 487 487 487
corr v1  1.00 .95 .96 .68 .33 .60 .21 .30
corr v2   .  1.00 .98 .70 .35 .63 .19 .31
corr v3   .   .  1.00 .68 .31 .61 .19 .31
corr v4   .   .   .  1.00 .52 .79 .42 .57
corr v5   .   .   .   .  1.00 .61 .31 .29
corr v6   .   .   .   .   .  1.00 .42 .57
corr v7   .   .   .   .   .   .  1.00 .68
corr v8   .   .   .   .   .   .   .  1.00
;
ods output FactorPattern = facpat;
proc factor data=rmat   method=prin
                        priors=one
                        scree
                        nfact=3
                        rotate=varimax;
run;
proc format;                        
      picture fuzzflag (round)
      low  - -0.40 = ' 99 *' (prefix='-' mult=100)
	  -.40 -  -.00 = ' 99  ' (prefix='-' mult=100)
      0.00 -  0.39 = ' 99  '  (mult=100)
      0.40 -  high = ' 99 *' (mult=100);           
run; 
proc print data = facpat;
      format factor1-factor3 FuzzFlag.;
run;
data smat(type=cov);

  input _TYPE_ $ _NAME_ $ v1 - v8;
  	 label v1='friendly/unfriendly' v2='good/bad' v3='nice/awful' v4='brave/not brave'
	 v5='big/little' v6='strong/weak' v7='moving/still' v8='fast/slow'; 
datalines;

cov v1 1.44  .    .    .    .    .    .   .
cov v2 1.58 1.93  .    .    .    .    .   .
cov v3 1.55 1.83 1.82  .    .    .    .   .
cov v4  .61  .73  .69  .56  .    .    .   .
cov v5  .23  .28  .24  .23  .34  .    .   .
cov v6  .56  .68  .64  .46  .28  .61  .   .
cov v7  .19  .20  .17  .24  .13  .25  .56 .
cov v8  .21  .25  .24  .24  .10  .25  .29 .33
;
ods output FactorPattern = facpat;
proc factor data=smat  method=prin
                       priors=one
                       scree
                       covariance
                       eigenvectors
                       nfact=2
                       plot;
run;
proc format;                        
      picture fuzzflag (round)
      low  - -0.40 = '99 *' (prefix='-' mult=100)
	  -.40 -  -.00 = '99  ' (prefix='-' mult=100)
      0.00 -  0.39 = '99  '  (mult=100)
      0.40 -  high = '099 *' (mult=100);           
run; 
proc print data = facpat;
      format factor1-factor2 FuzzFlag.;
run;
