/******************************************/
/* Program m8_3_3.sas                     */
/* Principal Component Analysis           */
/* Performance Assessment Project         */
/* Analysis of Covariance Matrix          */
/* Analysis of Correlation Matrix         */
/******************************************/

options ls=80 nodate pageno=1 formdlim='o';


title 'PCA of Performance Assessment Program using Covariance Matrix';

data cmat(type=cov);
    Input _TYPE_ $ _NAME_ $ v1-v8;
    Label v1='suppg'
          v2='suppi'
          v3='asmte'
          v4='asmtc'
          v5='fam'
          v6='pap'
          v7='prof1'
          v8='prof2';
    datalines;
n    .     265     265     265     265     265     265     265     265
cov v1 0.39600  .       .       .       .       .        .       .
cov v2 0.24000 0.44100  .       .       .       .        .       .
cov v3 0.03310 0.04383 0.21400  .       .       .        .       .
cov v4 0.03983 0.05242 0.12200 0.24400  .       .        .       .
cov v5 0.09002 0.08361 0.08825 0.08792 0.36000  .        .       .
cov v6 0.12700 0.15700 0.11300 0.11900 0.20800  0.36500  .       .
cov v7 0.06587 0.09230 0.09137 0.09284 0.20000  0.19700 0.48000  .
cov v8 0.10800 0.14000 0.11000 0.06940 0.17500  0.18400 0.19900 0.63400
;
ods output FactorPattern = facpat;
proc factor data=cmat        method=prin
                             priors=one
                             simple
                             scree
                             covariance;
var v1-v8;
run;
proc format;                        
      picture fuzzflag (round)
      low  - -0.40 = ' 99 *' (prefix='-' mult=100)
	  -.40 -  -.00 = ' 99  ' (prefix='-' mult=100)
      0.00 -  0.39 = ' 99  '  (mult=100)
      0.40 -  high = ' 99 *' (mult=100);           
run; 
proc print data = facpat;
      format factor1-factor3 FuzzFlag.;
run;
ods output FactorPattern = facpat;
title 'PCA of Performance Assessment Program using Correlation Matrix';
proc factor data=cmat        method=prin
                             priors=one
                             simple
                             scree
                             nfact=3;
var v1 -v8;
run;
proc format;                        
      picture fuzzflag (round)
      low  - -0.40 = '99 *' (prefix='-' mult=100)
	  -.40 -  -.00 = '99  ' (prefix='-' mult=100)
      0.00 -  0.39 = '99  '  (mult=100)
      0.40 -  high = '099 *' (mult=100);           
run; 
proc print data = facpat;
      format factor1-factor3 FuzzFlag.;
run;
