/***************************************************/
/* Program m8_6_1.sas                              */
/* Data from Smith, Gnanadesikan and Hughes (1962) */
/* Regression on Principal Components              */
/***************************************************/

options ls=80 nodate pageno=1 formdlim='o';


title1 ' Multivariate Regression on Principal Components';

data PCA;
   infile 'e:\smith.dat';
   input group $ y1 y2 y3 y4 y5 y6 y7 y8 y9 y10 y11 x1 x2 x3;
   label y1='pH'
         y2='createnine coeff'
		 y3='pigment createnee'
		 y4='phosphate'
		 y5='calcium'
		 y6='phosphours'
		 y7='createnine'
		 y8='chloride'
		 y9='bacon'
		 y10='choline'
		 y11='copper'
		 x1='volumn'
		 x2='spec gravity'
		 x3='weight';

proc print data=PCA;
run;

proc reg data=PCA;
     model x1 x2 x3 = y1 - y11 /vif;
     jOINT:mtest y1,y2,y3,y4,y5,y6,Y7,y8,y9,y10,y11/print;
run;
proc factor data=PCA method=prin score n=4 covariance
     outstat=work.prin_all;
     var y1 - y11;
run;

proc score data=PCA score=work.prin_all out=work.score;
     var y1 - y11;

run;
proc print data=work.score;

proc reg data=work.score;
     model X1 - X3 =FACTOR1 FACTOR2 FACTOR3 FACTOR4/vif;
     JOINT:mtest FACTOR1,FACTOR2,FACTOR3,FACTOR4/print;
     F1:mtest FACTOR1;
     F2:mtest FACTOR2;
     F3:mtest FACTOR3;
     F4:mtest FACTOR4;
run;
