/********************************************/
/* Program m8_8_2.sas                       */
/* Partial Canonical Correlation Analysis   */
/* Part Canonical Correlation Analysis      */
/* Project Talent Data                      */
/********************************************/

Options ls=80 nodate pageno=1 formdlim='o';

Title1 'Partial Canonical Correlation Analysis Talent Data';

DATA TIMMP(TYPE=CORR);
 _TYPE_ = 'CORR';
 INPUT _NAME_ $ G1 G2 VE VR VC NC NA NM IS IP IO;
 CARDS;
G1 1.000 . . . . . . . . . .
G2 .861 1.000 . . . . . . . . .
VE -.011 .062 1.000 . . . . . . . .
VR .573 .397 .055 1.000 . . . . . . .
VC -.349 -.234 .084 -.246 1.000 . . . . . .
NC .492 .550 .083 .094 .109 1.000 . . . . .
NA .698 .765 .021 .275 -.087 .613 1.000 . . . .
NM .644 .621 .001 .340 -.119 .418 .595 1.000 . . .
IS  .661 .519 -.075 .531 -.364 .160 .413 .522 1.000 . .
IP .487 .469 .007 .202 -.079 .456 .530 .433 .451 1.000 .
IO .761 .649 .030 .500 -.191 .566 .641 .556 .547 .517 1.000
;

Proc print data=timmp;
Proc cancorr smc corr pcorr redundancy all  edf=501;
     VAR     G1 G2;
     WITH    VE VR VC;
     PARTIAL NC NA NM IS IP IO;
run;

Title1 'Part Canonical Correlation Analysis Talent Data';


DATA TIMMR(TYPE=CORR);
 _TYPE_ ='CORR';
 INPUT _NAME_ $ Y1 Y2 Q1 Q2 Q3;
 Datalines;
Y1 1.000  .      .      .      .
Y2  .7951 1.000  .      .      .
Q1 -.0157 .0920 1.000   .      .
Q2  .3081 .1301  .1064 1.000   .
Q3 -.3055 -.1985 .0486 -.0265 1.000
;

Proc print data=timmr;

Proc cancorr smc corr redundancy all EDF=501;
     Var  Y1 Y2;
     With Q1 Q2 Q3;
run;
