/********************************************/
/* Program m9_4_1.sas                       */
/* Hierarchical Cluster Analysis            */
/* Protein Data obtained from DASL Web site */
/* http://lib.stat.cmu.edu/DASL/Datafiles/  */
/* protein.htn                              */
/********************************************/

Options ls=80 nodate pageno=1 formdlim='o';

Title 'Hierarchical Cluster Analysis';

Data Protein;
     Infile 'e:\protein.dat';
     input country  $ Rmeat Wmeat Eggs Milk Fish Cerl Starch Nuts Fr_Veg;
run;

proc print data=Protein;
run;
title 'Centroid Method';
proc cluster simple std method=centroid rmsstd nonorm rsquare pseudo outtree=dendogr;
     id country;
     var Rmeat Wmeat Eggs Milk Fish Cerl Starch Nuts Fr_veg;
run;
proc gplot data=dendogr;
     plot _psf_*_NCL_='F'   _pst2_*_NCL_ = 'T'/ overlay;
     plot _Dist_*_NCL_= 'D' _Rmsstd_*_NCL_='S'/overlay;
     plot _Rsq_*_NCL_='R'   _sprsq_*_NCL_='P'/ overlay;
run;
proc tree  data=dendogr out=clus6 nclusters=6;
     id country;
     copy Rmeat Wmeat Eggs Milk Fish Cerl Starch Nuts Fr_veg;
run;
proc sort;
     by cluster;
run;
proc print;
     by cluster;
     var country Rmeat Wmeat Eggs Milk Fish Cerl Starch Nuts Fr_veg;

run;
title 'Ward_s Method';
proc cluster std method=ward noeigen rmsstd nonorm rsquare pseudo outtree=dendogr;
     id country;
     var Rmeat Wmeat Eggs Milk Fish Cerl Starch Nuts Fr_veg;
run;
proc gplot data=dendogr;
     plot _psf_*_NCL_='F'   _pst2_*_NCL_ = 'T'/ overlay;
     plot _Dist_*_NCL_= 'D' _Rmsstd_*_NCL_= 'S'/overlay;
     plot _Rsq_*_NCL_='R'   _sprsq_*_NCL_='P'/ overlay;
run;
proc tree  data=dendogr out=clus6 nclusters=6;
     id country;
     copy Rmeat Wmeat Eggs Milk Fish Cerl Starch Nuts Fr_veg;
run;
proc sort;
     by cluster;
run;
proc print;
     by cluster;
     var country Rmeat Wmeat Eggs Milk Fish Cerl Starch Nuts Fr_veg;

run;
title 'Average Method ';
proc cluster std method=average noeigen rmsstd nonorm rsquare pseudo outtree=dendogr;
     id country;
     var Rmeat Wmeat Eggs Milk Fish Cerl Starch Nuts Fr_veg;
run;
proc gplot data=dendogr;
     plot _psf_*_NCL_='F'   _pst2_*_NCL_ = 'T'/ overlay;
     plot _Dist_*_NCL_= 'D' _Rmsstd_*_NCL_='S'/overlay;
     plot _Rsq_*_NCL_='R'   _sprsq_*_NCL_='P'/ overlay;
run;
proc tree  data=dendogr out=clus6 nclusters=6;
     id country;
     copy Rmeat Wmeat Eggs Milk Fish Cerl Starch Nuts Fr_veg;
run;
proc sort;
     by cluster;
run;
proc print;
     by cluster;
     var country Rmeat Wmeat Eggs Milk Fish Cerl Starch Nuts Fr_veg;

run;
title 'Complete Link Method';
proc cluster std method=complete noeigen nonorm rmsstd rsquare pseudo outtree=dendogr;
     id country;
     var Rmeat Wmeat Eggs Milk Fish Cerl Starch Nuts Fr_veg;
run;
proc gplot data=dendogr;
     plot _psf_*_NCL_='F'    _pst2_*_NCL_ = 'T'/ overlay;
     plot _height_*_NCL_='D' _Rmsstd_*_NCL_='S'/ overlay;
     plot _Rsq_*_NCL_ ='R' _sprsq_*_NCL_= 'P' / overlay;
run;
proc tree  data=dendogr out=clus6 nclusters=6;
     id country;
     copy Rmeat Wmeat Eggs Milk Fish Cerl Starch Nuts Fr_veg;
run;
proc sort;
     by cluster;
run;
proc print;
     by cluster;
     var country Rmeat Wmeat Eggs Milk Fish Cerl Starch Nuts Fr_veg;
run;
Title 'Single Link Method';
Proc cluster std method=single noeigen rmsstd nonorm rsquare pseudo outtree=dendogr;
     id country;
     var Rmeat Wmeat Eggs Milk Fish Cerl Starch Nuts Fr_veg;
run;
proc gplot data=dendogr;
     plot _pst2_*_NCL_ = 'T';
     plot _height_*_NCL_='D' _Rmsstd_*_NCL_='S'/ overlay;
     plot _Rsq_*_NCL_='R' _sprsq_*_NCL_='P' / overlay;
run;
proc tree  data=dendogr out=clus6 nclusters=6;
     id country;
     copy Rmeat Wmeat Eggs Milk Fish Cerl Starch Nuts Fr_veg;
run;
proc sort;
     by cluster;
run;
proc print;
     by cluster;
     var country Rmeat Wmeat Eggs Milk Fish Cerl Starch Nuts Fr_veg;
run;
