/********************************************/
/* Program m9_4_2.sas                       */
/* Nonierarchical Cluster Analysis          */
/* Protein Data obtained from DASL Web site */
/* http://lib.stat.cmu.edu/DASL/Datafiles/  */
/* protein.htn                              */
/********************************************/

Options ls=80 nodate pageno=1 formdlim='o';

Title 'Nonhierarchical Cluster Analysis';

Data Protein;

     Infile 'e:protein.dat';
     input country  $ Rmeat Wmeat Eggs Milk Fish Cerl Starch Nuts Fr_Veg;
run;

proc print data=Protein;
run;

proc standard mean=0 std=1 out=stand;
     var Rmeat Wmeat Eggs Milk Cerl Starch Nuts Fr_Veg;
run;

proc print data=stand;

title3 'Four Clusters';
proc fastclus data=stand
     radius=0 replace=full maxclusters=4 maxiter=20 out=new distance;
run;
proc sort;
     by cluster;
proc print;
     by cluster;
     var country Rmeat Wmeat Eggs Milk Fish Cerl Starch Nuts Fr_veg;
run;
proc candisc out=can short;
     var Rmeat Wmeat Eggs Milk Fish Cerl Starch Nuts Fr_veg;
     class cluster;
run;
proc gplot;
     plot can2*can1=cluster;
	 symbol1 v=triangle c=red;
	 symbol2 v=dot c=green;
	 symbol3 v=circle c=black;
	 symbol4 v=square c=purple;
	 symbol5 v=diamond c=orange;
	 symbol6 v=stare c=blue;
run;
title3 'Five Clusters';
proc fastclus data=stand
     radius=0 replace=full maxclusters=5 maxiter=20 out=new distance;
run;
proc sort;
     by cluster;
proc print;
     by cluster;
     var country Rmeat Wmeat Eggs Milk Fish Cerl Starch Nuts Fr_veg;
run;
proc candisc out=can short;
     var Rmeat Wmeat Eggs Milk Fish Cerl Starch Nuts Fr_veg;
     class cluster;
run;
proc gplot;
     plot can2*can1=cluster;
	 	 symbol1 v=triangle c=red;
	 symbol2 v=dot c=green;
	 symbol3 v=circle c=black;
	 symbol4 v=square c=purple;
	 symbol5 v=diamond c=orange;
	 symbol6 v=stare c=blue;
run;
title3 'Six Clusters with Random Seed';
proc fastclus data=stand
     radius=0 replace=full maxclusters=6 maxiter=20 out=new distance;
run;
proc sort;
     by cluster;
proc print;
     by cluster;
     var country Rmeat Wmeat Eggs Milk Fish Cerl Starch Nuts Fr_veg;
run;
proc candisc out=can short;
     var Rmeat Wmeat Eggs Milk Fish Cerl Starch Nuts Fr_veg;
     class cluster;
run;
proc gplot;
     plot can2*can1=cluster;
	 	 symbol1 v=triangle c=red;
	 symbol2 v=dot c=green;
	 symbol3 v=circle c=black;
	 symbol4 v=square c=purple;
	 symbol5 v=diamond c=orange;
	 symbol6 v=stare c=blue;
run;
data seed;
     infile 'E:\seed.dat';
     input country $ Rmeat Wmeat Eggs Milk Fish Cerl Starch Nuts Fr_Veg;
run;
title3 'Six Clusters with fixed seed';
proc fastclus data=stand
     radius=0 seed=seed replace=full maxclusters=6 maxiter=20 out=new distance;
run;
proc sort;
     by cluster;
proc print;
     by cluster;
     var country Rmeat Wmeat Eggs Milk Fish Cerl Starch Nuts Fr_veg;
run;
proc candisc out=can short;
     var Rmeat Wmeat Eggs Milk Fish Cerl Starch Nuts Fr_veg;
     class cluster;
run;
proc gplot;
     plot can2*can1=cluster;
	 	 symbol1 v=triangle c=red;
	 symbol2 v=dot c=green;
	 symbol3 v=circle c=black;
	 symbol4 v=square c=purple;
	 symbol5 v=diamond c=orange;
	 symbol6 v=stare c=blue;
run;
