/********************************************/
/* Program m9_4_3.sas                       */
/* Hierarchical Cluster Analysis            */
/* Teachers Perceptions of Need for Change  */
/* Napior(1972,p.163)                       */
/* Input a Similarity Matrix                */
/********************************************/

Options ls=80 nodate pageno=1 formdlim='o';

Title 'Hierarchical Cluster Analysis Dissimilarity Matrix';

Data Gamma(Type=corr);
      input (I1 I2 I3 I4 I5 I6 I7 I8 I9 I10
            I11 I12 I13 I14 I15 I16) (4.) @65 Item $ ;
      datalines;
1                                                               Item01
.67 1                                                           Item02
.69 .73 1                                                       Item03
.67 .67 .74 1                                                   Item04
.40 .28 .24 .38 1                                               Item05
.33 .21 .27 .27 .58 1                                           Item06
.41 .16 .31 .38 .60 .63 1                                       Item07
.26 .13 .20 .32 .62 .58 .75 1                                   Item08
.36 .32 .38 .41 .26 .28 .25 .21 1                               Item09
.36 .25 .38 .45 .29 .36 .34 .31 .62 1                           Item10
.34 .23 .35 .47 .27 .23 .32 .28 .60 .83 1                       Item11
.39 .38 .36 .34 .24 .29 .31 .23 .54 .47 .45 1                   Item12
.35 .32 .29 .31 .39 .36 .34 .31 .25 .31 .28 .39 1               Item13
.34 .31 .33 .35 .43 .49 .48 .44 .28 .40 .37 .33 .63 1           Item14
.29 .26 .25 .34 .42 .38 .45 .31 .22 .28 .28 .28 .46 .61 1       Item15
.30 .25 .29 .36 .38 .46 .45 .41 .32 .43 .37 .28 .50 .70 .62 1   Item16
;

proc print data=Gamma;

data dist(type=distance);
     array dt(16) i1-i16;
     set gamma;
     do i = 1 to 16;
     dt(i)=2*(1.-dt(i));
     end;
     keep i1-i16 item;
run;
proc print data=dist;
run;

proc cluster data=dist method=centroid pseudo outtree=dendogr;
     id item;
run;
proc gplot data=dendogr;
     plot _height_*_NCL_= 'D';
     run;
proc tree  data=dendogr out=clus4 nclusters=4;
     id item;
run;
proc sort;
     by cluster;
run;
proc print;
     by cluster;
     var item;
title3 'Cluster Solution Centroid Method';
run;
title3 ' ';
proc cluster data=dist method=ward noeigen rmsstd rsquare pseudo outtree=dendogr;
     id item;
run;
proc gplot data=dendogr;
     plot _psf_*_NCL_='F'   _pst2_*_NCL_ = 'T'/ overlay;
     plot _Height_*_NCL_= 'D' _Rmsstd_*_NCL_= 'S'/overlay;
     plot _Rsq_*_NCL_='R'   _sprsq_*_NCL_='P'/ overlay;
run;
proc tree  data=dendogr out=clus4 nclusters=4;
     id item;
run;
proc sort;
     by cluster;
run;
proc print;
     by cluster;
     var item;
title3 'Cluster Solution Wards Method';
run;
title3 ' ';
proc cluster data=dist method=average noeigen rmsstd rsquare pseudo outtree=dendogr;
     id item;
run;
proc gplot data=dendogr;
     plot _psf_*_NCL_='F'   _pst2_*_NCL_ = 'T'/ overlay;
     plot _height_*_NCL_= 'D' _Rmsstd_*_NCL_='S'/overlay;
     plot _Rsq_*_NCL_='R'   _sprsq_*_NCL_='P'/ overlay;
run;
proc tree  data=dendogr out=clus4 nclusters=4;
     id item;
run;
proc sort;
     by cluster;
run;
proc print;
     by cluster;
     var item;
title3 'Cluster Solution Average Method';
run;
title3 ' ';
proc cluster data=dist method=complete noeigen outtree=dendogr;
     id item;
run;
proc gplot data=dendogr;
     plot _height_*_NCL_='D';
     run;
proc tree  data=dendogr out=clus4 nclusters=4;
     id item;
run;
proc sort;
     by cluster;
run;
proc print;
     by cluster;
     var item;
title3 'Cluster Solution Complete Link Method';
run;
title3 ' ';
proc cluster data=dist method=single noeigen outtree=dendogr;
     id item;
run;
proc gplot data=dendogr;
     plot _height_*_NCL_='D';
     
run;
proc tree  data=dendogr out=clus4 nclusters=4;
     id item;
run;
proc sort;
     by cluster;
run;
proc print;
     by cluster;
     var item;
title3 'Cluster Solution Single Link Method';
run;
