/********************************************/
/* Program m9_6_1.sas                       */
/* Multidimensional Scaling                 */
/* City Distance Data                       */
/* Input a Distance  Matrix                 */
/********************************************/

Options ls=80 nodate pageno=1 formdlim='o';

Title ' Dissimilarity Matrix of Road Miles among US Cities';

Data City(Type=distance);
      input (Ch Ho Ny Sf) (5.) @ 21 City $;
      datalines;
   0                 Chicago
1212    0            Houston
 813 1667    0       NewYork
2156 1950 2927     0 SFrisco
;
proc print data=City;
run;

proc mds data=city outres=res pfinal
              level=absolute dimension=2  out=out;
     id city;
run;

proc plot data=out vtoh=1.65;
     plot dim2*dim1 $ city/haxis=by 500 vaxis=by 500;
     where _type_ ='CONFIG';
run;
proc print data=res;

run;
title 'fit';
proc plot data=res;
     plot fitdist*fitdata;
     plot residual*fitdata;
run;
