/********************************************/
/* Program m9_6_3.sas                       */
/* Multidimensional Scaling                 */
/* Kruskal and Wish Nations Data            */
/* Kruskal and Wish (1978, p. 31)           */
/* Input a Similarity  Matrix               */
/********************************************/

Options ls=80 nodate pageno=1 formdlim='o';

Title 'Input Similarity Matrix for Nations Data';

Data Nations(Type=distance);
      input (Brz Con Cub Egy Fra Ind Isr Jpn Chi Rus Usa Yug) (5.) @61 country $ ;
      datalines;
0                                                           Brazel
4.83 0                                                      Congo
5.28 4.56 0                                                 Cuba
3.44 5.00 5.17 0                                            Egypt
4.72 4.00 4.11 4.78 0                                       France
4.50 4.83 4.00 5.83 3.44 0                                  India
3.83 3.33 3.61 4.67 4.00 4.11 0                             Israel
3.50 3.39 2.94 3.83 4.22 4.50 4.83 0                        Japan
2.39 4.00 5.50 4.39 3.67 4.11 3.00 4.17 0                   China
3.06 3.39 5.44 4.39 5.06 4.50 4.17 4.61 5.72 0              USSR
5.39 2.39 3.17 3.33 5.94 4.28 5.94 6.06 2.56 5.00 0         USA
3.17 3.50 5.11 4.28 4.72 4.00 4.44 4.28 5.06 6.67 3.56 0    Yugoslavia
;

proc print data=Nations;
run;
title2 'One dimensional Nations Solution';
proc mds data=nations outres=res1 pfinal similar=6.67
              level=ordinal dimension=1  out=out1;
     id country;
run;
proc plot data=res1;
     plot fitdist*residual;
run;
title2 'Two dimensional Nations Solution';
proc mds data=nations outres=res2 pfinal similar=6.67
              level=ordinal dimension=2  out=out2;
     id country;
run;
proc print data=res2;
run;
proc plot data=res2;
     plot fitdist*residual;
run;
proc plot data=out2 vtoh=1.7;
     plot dim2*dim1 $ country/haxis=by .5 vaxis=by .5;
     where _type_ ='CONFIG';
run;
title2 'Three dimensional Nations Solution';
proc mds data=nations outres=res3 pfinal similar=6.67
              level=ordinal dimension=3  out=out3;
     id country;
run;
proc print data=res3;
proc plot data=out3 vtoh=1.7;
     plot dim2*dim1 $ country/haxis=by .5 vaxis=by .5;
     where _type_ ='CONFIG';
run;
proc plot data=res3;
     plot fitdist*residual;
     plot fitdist*fitdata;
run;
title2 'Four Dimensional Nations Solution';
proc mds data=nations outres=res4 pfinal similar=6.67
              level=ordinal dimension=4  out=out4;
     id country;
run;
proc plot data=res3;
     plot fitdist*residual;
run;
