/*--------------------------------------------------------------------------*
                                S A S   Program
                        Multivariate Subset Selection
                                      By:
                               Ali A. Al-Subaihi
                        Research Methodology Program
                     Psychology in Education Department
                             School of Education
                           University of Pittsburgh


     The program designed to give the subset of predictors (x's)
 (independent variables) that "best" predict all dependent variables (y's)
 jointly according to the multivariate version of the following criteria:
 1) Automatic Search Procedures, which contains
        a) Forward Selection
        b) Backward Elimination
        c) Forward Stepwise Selection
 The procedures are based on Wilks' Lambda (for details, see Rancher, pp.
 383-385, 1995).
 2) All-Possible-Regression Procedures, which are
        a) Residual Mean Square Error (Rencher, 1995)
        b) Mallow's Cp (Spark et al., 1983)
        c) Akaike's Information Criterion (AIC)(Akaike, 1973)
        d) The Corrected Form of AIC (AICC) (McQuarrie & Tsai, 1998)
        e) The Corrected Form of Hannan and Quinn (HQ) Information Criterion
           (McQuarrie & Tsai, 1998)
        f) Schwarz Criterion (BIC) (Schwarz, 1978)
        g) Hannan and Quinn Criterion (HQIC) (Hannan and Quinn, 1979)

     The program works as follows:
 1) Go to the end of the program and delete the provided data. Past your data
    in the same place and way the old data used to be.
 2) Adjust the matrices X and Y so that they read your independent and
    dependent variables, respectively.
 3) Save the changes and submit the program.

 Notes:
 1) The program designed to use the determent function to reduce all matrices
    into scalar.
 2) The program has no problem in case of 9 predictors were used, however the
    FW, in the RESET statement, needs to be increased by 2 digits for each
    extra predictor. For example, Fw=11 in case of 10 predictors were used,
    FW=13 if 11 predictors were used, and so on. If this adjustment was not
    made, variables' names will be changed.
 3) Because the nature of the multivariate version of the Cp is different from
    the univariate, the criteria could suggest more than one subset of
    predictors.
 4) The author is working in updating this program by adding a new subset
    selection procedure that is called reduced rank regression (RRR) procedure.
 5) To have complete output, print the output in landscape orientation.

 References

 1) Akaike, H. (1973), "Information Theory and an Extension of The Maximum
        Likelihood Principle", In B.N. Petrov and F. Csaki ed., 2nd
        International Symposium on Information Theory, pp. 267-281, Akademia
        Kiado, Budapest.
 2) Hannan, E.J. and quinn, B.G. (1979), " The Determination of the Order of
        an Autoregression", Journal of the Royal Statistical Society, Series
        B, 41, 190-195.
 3) McQuarrie A. D., and Tsai, C. (1998), "Regression and Time Series Model
        Selection", World Scientific Publishing Co. Pte. Ltd., River Edge, NJ.
 4) Rencher, A. C. (1995), "Methods of Multivariate Analysis",
        John Wiley & Sons Inc., New York, New York.
 5) Schwarz, M.J. (1978), " Estimating the Dimension of a Model" Annals of
        Statistics, 6,461-464.
 6) Spark, R.S., Coutsourides, D. and Troskie, L. (1983), " The Multivariate
        Cp", Communications in Statistics-Theory and Methods, 12, 1775-1793.
 7) Timm, N. H. (1975), Multivariate Analysis With Applications in Education
        and Psychology, Wadsworth Publishing Company, Inc., Belmont,
        California 94002.

*--------------------------------------------------------------------------*/
 PROC IML;
 Reset  FW= 9 noname linesize=100 pagesize=30 nodate pageno=1 formdlim='o';

START INITIAL;                   /*----Initialization Module ---*/
  N=NROW(X);                     /* Number of Observations      */
  K=NCOL(X);                     /* Total No. of ind. var.      */
  Q=NCOL(Y);                     /* Total No. of dep. var.      */
  K1=K+1;                        /* No. of ind. + intercept     */
  IK=1:K;                        /* Ind. var. names (1 2 .. k)  */
  Test=1;                        /* Initial prob. to enter var. */
  R1=0:(q-1);                    /* Rank's values               */
                                 /* (Names of all ind. var.     */
  ALL_idv=num(rowcatc(char(ik)));/* ordered from 1-k )          */
  F_Enter=Int(finv(.95,1,(n-k)));/* Min acceptable F to Enter   */
  F_Rmv=F_Enter-.1;              /* Max acceptable F to Remove  */
  Lm_ENTER=(n-k)/(F_Enter+(n-k));/* Max acceptable Lm to enter  */
  Lm_RMV=(n-k)/(F_Rmv+(n-k));    /* Min acceptable Lm to remove */
  BNAMES={VAR MSE RSQUARE Cp UpLm/*                             */
         AICc HQ AIC BIC HQIC};  /*                             */
                                 /*                             */
  /*---CORRECT BY MEAN, ADJUST OUT INTERCEPT PARAMETER----------*/
  Y=Y-REPEAT(Y[+,]/N,N,1);       /* CORRECT Y BY MEAN           */
  X=X-REPEAT(X[+,]/N,N,1);       /* CORRECT X BY MEAN           */
  H=X*INV(X`*X)*X`;              /* H matrix                    */
  YP=Y[+,]/N;                    /* MEANS OF COLUMNS OF Y       */
  XPY=X`*Y;                      /* CROSSPRODUCTS               */
  YPY=Y`*Y;                      /*                             */
  XPX=X`*X;                      /*                             */
  SSEk=y`*(I(n)-H)*y;            /* Sum sq. of err. for all x's */
  SSTO= YPY-(N*YP`*YP);          /* Total sum square of error   */
  CONST= det(SSTO);              /* Determinant of SSTO matrix  */
  CSAVE=(XPX || XPY) //          /*                             */
        (XPY`|| YPY);            /* SAVED COPY OF CROSSPRODUCTS */
FINISH INITIAL;                  /*---- Ends Initialization ----*/


/*-------------- Automatic Search Procedures ------------------------------*/
START STEPWISE;

/*------------------- Start of Partial Lambda Module ----------------------*/
START Lm_PART;                             /*----- Wilk's Lambda Module ---*/
      FREE Lm_VAL;                         /*                              */
        Xs=Indx;                           /*                              */
        LmName={ Lm_Values Ind};           /* Columns' names               */
        DO I=1 TO NCOL(X_TEMP);            /*                              */
          X1=COL_IN||X_TEMP[,I];           /*                              */
          B=INV(X1`*X1)*X1`*Y;             /* COEFFICIENT MATRIX (B)       */
          LEM=DET(YPY-(B`*X1`*Y))/CONST;   /*                              */
          Lm_VAL=Lm_VAL//(LEM/Lm_d);       /* Val. of Partial Wilk's Lambda*/
          FREE X1;                         /*                              */
        END;                               /*                              */
     Xs=Lm_Val||Num(rowcatc(char(Xs)));    /* Lambda values with x's       */
     Xs_old=Xs;                            /*                              */
     Xs[(rank(Xs[,1]))`,]=Xs_Old;          /* Ordering Lambda values (A-Z) */
     Lm_IN=Xs[1,1];                        /* Min value Par. Wilks Lambda  */
                                           /*------------------------------*/
       If Nindx=0 then do;                 /*          Initial Step        */
          print ,'Max acceptable Lambda to enter' Lm_Enter;
          print ,"Lambda to enter given no Ind. var. already in the model";
          print  xs[ColName=LmName];       /* Lambda to enter              */
           If lm_in<Lm_ENTER then do;      /*                              */
           Sug=Xs[1,];                     /*                              */
           print Sug "  To be entered";    /*                              */
     print '---------------------------------------------------------------';
           End;                            /*                              */
           If lm_in >= Lm_ENTER then do;   /*                              */
           print 'Nothing to be entered';  /*                              */
     print '---------------------------------------------------------------';
           Test=0; ind=0;                  /*                              */
           End;                            /*                              */
       End;                                /*       Ends intial step       */
                                           /*                              */
                                           /*------------------------------*/
     If Nindx>0 then do;                   /*        Next Steps            */
     Ind=Nindx`;                           /*                              */
     Ind_old=Ind;                          /*                              */
     Ind[(Rank(Ind[,1]))`,]=Ind_Old;       /*                              */
     Ind=num(rowcatc(char(ind`)));         /* Var. already in the model    */
     print ,'Max acceptable Lambda to enter' Lm_Enter;
     print "Lambda to enter given=" Ind;   /*                              */
     print xs[ColName=LmName];             /* Lambda to enter              */
           If lm_in<Lm_ENTER then do;      /*                              */
           Sug=Xs[1,];                     /*                              */
           print Sug "  To be entered";    /*                              */
     print '---------------------------------------------------------------';
           End;                            /*                              */
           If lm_in >= Lm_ENTER then do;   /*                              */
           print 'Nothing to be entered';  /*                              */
     print '---------------------------------------------------------------';
           Test=0;                         /*                              */
           End;                            /*                              */
     End;                                  /*         Ends next step       */
                                           /*                              */
      If Nrow(Xs)>1 then                   /*                              */
     Indx=Xs[2:Nrow(Xs),2];                /* COLUMNS TO  BE FITTED        */
      Else Indx=Xs[Nrow(Xs),2];            /*                              */
     Nindx2=Xs[1,2]||Nindx2;               /*                              */
     Nindx=Nindx2;                         /* Columns already in the model */
FINISH Lm_PART;                            /*------ End of the module -----*/
/*------------------- End of Partial Lambda Module ------------------------*/

/*-------------------- (a) Forward Selection ------------------------------*/
      print /, 'Automatic Search Procedures',, '(a) Forward Selection',
          '----------------------------------------------------------------';

   COL_IN=J(N,1);    /*----------------- Step 1 --------------------*/
   X_TEMP=X;         /* Where to fit each x individually            */
   Lm_d=1;           /* When no x selected                          */
   INDX=Ik`;         /* COLUMNS TO  BE FITTED ONE BY ONE (HERE ALL) */
   NINDX=0;          /* COLUMNS ALREADY IN THE MODEL (HERE NONE)    */
   RUN Lm_PART;      /*                                             */
   P=Ncol(nindx2);   /* No. of variables in the model               */
                     /*------------ End of step 1 ------------------*/

 DO Until (Test=0);                             /* ------------ Step 2 ----------*/
   COL_IN=X[,Nindx];                            /* Columns already in the model  */
   HcoL=col_in*inv(col_in`*col_in)*col_in`;     /*                               */
   SScol=y`*(I(n)-HcoL)*y;                      /* (Wilk's Lem. for var. already */
   Lm_d=det(SScol)/const;                       /*  in the model)                */
   X_TEMP=X[,Indx`];                            /* Columns did not enter yet     */
   P=NCOL(nindx2);                              /* NO. OF VAR. IN THE MODEL      */
   If Ncol(nindx)=k then do;                    /* Check if the last var. entered*/
    Ind=Nindx`;                                 /*                               */
    Ind_old=Ind;                                /*                               */
    Ind[(Rank(Ind[,1]))`,]=Ind_Old;             /*                               */
    Ind=num(rowcatc(char(ind`)));               /* Var. already in the model     */
     Goto Skip;                                 /* Stop if the last var. entered */
   End;                                         /* Ends of if condition          */
   If test=0 then goto skip1;                   /*                               */
   RUN Lm_PART;                                 /*                               */
 END;                                           /* Ends of Do loop               */
 Skip1: Forward=ind;                            /*                               */
 Free Xs;                                       /*                               */
 If ind=0 then                                  /*                               */
 print 'Forward Selection Procedure Failed to Find The Best Subset';
 Else                                           /*                               */
 print 'The Best Subset of Predictors is 'ind;  /*-------- End of step 2 --------*/
 Free ind nindx2;

/*-------------------- (b) Backward Elimination -----------------------------*/
      print /, 'Automatic Search Procedures',, '(b) Backward Elimination',
          '----------------------------------------------------------------';
   Nindx=Ik;
   Free Lm_Val;
   Test=1;
   X_TEMP=X[,NINDX];                      /* Data matrix containing all col*/
   LmName={Given Lm_Val Ind};             /*                               */
        Do until (Test=0);                /*                               */
   DO J=NCOL(NINDX) to 1 by -1;           /*                               */
                                          /*                               */
        If ncol(nindx)=1 then do;         /*                               */
         indx_b=nindx;                    /*                               */
         CO_IN=J(N,1)||X_TEMP[,Indx_b];   /*                               */
         XX1=CO_IN;                       /*                               */
         BB1=INV(XX1`*XX1)*XX1`*Y;        /*                               */
         LEM_XX=DET(YPY-(BB1`*XX1`*Y));   /* Wilks' Lam. for X's already in*/
                                          /*                               */
         X1=X;                            /*                               */
         B=INV(X1`*X1)*X1`*Y;             /*                               */
         LEM_TOT=DET(YPY-(B`*X1`*Y));     /* Wilk's Lambda for all X's     */
                                          /*                               */
         Lm_VAL=Lm_VAL//((LEM_TOT/LEM_XX));/* Values of Partial-Lambda     */
         FREE X1;                         /*                               */
         Cin1=indx_b;                     /* Columns already in the model  */
         Notin=0;                         /* Columns not in the model yet  */
         Test=0;                          /*                               */
         Xs=Lm_Val||Cin1;                 /*                               */
         Lm_Out=Xs[,1];                   /* Max values of Wilks' lambda   */
         print ,'Min acceptable Lambda to remove' Lm_rmv;
         print ,"Lambda to remove";       /*                               */
         print  Xs[Colname=LmName];       /*                               */
         Goto skip5;                      /*                               */
        end;                              /* Ends of if condition          */
                                          /*                               */
        If ncol(nindx)>1 then do;         /*                               */
         IM=Repeat(0,Ncol(NINDX),1);      /*                               */
         Im[j,]=^Im[j,];                  /*                               */
         Indx_b=Loc(^im);                 /* COLUMNS ALREADY IN THE MODEL  */
         Nindx_b=loc(im);                 /* COLUMNS NOT IN THE MODEL      */
                                          /*                               */
         CO_IN=J(N,1)||X_TEMP[,Indx_b];   /*                               */
                                          /*                               */
         XX1=CO_IN;                       /*                               */
         BB1=INV(XX1`*XX1)*XX1`*Y;        /*                               */
         LEM_XX=DET(YPY-(BB1`*XX1`*Y));   /* Wilks' Lam. for X's already in*/
                                          /*                               */
         X1=CO_IN||X_TEMP[,NIndx_b];      /*                               */
         B=INV(X1`*X1)*X1`*Y;             /*                               */
         LEM_TOT=DET(YPY-(B`*X1`*Y));     /* Wilk's Lambda for all X's     */
                                          /*                               */
         Lm_VAL=Lm_VAL//((LEM_TOT/LEM_XX));/* Values of Partial-Lambda     */
         FREE X1;                         /*                               */
         Cin1=Cin1//Nindx[,indx_b];       /* Columns already in the model  */
         Notin=notin//Nindx[,nindx_b];    /* Columns not in the model yet  */
        end;                              /* Ends if condition             */
     End;                                 /*                               */
    Cin=Num(rowcatc(char(Cin1)));         /*                               */
    Xs=Cin||Lm_Val||notin;                /*                               */
    Xs_old=Xs;                            /*                               */
    Xs[(rank(Xs[,1]))`,]=Xs_Old;          /* Ordering Lambda values (A-Z)  */
    Lm_Out=Xs[<>,2];                      /* Max values of Wilks' lambda   */
    print ,'Min acceptable Lambda to remove' Lm_rmv;
    print ,"Lambda to remove";            /*                               */
    print  Xs[Colname=LmName];            /*                               */
          aa=Xs[<:>,2];                   /*                               */
          aa=Char(Xs[aa,1]);              /*                               */
          ab=length(aa);                  /*                               */
          Do i7=nrow(Cin1)-2 to 0 by -1;  /*                               */
          ac=ac||Substr(aa,(ab-i7),1);    /*                               */
          End;                            /*                               */
          Nindx=Num(ac);                  /* THE MIN. ACCEPTABLE Lm TO RMV.*/
          free ac;                        /*                               */
    Skip5:                                /*                               */
    IF Lm_Out>Lm_RMV THEN do;             /*                               */
         if test=0 then do;               /*                               */
         sug=Xs[,2:3];                    /*                               */
         print sug '       To be removed',/*                               */
               '-----------------------------------------------------------',
         'The Backward Procedure Failed to Find the Best Subset of Predictors',
               '-----------------------------------------------------------';
         Backward=0;                      /*                               */
         end;                             /*                               */
         if test=1 then do;               /*                               */
         sug=Xs[<:>,2];                   /*                               */
         sug=Xs[Sug,];                    /*                               */
         print sug '    To be removed';   /*                               */
         print '-----------------------------------------------------------';
         end;                             /*                               */
    End;                                  /*                               */
    IF Lm_Out<= Lm_RMV then do;           /*                               */
        print 'Nothing to be removed';    /*                               */
        print '------------------------------------------------------------';
        Not_old=Notin;                    /*                               */
        Notin[(rank(Notin[,1]))`,]=Not_Old;
        Notin=Num(rowcatc(char(Notin)`)); /*                               */
        if test=0 then Backward=Cin1;     /*                               */
        if test=1 then Backward=Notin;    /*                               */
        Test=0;                           /*                               */
        print 'The Best Subset of Predictors is ' Backward;
    End;                                  /*                               */
    Free Lm_Val Cin Cin1 Notin;           /*                               */
   End;                                   /*                               */
/*-------------------- (c) Forward Stepwise Selection ---------------------*/
   print /,'Automatic Search Procedures',,'(c) Forward Stepwise Selection',
          '----------------------------------------------------------------';
   Test=1;
   COL_IN=J(N,1);    /*----------------- Step 1 --------------------*/
   X_TEMP=X;         /* Where to fit each x individually            */
   Lm_d=1;           /* When no x selected                          */
   INDX=Ik`;         /* COLUMNS TO  BE FITTED ONE BY ONE (HERE ALL) */
   NINDX=0;          /* COLUMNS ALREADY IN THE MODEL (HERE NONE)    */
   RUN Lm_PART;      /*                                             */
   If test=0 then goto skip; /* Stop if no var. entered in this step*/
   P=Ncol(nindx2);   /* No. of variables in the model               */
                     /*------------ End of step 1 ------------------*/


   COL_IN=X[,Nindx];                            /*------------- Step 2 ----------*/
   HcoL=col_in*inv(col_in`*col_in)*col_in`;     /*                               */
   SScol=y`*(I(n)-HcoL)*y;                      /* (Wilk's Lem. for var. already */
   Lm_d=det(SScol)/const;                       /*  in the model)                */
   X_TEMP=X[,Indx`];                            /* Where to fit each x given one */
   RUN Lm_PART;                                 /* of x's already in the model   */
   If test=0 then goto skip;                    /* Stop if no var. entered here  */
   P=NCOL(nindx2);                              /* NO. OF VAR. IN THE MODEL      */
                                                /*-------- End of step 2 --------*/

 DO WHILE(P<k);                                 /* ------------ Step 3 ----------*/
   RUN BACKSTEP;                                /* BACKSTEP MODULE               */
   COL_IN=J(N,1)||X[,Nindx];                    /* Columns already in the model  */
   HcoL=col_in*inv(col_in`*col_in)*col_in`;
   SScol=y`*(I(n)-HcoL)*y;                      /* (Wilk's Lem. for var. already */
   Lm_d=det(SScol)/const;                       /*  in the model)                */
   X_TEMP=X[,Indx`];                            /* Columns did not enter yet     */
   P=NCOL(nindx2);                              /* NO. OF VAR. IN THE MODEL      */
   If Ncol(nindx)=k then do;                    /* Check if the last var. entered*/
    Ind=Nindx`;                                 /*                               */
    Ind_old=Ind;                                /*                               */
    Ind[(Rank(Ind[,1]))`,]=Ind_Old;             /*                               */
    Ind=num(rowcatc(char(ind`)));               /* Var. already in the model     */
     Goto Skip;                                 /* Stop if the last var. entered */
   End;                                         /*                               */
   If test=0 then goto skip;                    /*                               */
   RUN Lm_PART;                                 /*                               */
   If test=0 then goto skip;                    /*                               */
 END;                                           /*                               */
 Skip: Step=ind;                                /*                               */
 Free Xs;                                       /*                               */
 If ind=0 then                                  /*                               */
 print 'The Forward Stepwise Selection Failed to Find The Best Subset of Predictors';
 Else                                           /*                               */
 print 'The Best Subset of Predictors is 'ind;  /*-------- End of step 3 --------*/

FINISH STEPWISE;
/*-------------------- End of Automatic Search Module ---------------------------*/

  /*------------- ROUTINE TO BACKWARDS-ELIMINATE FOR STEPWISE -------------*/
START BACKSTEP;
   FREE Lm_VAL;
   X_TEMP=X[,NINDX];      /* DATA MATRIX W. COL. ENTERED FROM FORWARD STEP */
   LmName={Given Lm_Val Ind};             /*                               */
   DO J=2 TO NCOL(NINDX);                 /*                               */
        IM=Repeat(0,Ncol(NINDX),1);       /*                               */
        Im[j,]=^Im[j,];                   /*                               */
        Indx_b=Loc(^im);                  /* COLUMNS ALREADY IN THE MODEL  */
        Nindx_b=loc(im);                  /* COLUMNS NOT IN THE MODEL      */
                                          /*                               */
        CO_IN=J(N,1)||X_TEMP[,Indx_b];    /*                               */
                                          /*                               */
        XX1=CO_IN;                        /*                               */
        BB1=INV(XX1`*XX1)*XX1`*Y;         /*                               */
        LEM_XX=DET(YPY-(BB1`*XX1`*Y));    /* Wilks' Lam. for X's already in*/
                                          /*                               */
        X1=CO_IN||X_TEMP[,NIndx_b];       /*                               */
        B=INV(X1`*X1)*X1`*Y;              /*                               */
        LEM_TOT=DET(YPY-(B`*X1`*Y));      /* Wilk's Lambda for all X's     */
                                          /*                               */
        Lm_VAL=Lm_VAL//((LEM_TOT/LEM_XX));/* Values of Partial-Lambda      */
        FREE X1;                          /*                               */
     Cin=Cin//Nindx[,indx_b];             /* Columns already in the model  */
     Notin=notin//Nindx[,nindx_b];        /* Columns not in the model yet  */
   END;                                   /*                               */
    Cin=Num(rowcatc(char(Cin)));          /*                               */
    Xs=Cin||Lm_Val||notin;                /*                               */
    Xs_old=Xs;                            /*                               */
    Xs[(rank(Xs[,2]))`,]=Xs_Old;          /* Ordering Lambda values (A-Z)  */
    Lm_Out=Xs[Nrow(indx_b),2];            /* Max values of Wilks' lambda   */
    print ,'Min acceptable Lambda to remove' Lm_rmv;
    print ,"Lambda to remove";            /*                               */
    print  Xs[Colname=LmName];            /*                               */
    IF Lm_Out>Lm_RMV THEN do;             /*                               */
       If Nrow(indx_b)=1 then do;         /*                               */
          aa=char(Xs[1,1]);               /*                               */
          ab=length(aa);                  /*                               */
          Do i7=nrow(Notin)-1 to 0 by -1; /*                               */
          ac=ac||Substr(aa,(ab-i7),1);    /*                               */
          End;                            /*                               */
          Nindx=Num(ac);                  /* THE MIN. ACCEPTABLE Lm TO RMV.*/
       End;                               /*                               */
                                          /*                               */
       If Nrow(indx_b)=k-1 then test=0;   /*                               */
                                          /*                               */
       If Nrow(indx_b)>1 then do;         /*                               */
         Nindx=Xs[1:(Nrow(indx_b)-1),3];  /* THE MIN. ACCEPTABLE Lm TO RMV.*/
         sug=Xs[Nrow(indx_b),];           /*                               */
         print sug '    To be removed';   /*                               */
       End;                               /*                               */
    End;                                  /*                               */
    Else print 'Nothing to be removed';   /*                               */
    print '----------------------------------------------------------------';
    Free Cin Notin;                       /*                               */
FINISH BACKSTEP;                          /*-------------------------------*/
/*-------------------- End of Backstep Module -----------------------------*/
/*---------------------SEARCH ALL POSSIBLE MODELS--------------------------*/
START ALL;
   print /'All Possible Selection Methods',
   '--------------------------------------------------------------------';
  /*------USE METHOD OF SCHATZOFF ET AL. FOR SEARCH TECHNIQUE--------------*/
                                        /*----- Start of the module ---- */
  LIMIT=2##K-1;                         /* NUMBER OF MODELS TO EXAMINE   */
                                        /*                               */
 C=CSAVE; IN=REPEAT(0,K,1);             /* START WITH NO VAR. IN MODEL   */
                                        /*                               */
      DO kk=1 TO LIMIT;                 /*                               */
        RUN ZTRAIL;                     /* FIND WHICH ONE TO SWEEP       */
        RUN SWP;                        /* SWEEP IT IN                   */
   BB=BB//(VAR_IN||MSE||RSQ||Cp         /*                               */
        ||UpLm||AICp||HQp||AIC||BICp    /*                               */
        ||HBICp);                       /*                               */
        END;                            /*                               */
        ALL_P=BB;                       /* Sorting the output matrix     */
        BB[(RANK(BB[,1]))`,]=ALL_P;     /* to the variable names         */
                                        /*                               */
                                        /*                               */
                                        /*-------------- end ------------*/
        Counter=0;                      /*                               */
        Do jj=1 to nrow(bb);            /*                               */
         If (bb[jj,2]<=bb[nrow(bb),2]) then do;
         Counter=Counter+1;             /*                               */
         b_mse=b_mse//bb[jj,1:2];       /*                               */
         end;                           /*(finding the |MSEp|<|MSEk|     */
        End;                            /* & indv < total ind. variables)*/
        If Counter=0 then b_mse=All_idv;/*                               */
        Else do;                        /*                               */
          ind=b_mse[>:<,2];             /* Index's location of MSEp' min */
          b_mse=b_mse[ind,1];           /* Best subset according to MSEp */
        End;                            /*                               */
        Counter=0;                      /*                               */
                                        /*                               */
        Do jj=1 to nrow(bb);            /*                               */
         If (bb[jj,4]<=bb[jj,5]) & (bb[jj,1]<all_idv) then do;
         Counter=Counter+1;             /*                               */
         cp2=cp2//(Counter||bb[jj,1]);  /*                               */
         end;                           /*(finding the |Cp|<= UpperLimit */
        End;                            /* & indv < total ind. variables)*/
        If Counter=0 then b_Cp=All_idv; /* Set all ind. var. when Cp>UpLm*/
        Else b_Cp=cp2;                  /* Best subset according to Cp   */
        ind=bb[>:<,6];                  /* AICcp corrected form of AICp  */
        b_AICC=bb[ind,1];               /* Best subset according to AICcp*/
        ind=bb[>:<,7];                  /* Locate the index of min of HQp*/
        b_HQ=bb[ind,1];                 /* Best subset according to HQp  */
        ind=bb[>:<,8];                  /* Locate the index of min of AIC*/
        b_AIC=bb[ind,1];                /* Best subset according to AIC  */
        ind=bb[>:<,9];                  /* Index's location of BICp' min */
        b_BIC=bb[ind,1];                /* Best subset according to BICp */
        ind=bb[>:<,10];                 /* Index's location of HBICp' min*/
        b_HQIC=bb[ind,1];               /* Best subset according to HBICp*/
        BB=ROUND(BB,.001);              /*                               */
        print BB[colname=bnames ];      /*                               */
        F_out=Forward//Backward//Step//b_mse//b_aicc//b_hq//b_aic//b_bic
              //b_hQic;
        F2_out={Forward, Backward, Stepwise,MSE, AICc,HQ, AIC,BIC, HQIC};
        F3_out=b_cp;
        F4_out={No, Cp};

  print /'-----------------------------------------------------------------',
        'Summary',
        '------------------------------------------------------------------',
        F_out[RowName=F2_out],
        F3_out[ColName=F4_out],
        '------------------------------------------------------------------';
FINISH ALL;
/*-------------------------- End of All Module ----------------------------*/

 /*-------------------------------------------------------------*
  : SUBROUTINE TO FIND NUMBER OF TRAILING ZEROS IN BINARY NUMBER:
  : ON ENTRY: kk IS THE NUMBER TO EXAMINE                       :
  : ON EXIT:  II HAS THE RESULT                                 :
  *-------------------------------------------------------------*/
START ZTRAIL;
    II=1; ZZ=kk;
    DO WHILE(MOD(ZZ,2)=0); II=II+1; ZZ=ZZ/2; END;
FINISH ZTRAIL;
 /*-------------------------------------------------------------*
  :              SUBROUTINE TO SWEEP IN A PIVOT                 :
  : ON ENTRY: II HAS THE POSITION(S) TO PIVOT                   :
  : ON EXIT:  IN, L, DFE, MSE, RSQ RECALCULATED                 :
  *-------------------------------------------------------------*/
START SWP;
     IF ABS(C[II,II])<1E-9 THEN DO; print , "FAILURE", C;STOP;END;
     C=SWEEP(C,II);
     IN[II,]=^IN[II,];
     L=SUM(IN); DFE=N-L;
     Xp=X[,loc(in)];                                    /* Xp matrix         */
     Hp=Xp*inv(Xp`*Xp)*Xp`;                             /* Hp matrix         */
     SSE=C[(K1:nrow(csave)),(K1:ncol(csave))];          /* Sum Sq. error     */
     SSR=Y`*(Hp-(J(n)/n))*Y;                            /* Sum Sq. reg.      */
     MSE=det(SSE/DFE);                                  /* Mean SS error     */
     RSQ=det(Inv(SSTO)*SSR);                            /* R squared         */
     Cp=(N-K)*INV(SSEk)*SSE+(2*L-N)*I(q);               /* Cp Criterion      */
     Cp=det((Cp+(n-2*L)*I(q))/(n-k));                   /* Det. of Cp        */
     UpLm=((n-L)/(n-k1))**q;                            /* Upper limit of Cp */
     Aic=n*log(det(SSE))+2*(k+1)*L+L*(L+1);             /* AICp Method       */
     AICp=log(det(SSE))+(n+L)*q/(n-L-q-1);              /* AICp Corrected    */
     BICp=n*log(det(SSE))+(K+1)*L*LOG(n);               /* BICp Criterion    */
     HBICp=n*log(det(SSE))+2*(K+1)*L*LOG(LOG(n));       /* HQICp Criterion   */
     HQp=log(det(SSE**2))+((2*LOG(LOG(N))*Q*L)/(N-L-Q-1));
     VAR_IN=Num(ROWCATC(CHAR(LOC(IN))));                /* Ind. Var. names   */
FINISH SWP;
/*-------------------------- End of SWP Module ----------------------------*/

START SEQ;
  RUN INITIAL;                                          /* INITIALIZATION          */
  RUN STEPWISE;                                         /* STEPWISE METHOD         */
  RUN ALL;                                              /* ALL POSSIBLE Regression */
FINISH SEQ;

/*---------------------------- Educational Data -----------------------------------*
        The following data were collected from random sample of 32 student from an
  upper-class, white, residential school. The dependent variables are scores on a
  student achievement test (SAT), the Peabody Picture Vocabulary Test (PPVT), and
  the Ravin Progressive Matrices Test (RPMT). The independent variables were the sum
  of items correct out of 20 to five types of paired-associated (PA) tasks: named (N)
  , still (S), named still (NS), named action (NA), and sentence still (SS) (for
  detials about the data, see Timm, pp. 282, 1975).
*----------------------------------------------------------------------------------*/

Data ={
68      15      24      0      10     8       21      22,
82      11      8       7      3      21      28      21,
82      13      88      7      9      17      31      30,
91      18      82      6      11     16      27      25,
82      13      90      20     7      21      28      16,
100     15      77      4      11     18      32      29,
100     13      58      6      7      17      26      23,
96      12      14      5      2      11      22      23,
63      10      1       3      5      14      24      20,
91      18      98      16     12     16      27      30,
87      10      8       5      3      17      25      24,
105     21      88      2      11     10      26      22,
87      14      4       1      4      14      25      19,
76      16      14      11     5      18      27      22,
66      14      38      0      0      3       16      11,
74      15      4       5      8      11      12      15,
68      13      64      1      6      10      28      23,
98      16      88      1      9      12      30      18,
63      15      14      0      13     13      19      16,
94      16      99      4      6      14      27      19,
82      18      50      4      5      16      21      24,
89      15      36      1      6      15      23      28,
80      19      88      5      8      14      25      24,
61      11      14      4      5      11      16      22,
102     20      24      5      7      17      26      15,
71      12      24      0      4      8       16      14,
102     16      24      4      17     21      27      31,
96      13      50      5      8      20      28      26,
55      16      8       4      7      19      20      13,
96      18      98      4      7      10      23      19,
74      15      98      2      6      14      25      17,
78      19      50      5      10     18      27      26};

 Y=data [, 1:3];                       /* The dependent variables      */
 X=data [, 4:Ncol(data)];              /* The independent variables    */
 Run seq;

      /*--------------------------------*/
QUIT; /* THIS IS THE END OF THE PROGRAM */
      /*--------------------------------*/
