C This Newfit.for routine uses the new version of IMSL                  MAIN0000
C KRISHNAIAH'S SIMULTANEOUS FINITE INTERSECTION TEST (FIT) PROCEDURE    MAIN0010
C ON THE MEAN VECTORS OF K (P-VARIATE) MULTIVARIATE NORMAL POPULATIONS. MAIN0020
C                                                                       MAIN0030
C THIS IS A CONVERSATIONAL PROGRAM.  THE PROGRAM SEQUENTIALLY PROMPTS   MAIN0040
C THE USER FOR THE INFORMATION IT REQUIRES.                             MAIN0050
C * THE OPTION OF A TWO-SIDED TEST, OR EITHER OF TWO ONE-SIDED TESTS IS MAIN0060
C   PROVIDED.                                                           MAIN0070
C * THE COMMON VARIANCE-COVARIANCE MATRIX MAY BE KNOWN OR UNKNOWN.      MAIN0080
C * AN OPTIONAL ECHO CHECK OF THE INPUT DATA IS AVAILABLE.              MAIN0090
C                                                                       MAIN0100
C     MAXIMUM NUMBER OF POPULATIONS    = 10                             MAIN0110
C     MAXIMUM NUMBER OF VARIABLES      = 20                             MAIN0120
C     MAXIMUM SAMPLE SIZE PER POP.     = UNLIMITED                      MAIN0130
C                                                                       MAIN0140
C     INTERACTIVE TERMINAL INPUT:        READ(5,                        MAIN0150
C     INTERACTIVE TERMINAL OUTPUT:       WRITE(6,                       MAIN0160
C                                                                       MAIN0170
C     INPUT FROM OBSERVATION DATA FILE:  READ(1,                        MAIN0180
C     FIT ANALYSIS OUTPUT FILE:          WRITE(36,                      MAIN0190
C                                                                       MAIN0200
      REAL LEFT,LEFT1,LAMDA                                             MAIN0210
      REAL CSTAR(20),D1(21)                                             MAIN0220
      REAL C(21,10),XMEAN(10,20),S(20,20),REJ(2)                        MAIN0230
      real s2(20,20)                                                         new
      REAL SSYM(210),LSYM(210),Z(20,21),XROW(20),WZ(210),CEST(21,20)    MAIN0240
      REAL RHOA(210),D(21),CALPHA(20)                                   MAIN0250
      INTEGER G,P,Q,T,OPTION,ROW,TDIAG                                  MAIN0260
      INTEGER N(10),WVAR(21,20),NCNT(21),SIDED(2)                       MAIN0270
      INTEGER POP(5,10),VAR(5,20)                                       MAIN0280
      LOGICAL H(21),HH,TROBLE,REPEAT,NOTRHO                             MAIN0290
      COMMON /IBOUND/IBOUND(8,2)                                        MAIN0300
      COMMON /NSIDED/NSIDED,UPPLOW(2),IFAIL                             MAIN0310
C                                                                       MAIN0320
      DATA SIDED/1H<,1H>/                                               MAIN0330
      DATA REJ/1H ,1H*/                                                 MAIN0340
      DATA NCNT/21*0/                                                   MAIN0350
      DATA REPEAT/.FALSE./                                              MAIN0360
      DATA UPPLOW/3HUPP,3HLOW/                                          MAIN0370
      DATA CSUM/0.0/                                                    MAIN0380
C                                                                       MAIN0390
C PROMPT THE USER FOR THE FOLLOWING INFORMATION, ECHOING THE RESPONSE   MAIN0400
C AT EACH STAGE:                                                        MAIN0410
C                                                                       MAIN0420
C  K       INTEGER                                                      MAIN0430
C          THE NUMBER OF POPULATIONS TO BE COMPARED ( UP TO 10 ).       MAIN0440
C                                                                       MAIN0450
C  POP     INTEGER(5,10)                                                MAIN0460
C          (THE COLUMNS OF POP CONTAIN) THE NAMES OF THE K POPULATIONS, MAIN0470
C          EACH EXACTLY 5 CHARACTERS IN LENGTH (SPACES WITHIN NAMES OK).MAIN0480
C                                                                       MAIN0490
C  N       INTEGER(10)                                                  MAIN0500
C          THE SAMPLE SIZES FROM EACH OF THE K POPULATIONS.             MAIN0510
C                                                                       MAIN0520
C  P       INTEGER                                                      MAIN0530
C          THE NUMBER OF VARIABLES ( UP TO 20 ).                        MAIN0540
C                                                                       MAIN0550
C  VAR     INTEGER(5,20)                                                MAIN0560
C          (THE COLUMNS OF VAR CONTAIN) THE NAMES OF THE P VARIABLES,   MAIN0570
C          EACH EXACTLY 5 CHARACTERS IN LENGTH (SPACES WITHIN NAMES OK).MAIN0580
C                                                                       MAIN0590
C  IW      INTEGER                                                      MAIN0600
C          THE TYPE OF LINEAR COMBINATIONS THE BE USED TO COMPARE POPS: MAIN0610
C                                                                       MAIN0620
C          IW= 0   TO COMPARE ALL PAIRS OF POPULATIONS ( # POPS .LE. 7) MAIN0630
C             -1   TO COMPARE ADJACENT POPULATIONS                      MAIN0640
C             -2   TO COMPARE THE FIRST K-1 POPS AGAINST THE LAST AS    MAIN0650
C                  A CONTROL                                            MAIN0660
C            > 0   TO COMPARE THE K POPULATIONS USING IW USER ENTERED   MAIN0670
C                  LINEAR COMBINATIONS                                  MAIN0680
C                                                                       MAIN0690
C  C       INTEGER(21,10)                                               MAIN0700
C          (THE ROWS OF C CONTAIN) THE COEFFICIENTS OF THE LINEAR       MAIN0710
C          COMBINATIONS.                                                MAIN0720
C                                                                       MAIN0730
C          IF IW = 0,-1 OR -2  SUBROUTINE CNTRST GENERATES THESE FOR    MAIN0740
C                              THE USER                                 MAIN0750
C          IF IW > 0  THE USER IS ASKED TO ENTER THE COEFFICIENTS FOR   MAIN0760
C                     IW LINEAR COMBINATIONS                            MAIN0770
C                                                                       MAIN0780
C  IPRT    INTEGER                                                      MAIN0790
C          CONTROLS ECHO PRINTING OF THE OBSERVATIONS.                  MAIN0800
C                                                                       MAIN0810
C          IPRT = 0  TO SUPPRESS ECHO PRINTING                          MAIN0820
C                 1  TO ECHO PRINT                                      MAIN0830
C                                                                       MAIN0840
C  KNOWS   INTEGER                                                      MAIN0850
C                                                                       MAIN0860
C          KNOWS = 0  IF THE COMMON VARIANCE-COVARIANCE MATRIX IS       MAIN0870
C                     UNKNOWN (USUAL CASE), AND IS TO BE ESTIMATED      MAIN0880
C                     FROM THE DATA                                     MAIN0890
C                  1  IF THE COMMON VARIANCE-COVARIANCE MATRIX IS       MAIN0900
C                     KNOWN, AND IS TO BE READ IN.                      MAIN0910
C                                                                       MAIN0920
C  S       REAL(20,20)                                                  MAIN0930
C          CONTAINS THE COMPUTED SAMPLE SUMS OF SQUARES AND CROSS-      MAIN0940
C          PRODUCTS MATRIX IN KNOWS = 0, OR CONTAINS THE ACTUAL         MAIN0950
C          COMMON VARIANCE-COVARIANCE MATRIX (READ IN) IF KNOWS = 1     MAIN0960
C                                                                       MAIN0970
      WRITE(6,10000)                                                    MAIN0980
      READ(5,*)K                                                        MAIN0990
      WRITE(6,10010)K                                                   MAIN1000
      WRITE(6,10020)K                                                   MAIN1010
      READ(5,10030)((POP(J,I),J=1,5),I=1,K)                             MAIN1020
      WRITE(6,10040)((POP(J,I),J=1,5),I=1,K)                            MAIN1030
      WRITE(6,10050)K                                                   MAIN1040
      READ(5,*)(N(I),I=1,K)                                             MAIN1050
      WRITE(6,10010)(N(I),I=1,K)                                        MAIN1060
      WRITE(6,10060)                                                    MAIN1070
      READ(5,*)P                                                        MAIN1080
      WRITE(6,10010)P                                                   MAIN1090
      WRITE(6,10070)P                                                   MAIN1100
      READ(5,10030)((VAR(J,I),J=1,5),I=1,P)                             MAIN1110
      WRITE(6,10040)((VAR(J,I),J=1,5),I=1,P)                            MAIN1120
      IF(K.EQ.1)GO TO 50                                                MAIN1130
   10 WRITE(6,10080)                                                    MAIN1140
      READ(5,*)IW                                                       MAIN1150
      WRITE(6,10010)IW                                                  MAIN1160
      IF(.NOT.((IW.EQ.0).AND.(K.GT.7)))GO TO 20                         MAIN1170
      WRITE(6,10090)K                                                   MAIN1180
      GO TO 10                                                          MAIN1190
C                                                                       MAIN1200
C  Q      REAL                                                          MAIN1210
C         EQUALS THE NUMBER OF LINEAR COMBINATIONS RESULTING FROM       MAIN1220
C         LINEAR COMBINATION OPTION IW.                                 MAIN1230
C                                                                       MAIN1240
   20 IF(IW.GT.0)GO TO 30                                               MAIN1250
C                                                                       MAIN1260
C GENERATE CONTRASTS INTERALLY FOR USER (IW = 0,-1,-2)                  MAIN1270
C                                                                       MAIN1280
      CALL CNTRST(C,K,IW,Q)                                             MAIN1290
      GO TO 60                                                          MAIN1300
C                                                                       MAIN1310
C IW > 0 , SO ASK THE USER TO ENTER THE Q LINEAR COMBINATIONS.          MAIN1320
C                                                                       MAIN1330
   30 Q=IW                                                              MAIN1340
      WRITE(6,10010)Q                                                   MAIN1350
      WRITE(6,10100)Q,K                                                 MAIN1360
      DO 40 G=1,Q                                                       MAIN1370
      READ(5,*)(C(G,I),I=1,K)                                           MAIN1380
      WRITE(6,10110)(C(G,I),I=1,K)                                      MAIN1390
   40 CONTINUE                                                          MAIN1400
      GO TO 60                                                          MAIN1410
C                                                                       MAIN1420
C K = 1 POPULATION, SO TEST THAT IT'S MEAN IS ZERO.                     MAIN1430
C                                                                       MAIN1440
   50 Q=1                                                               MAIN1450
      C(1,1)=1.                                                         MAIN1460
C                                                                       MAIN1470
   60 WRITE(36,10120)                                                   MAIN1480
      WRITE(6,10130)                                                    MAIN1490
      READ(5,*)IPRT                                                     MAIN1500
      WRITE(6,10010)IPRT                                                MAIN1510
      NSUM=0                                                            MAIN1520
      WRITE(6,10170)                                                    MAIN1530
      READ(5,*)KNOWS                                                    MAIN1540
      WRITE(6,10010)KNOWS                                               MAIN1550
C                                                                       MAIN1560
C KNOWS = 0 => SIGMA IS UNKNOWN, SO JUMP TO THE SECTION OF CODE THAT    MAIN1570
C              ESTIMATES IT.                                            MAIN1580
C                                                                       MAIN1590
      IF(KNOWS.EQ.0)GO TO 110                                           MAIN1600
C                                                                       MAIN1610
C KNOWS = 1  => SIGMA IS KNOWN, SO READ SIGMA INTO MATRIX S.            MAIN1620
C                                                                       MAIN1630
      WRITE(6,10180)P,P                                                 MAIN1640
      T=0                                                               MAIN1710
      DO 70 J=1,P                                                       MAIN1650
      READ(5,*)(S(J,L),L=1,P)                                           MAIN1660
C                                                                       MAIN1670
C CREATE A SYMMETRIC STORAGE MODE (IMSL) VERSION OF S IN VECTOR SSYM    MAIN1680
C FOR LATER USE.                                                        MAIN1690
C                                                                       MAIN1700
      DO 70 L=1,J                                                       MAIN1720
      T=T+1                                                             MAIN1730
   70 SSYM(T)=S(J,L)                                                    MAIN1740
C                                                                       MAIN1750
C READ IN THE OBSERVATIONS FROM UNIT 1 TO COMPUTE THE SAMPLE MEAN       MAIN1760
C VECTORS OF THE K POPULATIONS.  ECHO PRINT THE DATA IF IPRT = 1.       MAIN1770
C                                                                       MAIN1780
C  XMEAN   REAL(10,20)                                                  MAIN1790
C          MATRIX WHOSE FIRST K ROWS CONTAIN THE SAMPLE MEAN VECTORS    MAIN1800
C          ON THE K  P-VARIATE POPULATIONS.                             MAIN1810
C                                                                       MAIN1820
      DO 100 I=1,K                                                      MAIN1830
      IF(IPRT.EQ.1)WRITE(36,10140)I,(POP(J,I),J=1,5),                   MAIN1840
     1                                        ((VAR(J,L),J=1,5),L=1,P)  MAIN1850
      NI=N(I)                                                           MAIN1860
      DO 80 J=1,NI                                                      MAIN1870
      READ(1,*)(XROW(L),L=1,P)                                          MAIN1880
      IF(IPRT.EQ.1)WRITE(36,10110)(XROW(L),L=1,P)                       MAIN1890
      DO 80 L=1,P                                                       MAIN1900
   80 XMEAN(I,L)=XMEAN(I,L)+XROW(L)                                     MAIN1910
      DO 90 L=1,P                                                       MAIN1920
   90 XMEAN(I,L)=XMEAN(I,L)/NI                                          MAIN1930
  100 NSUM=NSUM+NI                                                      MAIN1940
C                                                                       MAIN1950
C JUMP OVER THE NEXT SECTION THAT ASSUMES SIGMA IS KNOWN.               MAIN1960
C                                                                       MAIN1970
      GO TO 160                                                         MAIN1980
C                                                                       MAIN1990
C KNOWS = 0 => SIGMA IS UNKNOWN.  READ IN THE OBSERVATIONS FROM UNIT 1  MAIN2000
C              TO COMPUTE THE SAMPLE MEAN VECTORS OF THE K P-VARIATE    MAIN2010
C              POPULATIONS.  ALSO ACCUMULATE THE SUMS OF SQUARES AND    MAIN2020
C              CROSS-PRODUCTS (SSP) MATRIX INTO VECTOR SSYM IN          MAIN2030
C              SYMMETRIC STORAGE MODE (IMSL) AS THE DATA IS READ IN.    MAIN2040
C              ECHO THE DATA IF IPRT = 1.                               MAIN2050
C                                                                       MAIN2060
  110 DO 150 I=1,K                                                      MAIN2070
      IF(IPRT.EQ.1)WRITE(36,10140)I,(POP(J,I),J=1,5),                   MAIN2080
     1                                        ((VAR(J,L),J=1,5),L=1,P)  MAIN2090
      NI=N(I)                                                           MAIN2100
      DO 120 J=1,NI                                                     MAIN2110
      READ(1,*)(XROW(L),L=1,P)                                          MAIN2120
      IF(IPRT.EQ.1)WRITE(36,10110)(XROW(L),L=1,P)                       MAIN2130
      T=0                                                               MAIN2140
      DO 120 L=1,P                                                      MAIN2150
      XROWL=XROW(L)                                                     MAIN2160
      XMEAN(I,L)=XMEAN(I,L)+XROWL                                       MAIN2170
      DO 120 M=1,L                                                      MAIN2180
      T=T+1                                                             MAIN2190
  120 SSYM(T)=SSYM(T)+XROWL*XROW(M)                                     MAIN2200
      DO 130 L=1,P                                                      MAIN2210
  130 XMEAN(I,L)=XMEAN(I,L)/NI                                          MAIN2220
      T=0                                                               MAIN2230
      DO 140 L=1,P                                                      MAIN2240
      XMEANL=XMEAN(I,L)                                                 MAIN2250
      DO 140 M=1,L                                                      MAIN2260
      T=T+1                                                             MAIN2270
  140 SSYM(T)=SSYM(T)-NI*XMEANL*XMEAN(I,M)                              MAIN2280
  150 NSUM=NSUM+NI                                                      MAIN2290
C                                                                       MAIN2300
C OBTAIN A FULL STORAGE MODE (IMSL) VERSION OF SSYM IN MATRIX S         MAIN2310
C FOR OUTPUT PURPOSES.                                                  MAIN2320
C                                                                       MAIN2330
c Note that the symmetric storage mode version of the matrix is no longer used.
      CALL VCVTSF(SSYM,P,S,20)                                          MAIN2340
C                                                                       MAIN2350
C OUTPUT (TO UNIT 36, NOT THE USER'S TERMINAL) THE SAMPLE MEAN          MAIN2360
C VECTORS, THE SSP MATRIX (IF SIGMA UNKNOWN) OR SIGMA (IF SIGMA KNOWN), MAIN2370
C THE # OF POPS, # OF VARS, THE SAMPLE SIZES, AND THE LINEAR COMBS      MAIN2380
C OR CONTRASTS TO BE USED.                                              MAIN2390
C                                                                       MAIN2400
  160 WRITE(36,10150)((VAR(J,I),J=1,5),I=1,P)                           MAIN2410
      DO 170 I=1,K                                                      MAIN2420
  170 WRITE(36,10160)(POP(J,I),J=1,5),(XMEAN(I,J),J=1,P)                MAIN2430
  180 IF(KNOWS.EQ.0)WRITE(36,10190)                                     MAIN2440
      IF(KNOWS.EQ.1)WRITE(36,10200)                                     MAIN2450
      WRITE(36,10210)((VAR(J,I),J=1,5),I=1,P)                           MAIN2460
      DO 190 I=1,P                                                      MAIN2470
      WRITE(36,10160)(VAR(J,I),J=1,5),(S(I,J),J=1,P)                    MAIN2480
  190 CONTINUE                                                          MAIN2490
      WRITE(36,10220)K,P,(N(I),I=1,K)                                   MAIN2500
      WRITE(36,10230)                                                   MAIN2510
      WRITE(36,10240)((POP(J,I),J=1,5),I=1,K)                           MAIN2520
      DO 200 G=1,Q                                                      MAIN2530
  200 WRITE(36,10250)G,(C(G,J),J=1,K)                                   MAIN2540
C                                                                       MAIN2550
C COMPUTE THE SAMPLE LINEAR COMBINATION (OR CONTRAST) ESTIMATES         MAIN2560
C                                                                       MAIN2570
C                                                                       MAIN2580
C  CEST    REAL(21,10)                                                  MAIN2590
C          MATRIX WHOSE FIRST Q ROWS CONTAIN THE LINEAR COMBINATION     MAIN2600
C          ESTIMATES FOR EACH OF THE P VARIABLES.                       MAIN2610
C                                                                       MAIN2620
      DO 210 I=1,Q                                                      MAIN2630
      DO 210 L=1,P                                                      MAIN2640
      DO 210 J=1,K                                                      MAIN2650
  210 CEST(I,L)=CEST(I,L)+C(I,J)*XMEAN(J,L)                             MAIN2660
C                                                                       MAIN2670
C OBTAIN THE CHOLESKY DECOMPOSITION OF SSYM, SO THAT:                   MAIN2680
C SSYM = LSYM * TRANSPOSE( LSYM )  ,  WHERE LSYM IS LOWER TRIANGULAR.   MAIN2690
C                                                                       MAIN2700
c     CALL LUDECP(SSYM,LSYM,P,DUMMY1,DUMMY2,IER)                        MAIN2710
c Use S (the Full Storage Mode version) rather than SSYM, and
c store the decomposition in S2 (also Full storage Mode).
      call lftds(p,s,20,s2,20)
c Invert the diagonal to get the exact results as LUDECP
      do 212 j=1,p
212   s2(j,j)=1./s2(j,j)
c Convert output matrix S2 from Full Storage Mode to Symmetric Storage Mode
      call vcvtfs(s2,p,20,lsym)
C                                                                       MAIN2720
C SOLVE:  LSYM * Z = TRANSPOSE( CEST )  FOR Z                           MAIN2730
C                                                                       MAIN2740
      DO 220 J=1,Q                                                      MAIN2750
  220 Z(1,J)=LSYM(1)*CEST(J,1)                                          MAIN2760
      LSYM(1)=1./LSYM(1)                                                MAIN2770
      IF(P.EQ.1)GO TO 260                                               MAIN2780
      TDIAG=1                                                           MAIN2790
      DO 250 I=2,P                                                      MAIN2800
      DO 240 J=1,Q                                                      MAIN2810
      TEMP=CEST(J,I)                                                    MAIN2820
      T=TDIAG                                                           MAIN2830
      DO 230 L=1,I-1                                                    MAIN2840
      T=T+1                                                             MAIN2850
  230 TEMP=TEMP-LSYM(T)*Z(L,J)                                          MAIN2860
      T=T+1                                                             MAIN2870
  240 Z(I,J)=LSYM(T)*TEMP                                               MAIN2880
C                                                                       MAIN2890
C LUDECP (IMSL) RETURNS THE DIAGONAL ELEMENTS OF LSYM AS THEIR          MAIN2900
C INVERSES.  WE NEED THE ACTUAL ELEMENTS, SO INVERT THEM AGAIN.         MAIN2910
C                                                                       MAIN2920
      TDIAG=TDIAG+I                                                     MAIN2930
  250 LSYM(TDIAG)=1./LSYM(TDIAG)                                        MAIN2940
C                                                                       MAIN2950
C NEXT PROMPT THE USER FOR:                                             MAIN2960
C                                                                       MAIN2970
C NSIDED   INTEGER                                                      MAIN2980
C          INDICATOR OF THE TYPE OF ALTERNATIVE (H1) THE NULL           MAIN2990
C          HYPOTHESIS (H0) IS TO BE TESTED AGAINST.                     MAIN3000
C           ( H0: CONDITIONAL LINEAR COMBINATION (CLC) = 0 )            MAIN3010
C                                                                       MAIN3020
C          NSIDED = 2  H1: CLC  .NE.  0                                 MAIN3030
C                   1  H1: CLC   <    0                                 MAIN3040
C                   0  H1: CLC   >    0                                 MAIN3050
C                                                                       MAIN3060
C  ALPHA2  REAL                                                         MAIN3070
C          THE OVERALL ALPHA-LEVEL OF THE TEST                          MAIN3080
C                                                                       MAIN3090
C  OPTION  INTEGER                                                      MAIN3100
C          INDICATOR OF THE TYPE OF BOUND ON THE CRITICAL VALUES TO BE  MAIN3110
C          COMPUTED. AT EXECUTION TIME, THE PROGRAM LISTS THE SUBSET    MAIN3120
C          OF THE FOLLOWING BOUNDS THAT APPLIES TO THE USERS SITUATION: MAIN3130
C                                                                       MAIN3140
C          OPTION = 1  TO USE THE PRODUCT UPPER BOUND                   MAIN3150
C                   2  TO USE THE UPPER BOUND BASED ON POINCARE'S       MAIN3160
C                      FORMULA                                          MAIN3170
C                   3  TO USE THE LOWER BOUND BASED ON POINCARE'S       MAIN3180
C                      FORMULA                                          MAIN3190
C                   4  TO USE THE AVERAGE OF POINCARE'S UPPER BOUND (2) MAIN3200
C                      AND POINCARE'S LOWER BOUND (3)                   MAIN3210
C                   5  TO USE THE AVERAGE OF THE PRODUCT UPPER BOUND (1)MAIN3220
C                      AND POINCARE'S LOWER BOUND (3)                   MAIN3230
C                   6  TO USE SIDAK'S UPPER BOUND                       MAIN3240
C                   7  TO USE THE AVERAGE OF SIDAK'S UPPER BOUND (6)    MAIN3250
C                      AND POINCARE'S LOWER BOUND (3)                   MAIN3260
C                   8  TO USE AN EXACT CRITICAL VALUE FOR LINEAR        MAIN3270
C                      COMBINATIONS ON VARIABLE #1 (IW = -2 ONLY).      MAIN3280
C                      ONE OF OPTIONS 1-7, OR 9 WILL BE REQUESTED FOR   MAIN3290
C                      THE REMAINING VARIABLES.                         MAIN3300
C                   9  IF CRITICAL VALUES ARE KNOWN, AND YOU WISH TO    MAIN3310
C                      ENTER THEM                                       MAIN3320
C                                                                       MAIN3330
  260 WRITE(6,10260)                                                    MAIN3340
      READ(5,*)NSIDED                                                   MAIN3350
      WRITE(6,10010)NSIDED                                              MAIN3360
      WRITE(6,10270)                                                    MAIN3370
      READ(5,*)ALPHA2                                                   MAIN3380
      WRITE(6,10110)ALPHA2                                              MAIN3390
C                                                                       MAIN3400
C ALPHA   REAL                                                          MAIN3410
C         ALPHA-LEVEL USED FOR TESTING HYPOTHESES ON EACH VARIABLE      MAIN3420
C         SEPARATELY.                                                   MAIN3430
C                                                                       MAIN3440
      ALPHA=1.-(1.-ALPHA2)**(1./P)                                      MAIN3450
      ALPH2=1-ALPHA                                                     MAIN3460
C                                                                       MAIN3470
C THE DEGREES OF FREEDOM, WHETHER THE VARIANCE-COVARIANCE MATRIX        MAIN3480
C IS KNOWN OR NOT, AND THE SIDEDNESS OF THE ALTERNATIVE DETERMINE       MAIN3490
C WHICH DISTRIBUTION AND WHICH BOUNDS ON THE CRITICAL VALUES APPLY.     MAIN3500
C                                                                       MAIN3510
      NDF=NSUM-K                                                        MAIN3520
      IF (KNOWS.EQ.1.AND.NDF.EQ.0) NDF=1
      WRITE(6,10280)NDF                                                 MAIN3530
      IF(NSIDED.EQ.2)WRITE(6,10290)                                     MAIN3540
      IF(KNOWS.EQ.1)GO TO 270                                           MAIN3550
      IF(NDF.LE.40)GO TO 270                                            MAIN3560
      IF(NSIDED.NE.0)WRITE(6,10300)                                     MAIN3570
      IF(NSIDED.EQ.0)WRITE(6,10310)                                     MAIN3580
      GO TO 300                                                         MAIN3590
  270 WRITE(6,10320)                                                    MAIN3600
      IF(NSIDED.NE.2)GO TO 300                                          MAIN3610
      WRITE(6,10330)                                                    MAIN3620
      IF(KNOWS.EQ.1)GO TO 300                                           MAIN3630
      WRITE(6,10340)                                                    MAIN3640
      IF(IW.NE.-2)GO TO 300                                             MAIN3650
      NSAME=N(1)                                                        MAIN3660
      DO 280 I=2,K                                                      MAIN3670
  280 IF(N(I).NE.NSAME)GO TO 300                                        MAIN3680
  290 WRITE(6,10350)                                                    MAIN3690
      IF(P.GT.1)WRITE(6,10360)                                          MAIN3700
  300 WRITE(6,10380)                                                    MAIN3710
      READ(5,*)OPTION                                                   MAIN3720
      WRITE(6,10010)OPTION                                              MAIN3730
      IF((OPTION.NE.8).OR.(P.EQ.1).OR.(KNOWS.EQ.1))GO TO 320            MAIN3740
      IPM1=P-1                                                          MAIN3750
  310 WRITE(6,10370)IPM1                                                MAIN3760
      READ(5,*)IOPT2                                                    MAIN3770
      WRITE(6,10010)IOPT2                                               MAIN3780
      IF(IOPT2.EQ.8)GO TO 310                                           MAIN3790
C                                                                       MAIN3800
C OPTION = 9  => THE USER KNOWS CRITICAL VALUES, SO READ THEM IN.       MAIN3810
C                                                                       MAIN3820
  320 IF(OPTION.NE.9)GO TO 330                                          MAIN3830
      WRITE(6,10390)P                                                   MAIN3840
      READ(5,*)(CALPHA(J),J=1,P)                                        MAIN3850
      WRITE(6,10110)(CALPHA(J),J=1,P)                                   MAIN3860
C                                                                       MAIN3870
C IDISTR   INTEGER                                                      MAIN3880
C          INDICATOR OF THE TYPE OF DISTRIBUTION                        MAIN3890
C                                                                       MAIN3900
C          IDISTR = 1  MULTIVARIATE F                                   MAIN3910
C                   2  MULTIVARIATE CHI-SQUARE                          MAIN3920
C                   3  MULTIVARIATE T                                   MAIN3930
C                   4  MULTIVARIATE NORMAL                              MAIN3940
C                                                                       MAIN3950
  330 IF((NSIDED.EQ.2).AND.(KNOWS.EQ.0))IDISTR=1                        MAIN3960
      IF((NSIDED.EQ.2).AND.(KNOWS.EQ.1))IDISTR=2                        MAIN3970
      IF((NSIDED.NE.2).AND.(KNOWS.EQ.0))IDISTR=3                        MAIN3980
      IF((NSIDED.NE.2).AND.(KNOWS.EQ.1))IDISTR=4                        MAIN3990
      IF(NSIDED.EQ.2)WRITE(36,10400)                                    MAIN4000
      IS=NSIDED+1                                                       MAIN4010
      IF(NSIDED.NE.2)WRITE(36,10410)SIDED(IS)                           MAIN4020
C                                                                       MAIN4030
C INITIALIZE HH,H  AS TRUE ( NULL HYPOTHESIS ACCEPTED)                  MAIN4040
C                                                                       MAIN4050
      HH=.TRUE.                                                         MAIN4060
      DO 340 G=1,Q                                                      MAIN4070
      H(G)=.TRUE.                                                       MAIN4080
  340 CONTINUE                                                          MAIN4090
C                                                                       MAIN4100
C FOR VARIABLE #1 (J=1) THERE IS NO CONDITIONAL DISTRIBUTION, AND       MAIN4110
C HENCE COMPUTATIONS ARE DIFFERENT THAN FOR VARIABLES 2 THRU P.         MAIN4120
C COMPUTE THE ERROR SUMS OF SQUARES (SSQ), AND THE VARIANCE SCALE (D)   MAIN4130
C FOR THE Q LIN COMBS ON THE FIRST VARIABLE.                            MAIN4140
C                                                                       MAIN4150
      J=1                                                               MAIN4160
      CSUM=1.                                                           MAIN4170
      IF(KNOWS.EQ.0)SSQ=S(1,1)/NDF                                      MAIN4180
      IF(KNOWS.EQ.1)SSQ=S(1,1)                                          MAIN4190
      DO 360 G=1,Q                                                      MAIN4200
      D(G)=0.0                                                          MAIN4210
      DO 350 I=1,K                                                      MAIN4220
      D(G)=D(G)+C(G,I)*C(G,I)/N(I)                                      MAIN4230
  350 CONTINUE                                                          MAIN4240
      D1(G)=SQRT(D(G))                                                  MAIN4250
  360 CONTINUE                                                          MAIN4260
      NOTRHO=.TRUE.                                                     MAIN4270
      IDIAG=1                                                           MAIN4280
      IF(Q.EQ.1)GO TO 430                                               MAIN4290
      IBIVAR=3                                                          MAIN4300
      IF(NSIDED.EQ.0)IBIVAR=2                                           MAIN4310
C                                                                       MAIN4320
C IN THE EVENT THAT A BOUND FAILS TO CONVERGE NUMERICALLY, USE A        MAIN4330
C FAILSAFE BOUND THAT ALWAYS CONVERGES.                                 MAIN4340
C                                                                       MAIN4350
      IFAIL=4-IBIVAR                                                    MAIN4360
C                                                                       MAIN4370
C THE CORRELATION MATRIX OF THE Q LIN COMBS IS NEEDED ONLY WHEN THE     MAIN4380
C BIVARIATE PROBABILITIES OF POINCARE'S FORMULA ARE TO BE COMPUTED.     MAIN4390
C                                                                       MAIN4400
      IF(IBOUND(OPTION,1).EQ.IBIVAR.OR.IBOUND(OPTION,2).EQ.IBIVAR)      MAIN4410
     1NOTRHO=.FALSE.                                                    MAIN4420
      IF(NOTRHO)GO TO 430                                               MAIN4430
C                                                                       MAIN4440
C BIVARIATE PROBABLIITIES WILL BE CALCULATED, SO COMPUTE THE            MAIN4450
C CORRELATION MATRIX OF THE Q LIN COMBS ON VARIABLE #1                  MAIN4460
C                                                                       MAIN4470
C  RHOA   REAL(210)                                                     MAIN4480
C         CONTAINS THE CORRELATION MATRIX IF BIVARIATE PROBABILITIES    MAIN4490
C         ARE NEEDED.                                                   MAIN4500
C                                                                       MAIN4510
      T=0                                                               MAIN4520
      NROW=Q-1                                                          MAIN4530
      DO 380 G=1,NROW                                                   MAIN4540
      NCOL=G+1                                                          MAIN4550
      DO 380 M=NCOL,Q                                                   MAIN4560
      T=T+1                                                             MAIN4570
      WZ(T)=0.0                                                         MAIN4580
      DO 370 I=1,K                                                      MAIN4590
      WZ(T)=WZ(T)+C(G,I)*C(M,I)/N(I)                                    MAIN4600
  370 CONTINUE                                                          MAIN4610
      RHOA(T)=WZ(T)/SQRT(D(G)*D(M))                                     MAIN4620
  380 CONTINUE                                                          MAIN4630
      GO TO 430                                                         MAIN4640
C                                                                       MAIN4650
C STARTING POINT FO COMPUTING TEST STATISTICS, CRITICAL VALUES, AND     MAIN4660
C CONFIDENCE INTERVALS FOR VARIABLES 2 THRU P.                          MAIN4670
C                                                                       MAIN4680
  390 DO 400 G=1,Q                                                      MAIN4690
  400 D(G)=D(G)+Z(J-1,G)**2                                             MAIN4700
C                                                                       MAIN4710
C CHECK TO SEE IF THE CORRELATION MATRIX IS NEEDED FOR COMPUTATION      MAIN4720
C OF BIVARIATE PROBABILITIES.                                           MAIN4730
C                                                                       MAIN4740
      IF(NOTRHO)GO TO 420                                               MAIN4750
      T=0                                                               MAIN4760
      DO 410 G=1,NROW                                                   MAIN4770
      NCOL=G+1                                                          MAIN4780
      DO 410 M=NCOL,Q                                                   MAIN4790
      T=T+1                                                             MAIN4800
      WZ(T)=WZ(T)+Z(J-1,G)*Z(J-1,M)                                     MAIN4810
  410 RHOA(T)=WZ(T)/SQRT(D(G)*D(M))                                     MAIN4820
  420 IDIAG=IDIAG+J                                                     MAIN4830
      IF (KNOWS.EQ.0) NDF=NDF-1
      IF (KNOWS.EQ.1) NDF=NDF                                            MAIN4840
      IF (KNOWS.EQ.0) SSQ=LSYM(IDIAG)**2/NDF                             MAIN4850
      IF (KNOWS.EQ.1) SSQ=LSYM(IDIAG)**2                                 MAIN4850
C                                                                       MAIN4860
C CALCULATE CRITICAL VALUES IF THEY ARE UNKNOWN                         MAIN4870
C                                                                       MAIN4880
  430 IF((OPTION.EQ.9).OR.REPEAT)GO TO 440                              MAIN4890
      CALL BOUND(IDISTR,OPTION,Q,NDF,RHOA,CALPHA(J),ALPH2,TROBLE)       MAIN4900
  440 IF(REPEAT)CALPHA(J)=CALPHA(1)                                     MAIN4910
      CSTAR(J)=ABS(CALPHA(J))/NDF                                       MAIN4920
      IF(J.EQ.1)GO TO 450                                               MAIN4930
      J1=J-1                                                            MAIN4940
      CSUM=CSUM+CSTAR(J1)                                               MAIN4950
      CSTAR(J)=CSTAR(J)*CSUM                                            MAIN4960
C                                                                       MAIN4970
C (FOR VARIABLE J) OUTPUT APPROPRIATE HEADER INFO DEPENDING ON          MAIN4980
C THE RELEVANT DISTRIBUTION, AND THE USER SELECTED BOUND ON THE         MAIN4990
C CRITICAL VALUE.                                                       MAIN5000
C                                                                       MAIN5010
      IF(IDISTR.EQ.1)WRITE(36,10450)J,(VAR(L,J),L=1,5),NDF,SSQ          MAIN5020
      IF(IDISTR.EQ.2)WRITE(36,10470)J,(VAR(L,J),L=1,5),SSQ              MAIN5030
      IF(IDISTR.EQ.3)WRITE(36,10430)J,(VAR(L,J),L=1,5),NDF,SSQ          MAIN5040
      IF(IDISTR.EQ.4)WRITE(36,10490)J,(VAR(L,J),L=1,5),SSQ              MAIN5050
      GO TO 460                                                         MAIN5060
  450 IF(IDISTR.EQ.1)WRITE(36,10440)J,(VAR(L,J),L=1,5),NDF,SSQ          MAIN5070
      IF(IDISTR.EQ.2)WRITE(36,10460)J,(VAR(L,J),L=1,5),SSQ              MAIN5080
      IF(IDISTR.EQ.3)WRITE(36,10420)J,(VAR(L,J),L=1,5),NDF,SSQ          MAIN5090
      IF(IDISTR.EQ.4)WRITE(36,10480)J,(VAR(L,J),L=1,5),SSQ              MAIN5100
  460 GO TO (470,480,490,500,510,520,530,540,550), OPTION               MAIN5110
  470 WRITE(36,10550)                                                   MAIN5120
      GO TO 560                                                         MAIN5130
  480 WRITE(36,10520)                                                   MAIN5140
      GO TO 560                                                         MAIN5150
  490 WRITE(36,10530)                                                   MAIN5160
      GO TO 560                                                         MAIN5170
  500 WRITE(36,10500)                                                   MAIN5180
      WRITE(36,10520)                                                   MAIN5190
      WRITE(36,10510)                                                   MAIN5200
      WRITE(36,10530)                                                   MAIN5210
      GO TO 560                                                         MAIN5220
  510 WRITE(36,10500)                                                   MAIN5230
      WRITE(36,10550)                                                   MAIN5240
      WRITE(36,10510)                                                   MAIN5250
      WRITE(36,10530)                                                   MAIN5260
      GO TO 560                                                         MAIN5270
  520 WRITE(36,10540)                                                   MAIN5280
      GO TO 560                                                         MAIN5290
  530 WRITE(36,10500)                                                   MAIN5300
      WRITE(36,10540)                                                   MAIN5310
      WRITE(36,10510)                                                   MAIN5320
      WRITE(36,10530)                                                   MAIN5330
      GO TO 560                                                         MAIN5340
  540 WRITE(36,10560)                                                   MAIN5350
      OPTION=IOPT2                                                      MAIN5360
      GO TO 560                                                         MAIN5370
  550 WRITE(36,10570)                                                   MAIN5380
  560 IF(IDISTR.EQ.1)WRITE(36,10580)                                    MAIN5390
      IF(IDISTR.EQ.2)WRITE(36,10590)                                    MAIN5400
      IF(IDISTR.EQ.3)WRITE(36,10600)                                    MAIN5410
      IF(IDISTR.EQ.4)WRITE(36,10610)                                    MAIN5420
      IF(.NOT.TROBLE)GO TO 570                                          MAIN5430
      WRITE(36,10620)UPPLOW(IFAIL)                                      MAIN5440
      TROBLE=.FALSE.                                                    MAIN5450
C                                                                       MAIN5460
C EU       REAL                                                         MAIN5470
C          USED IN CALCULATING THE WIDTH OF THE APPROXIMATE CONFIDENCE  MAIN5480
C          INTERVALS (C.I.'S) FOR THE LIN COMBS OF THE ORIGINAL MEANS.  MAIN5490
C          ONLY THE C.I'S ON THE CONDITIONAL MEANS ARE EXACT, BUT THESE MAIN5500
C          ARE DIFFICULT TO INTERPRET.                                  MAIN5510
C                                                                       MAIN5520
  570 EU=0.0                                                            MAIN5530
      T=J*(J-1)/2                                                       MAIN5540
      DO 580 L=1,J                                                      MAIN5550
      T=T+1                                                             MAIN5560
  580    EU=EU+ABS(LSYM(T))*SQRT(CSTAR(L))                              MAIN5570
      WRITE(36,10630)CALPHA(J),J,ALPHA                                  MAIN5580
      IF(NSIDED.EQ.2)GO TO 590                                          MAIN5590
      IF(J.EQ.1)WRITE(36,10660)                                         MAIN5600
      IF(J.GT.1)WRITE(36,10670)                                         MAIN5610
      GO TO 600                                                         MAIN5620
  590 IF(J.EQ.1)WRITE(36,10660)                                         MAIN5630
      IF(J.GT.1)WRITE(36,10640)                                         MAIN5640
      IF(J.GT.1)WRITE(36,10650)                                         MAIN5650
C                                                                       MAIN5660
C FOR EACH OF THE Q LIN COMBS COMPUTE THE CONDITIONAL LIN COMB ESTIMATE,MAIN5670
C THE CONFIDENCE INTERVAL, AND THE TEST STATISTIC (FOR VARIABLE J)      MAIN5680
C                                                                       MAIN5690
  600 DO 670 G=1,Q                                                      MAIN5700
      LAMDA=Z(J,G)*LSYM(IDIAG)                                          MAIN5710
      DS=D(G)*SSQ                                                       MAIN5720
      SQRTDS=SQRT(DS)                                                   MAIN5730
      IF(NSIDED.EQ.2)TEMP=SQRTDS*SQRT(ABS(CALPHA(J)))                   MAIN5740
      IF(NSIDED.NE.2)TEMP=SQRTDS*ABS(CALPHA(J))                         MAIN5750
      EDELTA=EU*D1(G)                                                   MAIN5760
      EST=CEST(G,J)                                                     MAIN5770
      IF(NSIDED.NE.2)GO TO 610                                          MAIN5780
      LEFT1=EST-EDELTA                                                  MAIN5790
      RIGHT1=EST+EDELTA                                                 MAIN5800
  610 IF((NSIDED.EQ.2).OR.(NSIDED.EQ.1))                                MAIN5810
     1  LEFT=LAMDA-TEMP                                                 MAIN5820
      IF((NSIDED.EQ.2).OR.(NSIDED.EQ.0))                                MAIN5830
     1   RIGHT=LAMDA+TEMP                                               MAIN5840
C                                                                       MAIN5850
      F=LAMDA/SQRTDS                                                    MAIN5860
C                                                                       MAIN5870
C FOR A TWO SIDED TEST, F IS THE SQUARE OF THE ONE SIDED TEST STATISTIC MAIN5880
C                                                                       MAIN5890
      IF(NSIDED.EQ.2)F=F**2                                             MAIN5900
C                                                                       MAIN5910
C IF SUBHYPOTHESIS H(G) IS ACCEPTED, SKIP OVER THE NEXT PART            MAIN5920
C THAT RECORDS REJECTION OF HYPOTHESES.                                 MAIN5930
C                                                                       MAIN5940
      IF((F.LE.CALPHA(J)).AND.(NSIDED.GE.1))GO TO 640                   MAIN5950
      IF((F.GE.CALPHA(J)).AND.(NSIDED.EQ.0))GO TO 640                   MAIN5960
C                                                                       MAIN5970
C SUBHYPOTHESIS H(G) IS REJECTED => GLOBAL HYPOTHESIS HH ALSO REJECTED. MAIN5980
C RECORD THE FACT , AND ON WHICH VARIABLE REJECTION OCCURRED.           MAIN5990
C                                                                       MAIN6000
C  HH      LOGICAL                                                      MAIN6010
C          INDICATOR OF WHETHER THE GLOBAL HYPOTHESIS ( THAT ALL LINEAR MAIN6020
C          COMBINATIONS OF MEAN VECTORS ARE ZERO ) IS ACCEPTED OR NOT.  MAIN6030
C                                                                       MAIN6040
C  H       LOGICAL(21)                                                  MAIN6050
C          H(G) IS THE INDICATOR OF WHETHER THE G-TH HYPOTHESIS ( THAT  MAIN6060
C          THE G-TH LINEAR COMBINATION OF MEAN VECTORS IS ZERO ) IS     MAIN6070
C          ACCEPTED OR NOT (G=1,...,Q).                                 MAIN6080
C                                                                       MAIN6090
C  NCNT    INTEGER(21)                                                  MAIN6100
C          VECTOR WHOSE G-TH ELEMENT CONTAINS THE NUMBER OF VARIABLES   MAIN6110
C          LEADING TO REJECTION OF H(G)  (G=1,...,Q)                    MAIN6120
C                                                                       MAIN6130
C  WVAR    INTEGER(21,20)                                               MAIN6140
C          MATRIX WHOSE G-TH ROW CONTAINS THE INDICES OF THE            MAIN6150
C          VARIABLES LEADING TO REJECTION OF H(G)  (G=1,...,Q)          MAIN6160
C                                                                       MAIN6170
  620 ALPH=REJ(2)                                                       MAIN6180
      IF(.NOT.H(G))GO TO 630                                            MAIN6190
      H(G)=.FALSE.                                                      MAIN6200
      HH=.FALSE.                                                        MAIN6210
  630 NCNT(G)=NCNT(G)+1                                                 MAIN6220
      WVAR(G,NCNT(G))=J                                                 MAIN6230
      GO TO 650                                                         MAIN6240
  640 ALPH=REJ(1)                                                       MAIN6250
C                                                                       MAIN6260
C OUTPUT THE STATISTIC, THE CONDITIONAL LIN COMB ESTIMATE, THE          MAIN6270
C CONFIDENCE INTERVAL, AND PRINT A '*' IF THE SUBHYPOTHESIS IS          MAIN6280
C REJECTED.                                                             MAIN6290
C                                                                       MAIN6300
  650 IF(NSIDED.NE.2)GO TO 660                                          MAIN6310
      IF(J.EQ.1)WRITE(36,10680)                                         MAIN6320
     1 G,F,ALPH,LAMDA,LEFT,RIGHT                                        MAIN6330
      IF(J.GT.1)WRITE(36,10680)                                         MAIN6340
     1  G,F,ALPH,LAMDA,LEFT,RIGHT,EST,LEFT1,RIGHT1                      MAIN6350
      GO TO 670                                                         MAIN6360
  660 IF(NSIDED.EQ.1)WRITE(36,10690)                                    MAIN6370
     1  G,F,ALPH,LAMDA,LEFT                                             MAIN6380
      IF(NSIDED.EQ.0)WRITE(36,10700)                                    MAIN6390
     1  G,F,ALPH,LAMDA,RIGHT                                            MAIN6400
  670 CONTINUE                                                          MAIN6410
      IF(J.EQ.P)GO TO 680                                               MAIN6420
      J=J+1                                                             MAIN6430
      IF(KNOWS.EQ.0)GO TO 390                                           MAIN6440
      REPEAT=.TRUE.                                                     MAIN6450
      GO TO 390                                                         MAIN6460
C                                                                       MAIN6470
C FINALLY , PRINT A SUMMARY THEN STOP EXECUTION.                        MAIN6480
C                                                                       MAIN6490
  680 WRITE(36,10710)                                                   MAIN6500
      DO 690 G=1,Q                                                      MAIN6510
      IF(.NOT.H(G))WRITE(36,10720)G,(WVAR(G,J),J=1,NCNT(G))             MAIN6520
  690 CONTINUE                                                          MAIN6530
      IF(HH)WRITE(36,10730)                                             MAIN6540
      WRITE(36,10740)ALPHA2                                             MAIN6550
      WRITE(6,10750)                                                    MAIN6560
      STOP                                                              MAIN6570
C                                                                       MAIN6580
10000 FORMAT(1X,50HTHIS PROGRAM PERFORMS SIMULTANEOUS TEST PROCEDURES,  MAIN6590
     1  /1X,50HON MEAN VECTORS OF MULTIVARIATE NORMAL POPULATIONS,      MAIN6600
     2 //1X,27HENTER NUMBER OF POPULATIONS/)                            MAIN6610
10010 FORMAT(10I4)                                                      MAIN6620
10020 FORMAT(/52H ENTER A NAME CONTAINING FIVE CHARACTERS FOR EACH OF,  MAIN6630
     1I3,/40H POPULATIONS.  SPACE ONCE BETWEEN NAMES /)                 MAIN6640
10030 FORMAT(10(5A1,1X))                                                MAIN6650
10040 FORMAT(2X,10(5A1,1X))                                             MAIN6660
10050 FORMAT(/41H ENTER NUMBER OF OBSERVATIONS FOR EACH OF,             MAIN6670
     1I4,12H POPULATIONS)                                               MAIN6680
10060 FORMAT(/26H ENTER NUMBER OF VARIABLES /)                          MAIN6690
10070 FORMAT(/52H ENTER A NAME CONTAINING FIVE CHARACTERS FOR EACH OF,  MAIN6700
     1I3,/38H VARIABLES.  SPACE ONCE BETWEEN NAMES /)                   MAIN6710
10080 FORMAT(53H0ENTER 0 TO TEST ALL PAIRWISE COMPARISONS, (ALLOWABLE,  MAIN6720
     1 /9X,49HONLY WHEN THE NUMBER OF POPULATIONS IS 7 OR LESS),        MAIN6730
     2  /6X,25H-1 TO TEST ADJACENT MEANS,/                              MAIN6740
     3  6X,54H-2 TO TEST AGAINST A CONTROL USING THE LAST POPULATION,/  MAIN6750
     4  9X,28HAS THE CONTROLLED POPULATION,/                            MAIN6760
     56X,49HOR THE NUMBER OF LINEAR COMBINATIONS, IF YOU WISH/          MAIN6770
     6 9X,39HTO ENTER YOUR COMBINATIONS (MAXIMUM 21))                   MAIN6780
10090 FORMAT(48H THE MAXIMUM NUMBER OF COMPARISONS ALLOWED IS 21,       MAIN6790
     1/28H ALL PAIRWISE COMPARISONS OF,I3,27H POPULATIONS GIVE MORE THANMAIN6800
     2  /47H 21 COMPARISONS.  PLEASE MAKE ANOTHER SELECTION)            MAIN6810
10100 FORMAT(1X,6HENTER,I3,8H ROWS OF,I3,8H WEIGHTS)                    MAIN6820
10110 FORMAT(14X,10(F10.4,1X))                                          MAIN6830
10120 FORMAT(1H1,49HSIMULTANEOUS TEST ON MEAN VECTORS OF MULTIVARIATE,  MAIN6840
     1  19H NORMAL POPULATIONS//)                                       MAIN6850
10130 FORMAT(/30H ENTER 1 TO PRINT OBSERVATIONS,                        MAIN6860
     1/1X,17H      0 OTHERWISE)                                         MAIN6870
10140 FORMAT(/1X,10HPOPULATION,I3,1H:,4X,5A1//13X,10(6X,5A1))           MAIN6880
10150 FORMAT(//1X,12HSAMPLE MEANS/13X,10(6X,5A1))                       MAIN6890
10160 FORMAT(7X,5A1,2X,10(F10.4,1X))                                    MAIN6900
10170 FORMAT(/25H TYPE 1 IF SIGMA IS KNOWN,/                            MAIN6910
     11X,28HTYPE 0 IF SIGMA IS NOT KNOWN/)                              MAIN6920
10180 FORMAT(1X,5HENTER,I3,1HX,I3,17HCOVARIANCE MATRIX)                 MAIN6930
10190 FORMAT(//1X,10HSSP MATRIX)                                        MAIN6940
10200 FORMAT(//1X,17HCOVARIANCE MATRIX)                                 MAIN6950
10210 FORMAT(13X,10(6X,5A1))                                            MAIN6960
10220 FORMAT(//1X,21HNUMBER OF POPULATIONS,I15,                         MAIN6970
     1  /1X,19HNUMBER OF VARIABLES,I17                                  MAIN6980
     2 /1X,22HNUMBER OF OBSERVATIONS,9X,10I5)                           MAIN6990
10230 FORMAT(//1X,42HLINEAR COMBINATIONS USED IN FOLLOWING TEST/)       MAIN7000
10240 FORMAT(5X,10(5X,5A1))                                             MAIN7010
10250 FORMAT(/1X,I4,1H:,10(F9.4,1X))                                    MAIN7020
10260 FORMAT(/51H TYPE 0 FOR TESTING AGAINST LINEAR COMBINATIONS < 0,/  MAIN7030
     11X,50HTYPE 1 FOR TESTING AGAINST LINEAR COMBINATIONS > 0,/        MAIN7040
     21X,25HTYPE 2 FOR TWO SIDED TEST/)                                 MAIN7050
10270 FORMAT(44H0ENTER ALPHA LEVEL DESIRED (INCLUDE DECIMAL)/)          MAIN7060
10280 FORMAT(53H0THE MAXIMUM DEGREES OF FREEDOM IN THIS EXPERIMENT IS,  MAIN7070
     1I5/54H0THE FOLLOWING APPROXIMATIONS TO THE CRITICAL VALUE(S)      MAIN7080
     2,15H ARE AVAILABLE./39H ENTER THE NUMBER CORRESPONDING TO YOUR    MAIN7090
     3,8H CHOICE.)                                                      MAIN7100
10290 FORMAT(36H0  1  TO USE THE PRODUCT UPPER BOUND)                   MAIN7110
10300 FORMAT(48H0  2  TO USE THE UPPER BOUND BASED ON POINCARE'S        MAIN7120
     1,8H FORMULA)                                                      MAIN7130
10310 FORMAT(48H0  3  TO USE THE LOWER BOUND BASED ON POINCARE'S        MAIN7140
     1,8H FORMULA)                                                      MAIN7150
10320 FORMAT(48H0  2  TO USE THE UPPER BOUND BASED ON POINCARE'S        MAIN7160
     1,8H FORMULA/48H0  3  TO USE THE LOWER BOUND BASED ON POINCARE'S   MAIN7170
     2,8H FORMULA/38H0  4  TO USE THE AVERAGE OF POINCARE'S             MAIN7180
     3,48H UPPER BOUND (2)  AND POINCARE'S LOWER BOUND (3))             MAIN7190
10330 FORMAT(51H0  5  TO USE THE AVERAGE OF THE PRODUCT UPPER BOUND     MAIN7200
     1,36H (1)  AND POINCARE'S LOWER BOUND (3)    )                     MAIN7210
10340 FORMAT(32H0  6  TO USE SIDAK'S UPPER BOUND                        MAIN7220
     1/51H0  7  TO USE THE AVERAGE OF SIDAK'S UPPER BOUND (6)           MAIN7230
     2,32H  AND POINCARE'S LOWER BOUND (3))                             MAIN7240
10350 FORMAT(47H0  8  TO USE AN EXACT CRITICAL VALUE FOR LINEAR         MAIN7250
     1,29H COMBINATIONS ON VARIABLE #1.)                                MAIN7260
10360 FORMAT(6X,46HONE OF OPTIONS 1-7, OR 9 WILL BE REQUESTED FOR       MAIN7270
     1,25H THE REMAINING VARIABLES.)                                    MAIN7280
10370 FORMAT(43H0WHICH OPTION (1-7, OR 9) FOR THE REMAINING,I3          MAIN7290
     1,11H VARIABLES?/)                                                 MAIN7300
10380 FORMAT(48H0  9  IF CRITICAL VALUES ARE KNOWN, AND YOU WISH        MAIN7310
     1,14H TO ENTER THEM/)                                              MAIN7320
10390 FORMAT(10H0ENTER THE,I3,25H KNOWN CRITICAL VALUE(S):/)            MAIN7330
10400 FORMAT(//1X,35H TWO SIDED FINITE INTERSECTION TEST,               MAIN7340
     1/1X,58H(* INDICATES TO REJECT THE SUBHYPOTHESIS OF NO DIFFERENCE))MAIN7350
10410 FORMAT(//1X,35H ONE SIDED FINITE INTERSECTION TEST,1X,            MAIN7360
     121H(AGAINST COMBINATION ,A2,2H0),                                 MAIN7370
     2/1X,58H(* INDICATES TO REJECT THE SUBHYPOTHESIS OF NO DIFFERENCE))MAIN7380
10420 FORMAT(////1X,8HVARIABLE,I3,1H:,40X,5A1/1X,11H-----------         MAIN7390
     1,41X,5H----- //20H DEGREES OF FREEDOM:,16X,I4,                    MAIN7400
     2  //14H S-SQUARE/NDF:,F26.4/)                                     MAIN7410
10430 FORMAT(////1X,8HVARIABLE,I3,1H:,40X,5A1/1X,11H-----------         MAIN7420
     1,41X,5H----- //20H DEGREES OF FREEDOM:,16X,I4,                    MAIN7430
     2  //26H CONDITIONAL S-SQUARE/NDF:,F14.4/)                         MAIN7440
10440 FORMAT(////1X,8HVARIABLE,I3,1H:,40X,5A1/1X,11H-----------         MAIN7450
     1,41X,5H----- //21H DEGREES OF FREEDOM: ,13X,2H1, I4,              MAIN7460
     2  //14H S-SQUARE/NDF:,F26.4/)                                     MAIN7470
10450 FORMAT(////1X,8HVARIABLE,I3,1H:,40X,5A1/1X,11H-----------         MAIN7480
     1,41X,5H----- //21H DEGREES OF FREEDOM: ,13X,2H1, I4,              MAIN7490
     2  //26H CONDITIONAL S-SQUARE/NDF:,F14.4/)                         MAIN7500
10460 FORMAT(////1X,8HVARIABLE,I3,1H:,40X,5A1/1X,11H-----------         MAIN7510
     1,41X,5H----- //21H DEGREES OF FREEDOM: ,19X,1H1,                  MAIN7520
     2  //10H VARIANCE:,F30.4/)                                         MAIN7530
10470 FORMAT(////1X,8HVARIABLE,I3,1H:,40X,5A1/1X,11H-----------         MAIN7540
     1,41X,5H----- //21H DEGREES OF FREEDOM: ,19X,1H1,                  MAIN7550
     2  //22H CONDITIONAL VARIANCE:,F18.4/)                             MAIN7560
10480 FORMAT(////1X,8HVARIABLE,I3,1H:,40X,5A1/1X,11H-----------         MAIN7570
     1,41X,5H----- //10H VARIANCE:,F30.4/)                              MAIN7580
10490 FORMAT(////1X,8HVARIABLE,I3,1H:,40X,5A1/1X,11H-----------         MAIN7590
     1,41X,5H----- //22H CONDITIONAL VARIANCE:,F18.4/)                  MAIN7600
10500 FORMAT(47X,11H AVERAGE OF)                                        MAIN7610
10510 FORMAT(47X,4H AND)                                                MAIN7620
10520 FORMAT(47X,23H POINCARE'S UPPER BOUND)                            MAIN7630
10530 FORMAT(47X,23H POINCARE'S LOWER BOUND)                            MAIN7640
10540 FORMAT(47X,20H SIDAK'S UPPER BOUND)                               MAIN7650
10550 FORMAT(47X,20H PRODUCT UPPER BOUND)                               MAIN7660
10560 FORMAT(47X,21H EXACT CRITICAL VALUE)                              MAIN7670
10570 FORMAT(47X,21H KNOWN CRITICAL VALUE)                              MAIN7680
10580 FORMAT(47X,18H ON MULTIVARIATE F)                                 MAIN7690
10590 FORMAT(47X,27H ON MULTIVARIATE CHI-SQUARE)                        MAIN7700
10600 FORMAT(47X,18H ON MULTIVARIATE T)                                 MAIN7710
10610 FORMAT(47X,23H ON MULTIVARIATE NORMAL)                            MAIN7720
10620 FORMAT(40X,33H??FAILURE TO CONVERGE-POINCARE'S ,A3                MAIN7730
     1,13HER BOUND USED)                                                MAIN7740
10630 FORMAT(16H CRITICAL VALUE:,32X,F10.3                              MAIN7750
     1/35H LEVEL OF SIGNIFICANCE FOR VARIABLE,I3,1H:,F19.3//)           MAIN7760
10640 FORMAT(91X,33H(C.I.'S ARE CRUDE APPROXIMATIONS))                  MAIN7770
10650 FORMAT(3X,6HLINEAR,26X,38HLINEAR COMBINATIONS OF THE CONDITIONAL  MAIN7780
     1 6H MEANS,8X,41HLINEAR COMBINATIONS OF THE ORIGINAL MEANS/        MAIN7790
     2 30H COMBINATION STATISTIC ACC/REJ,7X,8HESTIMATE,13X,             MAIN7800
     3 19HCONFIDENCE INTERVAL,12X,8HESTIMATE,10X,19HCONFIDENCE INTERVAL)MAIN7810
10660 FORMAT(3X,6HLINEAR,27X,35HLINEAR COMBINATIONS OF THE ORIGINAL     MAIN7820
     1 6H MEANS/30H COMBINATION STATISTIC ACC/REJ,7X,8HESTIMATE,13X,    MAIN7830
     2 19HCONFIDENCE INTERVAL)                                          MAIN7840
10670 FORMAT(3X,6HLINEAR,26X,38HLINEAR COMBINATIONS OF THE CONDITIONAL  MAIN7850
     1 6H MEANS/30H COMBINATION STATISTIC ACC/REJ,7X,8HESTIMATE,13X,    MAIN7860
     2 19HCONFIDENCE INTERVAL)                                          MAIN7870
10680 FORMAT(I7,F14.3,7X,A1,F15.4,11X,2H [,F10.4,1H,,F10.4,1H],F17.4,8X,MAIN7880
     1  2H [,F10.4,1H,,F10.4,1H])                                       MAIN7890
10690 FORMAT(I7,F14.3,7X,A1,F15.4,11X,2H [,F10.4,12H,  INFINITY))       MAIN7900
10700 FORMAT(I7,F14.3,7X,A1,F15.4,12X,12H( -INFINITY,,F10.4,1H])        MAIN7910
10710 FORMAT(////14X,13H** SUMMARY **)                                  MAIN7920
10720 FORMAT(/6X,9HREJECT H(,I2,                                        MAIN7930
     130H), ON THE BASIS OF VARIABLE(S),10I4)                           MAIN7940
10730 FORMAT(/6X,26HACCEPT THE NULL HYPOTHESIS)                         MAIN7950
10740 FORMAT(/5X,23H LEVEL OF SIGNIFICANCE:,F7.3)                       MAIN7960
10750 FORMAT(/1X,33HTHE RESULTS ARE STORED ON UNIT 36)                  MAIN7970
      END                                                               MAIN7980
      SUBROUTINE BOUND(IDISTR,OPTION,IQ,N,SIG,AVG,ALPH2,TROBLE)         BUND0010
      DIMENSION A(21),SIG(210),EQICOR(21),ZEROES(21)                    BUND0020
      INTEGER OPTION                                                    BUND0030
      LOGICAL TROBLE                                                    BUND0040
      COMMON /IBOUND/IBOUND(8,2)                                        BUND0050
      COMMON /NSIDED/NSIDED,UPPLOW(2),IFAIL                             BUND0060
      COMMON /NCALL/NCALL                                               BUND0070
      DATA EQICOR/21*0.7071068118/                                      BUND0080
      DATA ZEROES/21*0.0/                                               BUND0090
      NCALL=1                                                           BUND0100
      RN=N                                                              BUND0110
      AVG=0.                                                            BUND0120
      K=0                                                               BUND0130
   10 K=K+1                                                             BUND0140
      IBND=IBOUND(OPTION,K)                                             BUND0150
      IF(IBND.EQ.0)GO TO 140                                            BUND0160
C                                                                       BUND0170
C THE POINCARE' INEQUALITIES ARE REVERSED WHEN TESTING AGAINST          BUND0180
C ALTERNATIVE  A**  (NSIDED=0).                                         BUND0190
C                                                                       BUND0200
      IF(NSIDED.EQ.0)IBND=5-IBND                                        BUND0210
   20 AI=10.                                                            BUND0220
      AV=AI                                                             BUND0230
      ALOW=0.0                                                          BUND0240
      NCNT=0                                                            BUND0250
   30 DO 40 I=1,IQ                                                      BUND0260
   40 A(I)=AV                                                           BUND0270
      GO TO (50,60,60,70,80),IBND                                       BUND0280
   50 CALL PRODCT(N,RN,IQ,A,RMT,IDISTR)                                 BUND0290
      GO TO 90                                                          BUND0300
   60 IPROB=IBND-1                                                      BUND0310
      CALL HILOW(RN,N,40.,10.,ZEROES,RMT,IQ,IDISTR,IPROB,A,SIG)         BUND0320
      GO TO 90                                                          BUND0330
   70 CALL RMULF1(RN,40.,IQ,ZEROES,ZEROES,A,RMT)                        BUND0340
      GO TO 90                                                          BUND0350
   80 CALL RMULF1(RN,40.,IQ,EQICOR,ZEROES,A,RMT)                        BUND0360
   90 NCNT=NCNT+1                                                       BUND0370
      IF(NCNT.EQ.20)GO TO 120                                           BUND0380
      IF(ABS(RMT-ALPH2) .LT. 1.E-5) GO TO 130                           BUND0390
      IF(RMT.GT.ALPH2)GO TO 100                                         BUND0400
      IF(AV.EQ.AI)GO TO 110                                             BUND0410
      ALOW=AV                                                           BUND0420
      AV=(ALOW+AI)/2.                                                   BUND0430
      GO TO 30                                                          BUND0440
  100 AI=AV                                                             BUND0450
      AV=(AI+ALOW)/2.                                                   BUND0460
      GO TO 30                                                          BUND0470
  110 ALOW=AV                                                           BUND0480
      AV=AV+10.                                                         BUND0490
      AI=AV                                                             BUND0500
      GO TO 30                                                          BUND0510
  120 IF(TROBLE)GO TO 150                                               BUND0520
      TROBLE=.TRUE.                                                     BUND0530
      IBND=2                                                            BUND0540
      K=2                                                               BUND0550
      AVG=0.                                                            BUND0560
      GO TO 20                                                          BUND0570
  130 AVG=AVG+AV                                                        BUND0580
      IF(K.EQ.1)GO TO 10                                                BUND0590
      IF(TROBLE)GO TO 140                                               BUND0600
      AVG=AVG/2.                                                        BUND0610
C                                                                       BUND0620
C THE CRITICAL VALUES FOR A** ARE THE NEGATIVES OF THOSE FOR A*.        BUND0630
C                                                                       BUND0640
  140 IF(NSIDED.EQ.0)AVG=-AVG                                           BUND0650
      RETURN                                                            BUND0660
  150 WRITE(6,10000)OPTION,UPPLOW(IFAIL)                                BUND0670
      WRITE(36,10000)OPTION,UPPLOW(IFAIL)                               BUND0680
      STOP                                                              BUND0690
10000 FORMAT(52H0??FAILED TO CONVERGE TO CRITICAL VALUE USING OPTION,I2 BUND0700
     1/39H ??FAILED TO CONVERGE USING POINCARE'S ,A3,11HER-BOUND AS     BUND0710
     2,16H FAILSAFE OPTION                                              BUND0720
     3/42H0EXECUTION TERMINATED BY SUBROUTINE BOUND.                    BUND0730
     4/50H0PLEASE CONTACT Neil H. Timm, DEPT OF MATH/STAT               BUND0740
     5,13H, UNIV OF PGH)                                                BUND0750
      END                                                               BUND0760
      SUBROUTINE CNTRST(CTR,K,IW,IQ)                                    CNTR0010
      DIMENSION CTR(21,10)                                              CNTR0020
      DO 10 I=1,21                                                      CNTR0030
      DO 10 J=1,10                                                      CNTR0040
   10 CTR(I,J)=0.0                                                      CNTR0050
      IQ=K-1                                                            CNTR0060
      IF(IW.EQ.-2)GO TO 50                                              CNTR0070
      IF(IW.EQ.-1)GO TO 30                                              CNTR0080
      IG=0                                                              CNTR0090
      DO 20 NVAR1=1,IQ                                                  CNTR0100
      NXTVAR=NVAR1+1                                                    CNTR0110
      DO 20 NVAR2=NXTVAR,K                                              CNTR0120
      IG=IG+1                                                           CNTR0130
      CTR(IG,NVAR1)=1.                                                  CNTR0140
   20 CTR(IG,NVAR2)=-1.                                                 CNTR0150
      IQ=IG                                                             CNTR0160
      RETURN                                                            CNTR0170
   30 DO 40 IG=1,IQ                                                     CNTR0180
      CTR(IG,IG)=1.                                                     CNTR0190
      IGG=IG+1                                                          CNTR0200
   40 CTR(IG,IGG)=-1.                                                   CNTR0210
      RETURN                                                            CNTR0220
   50 DO 60 IG=1,IQ                                                     CNTR0230
      CTR(IG,IG)=1.                                                     CNTR0240
   60 CTR(IG,K)=-1.                                                     CNTR0250
      RETURN                                                            CNTR0260
      END                                                               CNTR0270
      SUBROUTINE PRODCT(N,RN,IQ,A,RMT,IDISTR)                           PRDC0010
      DIMENSION A(21)                                                   PRDC0020
      RMT=1.                                                            PRDC0030
      DO 10 I=1,IQ                                                      PRDC0040
c     IF(IDISTR.EQ.1)CALL MDFD(A(I),1,N,P,IER)                          PRDC0050
      if(idistr.eq.1) p=fdf(a(i),1,n)                                        new
c     IF(IDISTR.EQ.2)CALL MDCH(A(I),RN,P,IER)                           PRDC0060
      if(idistr.eq.2) p=chidf(a(i),rn)                                       new
   10 RMT=RMT*P                                                         PRDC0070
      RETURN                                                            PRDC0080
      END                                                               PRDC0090
      SUBROUTINE RMULKI(C,H,RMU,RMN,IQ)                                 RMLK0010
      DIMENSION C(21),D(21),DEL(21),DEL2(21),H(21),RMU(21)              RMLK0020
      COMMON /XMNAMN/ XMN(40),AMN(40)                                   RMLK0030
      COMMON /UNDFLO/UNDFLO                                             RMLK0040
      DO 10 I=1,IQ                                                      RMLK0050
      D(I)=SQRT(1.-C(I)**2)                                             RMLK0060
   10 CONTINUE                                                          RMLK0070
      RMN=0.                                                            RMLK0080
      DO 50 J=1,40                                                      RMLK0090
      DO 20 I=1,IQ                                                      RMLK0100
      DEL (I)=(SQRT(H(I))-RMU(I)+C(I)*SQRT(2.)*XMN(J))/D(I)             RMLK0110
      DEL2(I)=((-(SQRT(H(I))))-RMU(I)+C(I)*SQRT(2.)*XMN(J))/D(I)        RMLK0120
   20 CONTINUE                                                          RMLK0130
c     CALL MDNOR(DEL(1),ERF)                                            RMLK0140
      erf=anordf(del(1))                                                     new
c     CALL MDNOR(DEL2(1),ERF2)                                          RMLK0150
      erf2=anordf(del2(1))                                                   new
      CMU=ERF-ERF2                                                      RMLK0160
      IF(IQ.LT.2)GO TO 40                                               RMLK0170
      IF(CMU.EQ.0.)GO TO 50                                             RMLK0180
      DO 30 II=2,IQ                                                     RMLK0190
c     CALL MDNOR(DEL(II),ERF)                                           RMLK0200
      erf=anordf(del(ii))                                                    new
c     CALL MDNOR(DEL2(II),ERF2)                                         RMLK0210
      erf2=anordf(del2(ii))                                                  new
      ERF1=ERF-ERF2                                                     RMLK0220
      IF(ALOG10(CMU)+ALOG10(ERF1).LT.UNDFLO)GO TO 50                    RMLK0230
      CMU=CMU*ERF1                                                      RMLK0240
   30 CONTINUE                                                          RMLK0250
   40 IF(-.24857494+ALOG10(CMU)+ALOG10(AMN(J)).LT.UNDFLO)GO TO 50       RMLK0260
      RMN=(1./SQRT(3.14159265))*AMN(J)*CMU+RMN                          RMLK0270
   50 CONTINUE                                                          RMLK0280
      RETURN                                                            RMLK0290
      END                                                               RMLK0300
      SUBROUTINE RMULF1(RN,CUT,IQ,C,RMU,A,RMT)                          RMLF0010
      DIMENSION A(21),C(21),H(21),RMU(21)                               RMLF0020
      DIMENSION TEM3(48)                                                RMLF0030
      COMMON /XMTAMT/ XMT(48),AMT(48)                                   RMLF0040
      COMMON /UNDFLO/UNDFLO                                             RMLF0050
      COMMON /NCALL/NCALL                                               RMLF0060
      RMT=0.                                                            RMLF0070
      IF(NCALL.GT.1)GO TO 30                                            RMLF0080
      GA=RN/2                                                           RMLF0090
C     CALL MGAMMA(GA,GY,IER)                                            RMLF0100
      GY=GAMMA(GA)                                                      RMLF0110
      RMOD=(CUT/2.)**(RN/2.)/GY                                         RMLF0120
      POWER=RN/2.-1.                                                    RMLF0130
      DO 20 J=1,48                                                      RMLF0140
      XMTJ1=XMT(J)+1.                                                   RMLF0150
      TEM1=EXP(-(CUT*XMTJ1/2.))                                         RMLF0160
      IF(POWER*ALOG10(XMTJ1).LT.UNDFLO)GO TO 10                         RMLF0170
      TEM2=XMTJ1**POWER                                                 RMLF0180
      TEM3(J)=AMT(J)*RMOD*TEM1*TEM2                                     RMLF0190
      GO TO 20                                                          RMLF0200
   10 TEM3(J)=0.0                                                       RMLF0210
   20 CONTINUE                                                          RMLF0220
      NCALL=2                                                           RMLF0230
   30 DO 50 J=1,48                                                      RMLF0240
      DO 40 I=1,IQ                                                      RMLF0250
      H(I)=(A(I)*CUT*(XMT(J)+1.))/RN                                    RMLF0260
   40 CONTINUE                                                          RMLF0270
      CALL RMULKI(C,H,RMU,RMN,IQ)                                       RMLF0280
      RMT=RMT+TEM3(J)*RMN                                               RMLF0290
   50 CONTINUE                                                          RMLF0300
      RETURN                                                            RMLF0310
      END                                                               RMLF0320
      SUBROUTINE RMULNR(C,H,RMU,RMN,IQ)                                 RMLN0010
      DIMENSION C(21),D(21),H(21),DEL(21),RMU(21)                       RMLN0020
      COMMON /XMNAMN/ XMN(40),AMN(40)                                   RMLN0030
      DO 10 I=1,IQ                                                      RMLN0040
      D(I)=SQRT(1.-C(I)**2)                                             RMLN0050
   10 CONTINUE                                                          RMLN0060
      RMN=0.                                                            RMLN0070
      DO 50 J=1,40                                                      RMLN0080
      DO 20 I=1,IQ                                                      RMLN0090
      DEL (I)=(H(I)-RMU(I)+C(I)*SQRT(2.)*XMN(J))/D(I)                   RMLN0100
   20 CONTINUE                                                          RMLN0110
c     CALL MDNOR(DEL(1),ERF)                                            RMLN0120
      erf=anordf(del(1))                                                     new
      CMU=ERF                                                           RMLN0130
      IF(IQ.LT.2)GO TO 40                                               RMLN0140
      DO 30 II=2,IQ                                                     RMLN0150
c     CALL MDNOR(DEL(II),ERF)                                           RMLN0160
      erf=anordf(del(ii))                                                    new
      CMU=CMU*ERF                                                       RMLN0170
   30 CONTINUE                                                          RMLN0180
   40 RMN=(1./SQRT(3.14159265))*AMN(J)*CMU+RMN                          RMLN0190
   50 CONTINUE                                                          RMLN0200
      RETURN                                                            RMLN0210
      END                                                               RMLN0220
      SUBROUTINE RMULT(RN,N,CUT,IQ,C,RMU,A,RMT)                         RMLT0010
      DIMENSION A(21),C(21),H(21),RMU(21)                               RMLT0020
      DIMENSION TEM3(48)                                                RMLT0030
      COMMON /XMTAMT/ XMT(48),AMT(48)                                   RMLT0040
      COMMON /UNDFLO/UNDFLO                                             RMLT0050
      COMMON /NCALL/NCALL                                               RMLT0060
      RMT=0.                                                            RMLT0070
      IF(IQ.EQ.2)RHO=C(1)*C(2)                                          RMLT0080
      IF(NCALL.GT.1)GO TO 30                                            RMLT0090
      GA=RN/2.                                                          RMLT0100
C     CALL MGAMMA(GA,GY,IER)                                            RMLT0110
      GY=GAMMA(GA)                                                      RMLT0120
C     RMOD=(CUT**N)/((2.**(N-1))*GY)                                    RMLT0130
      RMOD=CUT*(CUT/2.)**(N-1)/GY                                       RMLT0140
      DO 20 J=1,48                                                      RMLT0150
      XMTJ1=XMT(J)+1.                                                   RMLT0160
C     TEM1=EXP(-((CUT*XMTJ1)**2)/4.)                                    RMLT0170
      POWER=-(CUT*XMTJ1)**2/4.                                          RMLT0180
C       ALOG10(EXP(1.))= 0.43429448                                     RMLT0190
      IF(POWER*0.43429448 .LT.UNDFLO)GO TO 10                           RMLT0200
      TEM1=EXP(POWER)                                                   RMLT0210
      TEM2=XMTJ1**(N-1)                                                 RMLT0220
      TEM3(J)=AMT(J)*RMOD*TEM1*TEM2                                     RMLT0230
      GO TO 20                                                          RMLT0240
   10 TEM3(J)=0.0                                                       RMLT0250
   20 CONTINUE                                                          RMLT0260
      NCALL=2                                                           RMLT0270
   30 DO 60 J=1,48                                                      RMLT0280
      DO 40 I=1,IQ                                                      RMLT0290
      H(I)=(A(I)*CUT*(XMT(J)+1.))/(SQRT(2.*RN))                         RMLT0300
   40 CONTINUE                                                          RMLT0310
      IF(IQ.EQ.2)GO TO 50                                               RMLT0320
      CALL RMULNR(C,H,RMU,RMN,IQ)                                       RMLT0330
      GO TO 60                                                          RMLT0340
c  50 CALL MDBNOR(H(1),H(2),RHO,RMN,IER)                                RMLT0350
   50 rmn=bnrdf(h(1),h(2),rho)                                               new
   60 RMT=RMT+TEM3(J)*RMN                                               RMLT0360
   70 CONTINUE                                                          RMLT0370
      RETURN                                                            RMLT0380
      END                                                               RMLT0390
      SUBROUTINE HILOW(RN,N,CUT1,CUT2,RMU,RMT1,IQ,IDISTR,IPROB,A,SIG)   HLOW0010
      DIMENSION A(21),SIG(210),RMU(21),PROB(21),RMUTEM(2),ATEM(2)       HLOW0020
      DIMENSION CTEM(2)                                                 HLOW0030
      RMT1=0.                                                           HLOW0040
      K=0                                                               HLOW0050
      DO 60 I=1,IQ                                                      HLOW0060
      GO TO (10,20,30,40),IDISTR                                        HLOW0070
c  10 CALL MDFD(A(I),1,N,ANSW,IER)                                      HLOW0080
   10 answ=fdf(a(i),1,n)                                                     new
      GO TO 50                                                          HLOW0090
c  20 CALL MDCH(A(I),RN,ANSW,IER)                                       HLOW0100
   20 answ=chidf(a(i),rn)                                                    new
      GO TO 50                                                          HLOW0110
c  30 CALL MDTD(A(I),RN,ANSW,IER)                                       HLOW0120
   30 answ=tdf(a(i),rn)                                                      new
      ANSW=1.-ANSW/2.                                                   HLOW0130
      GO TO 50                                                          HLOW0140
c  40 CALL MDNOR(A(I),ANSW)                                             HLOW0150
   40 answ=anordf(a(i))                                                      new
   50 PROB(I)=ANSW                                                      HLOW0160
   60 RMT1=RMT1+(1.-ANSW)                                               HLOW0170
      RMT1=1.-RMT1                                                      HLOW0180
      IF(IPROB.EQ.1)RETURN                                              HLOW0190
      IQ1=IQ-1                                                          HLOW0200
      DO 90 I=1,IQ1                                                     HLOW0210
      I1=I+1                                                            HLOW0220
      DO 90 J=I1,IQ                                                     HLOW0230
      K=K+1                                                             HLOW0240
      SIGK=SIG(K)                                                       HLOW0250
      CTEM(1)=SQRT(ABS(SIGK))                                           HLOW0260
      CTEM(2)=CTEM(1)                                                   HLOW0270
      IF(SIGK.LT.0.0)CTEM(2)=-CTEM(2)                                   HLOW0280
      RMUTEM(1)=RMU(I)                                                  HLOW0290
      RMUTEM(2)=RMU(J)                                                  HLOW0300
      ATEM(1)=A(I)                                                      HLOW0310
      ATEM(2)=A(J)                                                      HLOW0320
      IF(IDISTR.GT.1)GO TO 80                                           HLOW0330
      RESU=0.0                                                          HLOW0340
      SQRTAI=SQRT(A(I))                                                 HLOW0350
      SQRTAJ=SQRT(A(J))                                                 HLOW0360
      DO 70 L=-1,1,2                                                    HLOW0370
      DO 70 M=-1,1,2                                                    HLOW0380
      ATEM(1)=L*SQRTAI                                                  HLOW0390
      ATEM(2)=M*SQRTAJ                                                  HLOW0400
      CALL RMULT(RN,N,CUT2,2,CTEM,RMUTEM,ATEM,R)                        HLOW0410
   70 RESU=RESU+L*M*R                                                   HLOW0420
   80 IF(IDISTR.EQ.2)CALL RMULKI(CTEM,ATEM,RMUTEM,RESU,2)               HLOW0430
      IF(IDISTR.EQ.3)CALL RMULT(RN,N,CUT2,2,CTEM,RMUTEM,ATEM,RESU)      HLOW0440
      IF(IDISTR.EQ.4)CALL RMULNR(CTEM,ATEM,RMUTEM,RESU,2)               HLOW0450
      RMT1=RMT1+(1.-PROB(I)-PROB(J)+RESU)                               HLOW0460
   90 CONTINUE                                                          HLOW0470
      RETURN                                                            HLOW0480
      END                                                               HLOW0490
      BLOCK DATA                                                        BLKD0010
      COMMON /IBOUND/IBOUND(8,2)                                        BLKD0020
      COMMON /UNDFLO/UNDFLO                                             BLKD0030
      COMMON /XMNAMN/ XMN(40),AMN(40)                                   BLKD0040
      COMMON /XMTAMT/ XMT(48),AMT(48)                                   BLKD0050
      DATA IBOUND/1,2,3,2,1,4,4,5,                                      BLKD0060
     1            0,0,0,3,3,0,3,0/                                      BLKD0070
      DATA UNDFLO/-38.83287/                                            BLKD0080
      DATA XMN/ 8.0987611392508500520    ,  7.4115825314854688094    ,  BLKD0090
     1          6.8402373052493554178    ,  6.3282553512200819556    ,  BLKD0100
     2          5.8540950560304001080    ,  5.4066542479701276084    ,  BLKD0110
     3          4.9792609785452558716    ,  4.5675020728443948551    ,  BLKD0120
     4          4.1682570668325002015    ,  3.7792067534352234931    ,  BLKD0130
     5          3.3985582658596283462    ,  3.0248798839012844376    ,  BLKD0140
     6          2.6569959984428957949    ,  2.2939171418750834218    ,  BLKD0150
     7          1.9347914722822957932    ,  1.5788698949316138862    ,  BLKD0160
     8          1.2254801090462890309    ,  0.87400661235708807743   ,  BLKD0170
     9          0.52387471383227719261   ,  0.17453721459758238348   ,  BLKD0180
     1         -0.17453721459758238348   , -0.52387471383227719261   ,  BLKD0190
     2         -0.87400661235708807743   , -1.2254801090462890309    ,  BLKD0200
     3         -1.5788698949316138862    , -1.9347914722822957932    ,  BLKD0210
     4         -2.2939171418750834218    , -2.6569959984428957949    ,  BLKD0220
     5         -3.0248798839012844376    , -3.3985582658596283462    ,  BLKD0230
     6         -3.7792067534352234931    , -4.1682570668325002015    ,  BLKD0240
     7         -4.5675020728443948551    , -4.9792609785452558716    ,  BLKD0250
     8         -5.4066542479701276084    , -5.8540950560304001080    ,  BLKD0260
     9         -6.3282553512200819556    , -6.8402373052493554178    ,  BLKD0270
     1         -7.4115825314854688094    , -8.0987611392508500520    /  BLKD0280
      DATA AMN/ 0.2591043713E-28         ,  0.8544056963E-24         ,  BLKD0290
     1          0.2567593365E-20         ,  0.1989181012E-17         ,  BLKD0300
     2          0.6008358798E-15         ,  0.8805707645E-13         ,  BLKD0310
     3          0.7156528052E-11         ,  0.3525620791E-9          ,  BLKD0320
     4          0.1121236083E-7          ,  0.2411144163E-6          ,  BLKD0330
     5          0.3631576150E-5          ,  0.3936933981E-4          ,  BLKD0340
     6          0.3138535945E-3          ,  0.1871496829E-2          ,  BLKD0350
     7          0.8460888008E-2          ,  0.2931256553E-1          ,  BLKD0360
     8          0.7847460586E-1          ,  0.163378732713271        ,  BLKD0370
     9          0.265728251877377        ,  0.338643277425589        ,  BLKD0380
     1          0.338643277425589        ,  0.265728251877377        ,  BLKD0390
     2          0.163378732713271        ,  0.7847460586E-1          ,  BLKD0400
     3          0.2931256553E-1          ,  0.8460888008E-2          ,  BLKD0410
     4          0.1871496829E-2          ,  0.3138535945E-3          ,  BLKD0420
     5          0.3936933981E-4          ,  0.3631576150E-5          ,  BLKD0430
     6          0.2411144163E-6          ,  0.1121236083E-7          ,  BLKD0440
     7          0.3525620791E-9          ,  0.7156528052E-11         ,  BLKD0450
     8          0.8805707645E-13         ,  0.6008358798E-15         ,  BLKD0460
     9          0.1989181012E-17         ,  0.2567593365E-20         ,  BLKD0470
     1          0.8544056963E-24         ,  0.2591043713E-28         /  BLKD0480
      DATA XMT/ 0.99877100725242611860   ,  0.99353017226635075754   ,  BLKD0490
     1          0.98412458372282685774   ,  0.97059159254624725046   ,  BLKD0500
     2          0.95298770316043086072   ,  0.93138669070655433311   ,  BLKD0510
     3          0.90587913671556967282   ,  0.87657202027424788590   ,  BLKD0520
     4          0.84358826162439353071   ,  0.80706620402944262708   ,  BLKD0530
     5          0.76715903251574033925   ,  0.72403413092381465467   ,  BLKD0540
     6          0.67787237963266390521   ,  0.62886739677651362399   ,  BLKD0550
     7          0.57722472608397270381   ,  0.52316097472223303367   ,  BLKD0560
     8          0.46690290475095840454   ,  0.40868648199071672991   ,  BLKD0570
     9          0.34875588629216073815   ,  0.28736248735545557673   ,  BLKD0580
     1          0.22476379039468906122   ,  0.16122235606889171805   ,  BLKD0590
     2          0.097004699209462698930  ,  0.032380170962869362033  ,  BLKD0600
     3         -0.032380170962869362033  , -0.097004699209462698930  ,  BLKD0610
     4         -0.16122235606889171805   , -0.22476379039468906122   ,  BLKD0620
     5         -0.28736248735545557673   , -0.34875588629216073815   ,  BLKD0630
     6         -0.40868648199071672991   , -0.46690290475095840454   ,  BLKD0640
     7         -0.52316097472223303367   , -0.57722472608397270381   ,  BLKD0650
     8         -0.62886739677651362399   , -0.67787237963266390521   ,  BLKD0660
     9         -0.72403413092381465467   , -0.76715903251574033925   ,  BLKD0670
     1         -0.80706620402944262708   , -0.84358826162439353071   ,  BLKD0680
     2         -0.87657202027424788590   , -0.90587913671556967282   ,  BLKD0690
     3         -0.93138669070655433311   , -0.95298770316043086072   ,  BLKD0700
     4         -0.97059159254624725046   , -0.98412458372282685774   ,  BLKD0710
     5         -0.99353017226635075754   , -0.99877100725242611860   /  BLKD0720
      DATA AMT/ 0.0031533460523058386326 ,  0.0073275539012762621023 ,  BLKD0730
     1          0.011477234579234539489  ,  0.015579315722943848728  ,  BLKD0740
     2          0.019616160457355527814  ,  0.023570760839324379140  ,  BLKD0750
     3          0.027426509708356948200  ,  0.031167227832798088902  ,  BLKD0760
     4          0.034777222564770338892  ,  0.038241351065830706317  ,  BLKD0770
     5          0.041545082943464749214  ,  0.044674560856694280419  ,  BLKD0780
     6          0.047616658492490474825  ,  0.050359035553854474957  ,  BLKD0790
     7          0.052890189485193667095  ,  0.055199503699984162868  ,  BLKD0800
     8          0.057277292100403215705  ,  0.059114839698395635746  ,  BLKD0810
     9          0.060704439165893880052  ,  0.062039423159892663904  ,  BLKD0820
     1          0.063114192286254025657  ,  0.063924238584648186623  ,  BLKD0830
     2          0.064466164435950082206  ,  0.064737696812683922503  ,  BLKD0840
     3          0.064737696812683922503  ,  0.064466164435950082206  ,  BLKD0850
     4          0.063924238584648186623  ,  0.063114192286254025657  ,  BLKD0860
     5          0.062039423159892663904  ,  0.060704439165893880052  ,  BLKD0870
     6          0.059114839698395635746  ,  0.057277292100403215705  ,  BLKD0880
     7          0.055199503699984162868  ,  0.052890189485193667095  ,  BLKD0890
     8          0.050359035553854474957  ,  0.047616658492490474825  ,  BLKD0900
     9          0.044674560856694280419  ,  0.041545082943464749214  ,  BLKD0910
     1          0.038241351065830706317  ,  0.034777222564770338892  ,  BLKD0920
     2          0.031167227832798088902  ,  0.027426509708356948200  ,  BLKD0930
     3          0.023570760839324379140  ,  0.019616160457355527814  ,  BLKD0940
     4          0.015579315722943848728  ,  0.011477234579234539489  ,  BLKD0950
     5          0.0073275539012762621023 ,  0.0031533460523058386326 /  BLKD0960
      END                                                               BLKD0970
      subroutine vcvtsf (a,n,b,ib)
c Convert matrix in Symmetric Storage Mode to Full Storage Mode
c  A   - input vector of length N*(N+1)/2 containing an N by N symmetric 
c        matrix stored in symmetric storage mode.                     
c  N   - order of matrix A. (input)                    
c  B   - output matrix of dimension N by N containing matrix A in full storage
c        mode.              
c  IB  - row dimension of matrix B exactly as specified in the dimension
c        statement in the calling program. (input)     
      real               a(1),b(ib,1)
      i1 = (n*(n+1))/2
      j = n
    5 jp1 = j+1
      do 10 k = 1,j
         i = jp1-k
         b(i,j) = a(i1)
         i1 = i1-1
   10 continue
      j = j-1
      if (j .ge. 1) go to 5
      if (n.lt.2) go to 25
      do 20 i = 2,n
         i1 = i-1
         do 15 j = 1,i1
            b(i,j) = b(j,i)
   15    continue
   20 continue
   25 return
      end
      subroutine vcvtfs (a,n,ia,b)
c Convert matrix in Full Storage Mode to Symmetric Storage Mode
c  A   - input matrix of dimension n by n.  A contains a symmetric matrix 
c        stored in full mode.     
c  N   - order of matrix A. (input)                    
c  IA  - row dimension of matrix A exactly as specified in the dimension
c        statement in the calling program. (input)                    
c  B   - output vector of dimension n*(n+1)/2 containing matrix a in symmetric
c        storage mode.   
      real               a(ia,1),b(1)
      k = 1
      do 10 i = 1,n
         do 5 j = 1,i
            b(k) = a(j,i)
            k = k+1
    5    continue
   10 continue
      return
      end
