/****************************************************/
/* Program Norm.sas                                 */
/* Program to create a multivariate normal data set */
/*                                                  */
/****************************************************/
options ls=80 nodate pageno=1 formdlim='o';
filename app1 'e:\norm.dat';
title1 ' Generating a Multivariate Normal Data Set';

proc iml;
   seed=30195;
   z=normal(repeat(seed,50,4));
   u={10,20,30,40};
   s={3 1 0  0,
      1 4 0  0,
      0 0 1  4,
      0 0 4 20};
   a=root(s);
   uu=repeat(u`,50,1);
   y=(z*a) + uu;
   print y;

file app1;
   do i=1 to nrow(y);
      do j=1 to ncol(y);
        put (y[i,j]) 10.2 +2 @;
      end;
     put;
   end;
closefile app1;
quit;
