/******************************************/
/* Ramus.sas                              */
/* Evaluation of Normality                */
/* Skewness and Kurtosis values           */
/* Elston and Grizzle(1962)               */
/* Ramus Bone Length Data for 20 Boys     */
/* At  Ages 8, 8.5, 9, and 9.5            */
/******************************************/

options ls=80 nodate pageno=1 formdlim='o';
filename multnorm 'e:\multnorm.sas';
%include multnorm;
data norm;
     infile 'e:\ramus.dat';
         input Group y1 y2 y3 y4 subject $;
         label subject='ID'
               y1= '8 yr'
               y2= '8.5 yr'
               y3= '9 yr'
               y4= '9.5 yr'
run;
Title1 'Ramus Growth Dataset';
proc print data=norm;
proc univariate data=norm normal plot vardef=n;
     var y1 y2 y3 y4;
     qqplot / normal(mu=est sigma=est);
run;
Title1 'Multivariate Chi-Square Plot';
%multnorm(data=norm,
          var=y1 y2 y3 y4,
          plot=yes);
run;
%let var= y1 y2 y3 y4;
%let id=subject;
/* Verification of the Calculation of Mahalanobis Distance Squared */
proc iml;
reset;
start dsquare;
      use _last_;
          read all var {&var} into x [colname=vars rowname=&id];
          n=nrow(x);
          p=ncol(x);
      r1=&id;
          m= x[ : ,];                     *--Means;
          d=x-j(n,1)*m;
      s=d`*d/(n-1);                   *-- Cov Matrix;
          dsq=vecdiag(d *inv(s) *d`);     *-- D**2;
          r=rank(dsq);
          val=dsq; dsq[ r, ] =val;
          val=r1; &id[r ]=val;
          z= ((1:n)` -.5)/n;
          chisq=cinv(z,p);          *--chi-sq %;
      result=dsq||chisq;
          cl={'DSQ' 'CHISQ'};
          create dsquare from result [colname=cl rowname=&id];
          append from result [rowname=&id];
          finish;
          run dsquare;
          quit;
          proc print data=dsquare;
          var subject dsq chisq;
          run;
