/******************************************/
/* Program Unorm.sas                      */
/* Evaluation of Univariate Normality     */
/* Skewness and Kurtosis                  */
/* Calculates sq(b1) and b2-3             */
/******************************************/

options ls=80 nodate pageno=1 formdlim='o';
%adxgen;
data norm;
     infile 'e:\norm.dat';
	 input y1 y2 y3 y4;
run;
proc print data=norm;
proc univariate data=norm normal plot vardef=n;
     var y1 y2;
     qqplot /normal(mu=est sigma=est);
run;
data n_norm;
     infile 'e:\non-norm.dat';
     input x1;
	 one=1;
run;
proc print data=n_norm;
proc univariate data=n_norm normal plot vardef=n;
     qqplot x1/normal(mu=est sigma=est);
run;

/* Box-Cox transformation for x1*/

%adxtrans(n_norm,result,x1,one);
proc print data=result;
run;
