/************************************************/
/* Program m3_7_2eps.sas                        */
/* Evaluating Multivariate Normality            */
/* Used to create very high resolution graphics */
/* Must change default device driver            */
/************************************************/
goptions reset=all device=pslepsfc gsfname=timm gsfmode=replace;
libname gdevice0 'c:\';
  proc gdevice c=gdevice0.devices nofs;
  copy pslepsfc from=sashelp.devices newname=eps1200;
  modify eps1200
    xmax=8.5      ymax=11
    xpixels=10200 ypixels=13200;
 run;
quit;
options ls=80 nodate pageno=1;
filename multnorm 'e:\multnorm.sas';
libname exampl 'e:\';

%include multnorm;

data set1;
   set exampl.m371a;
   if grp=1;
run;
data set2;
   set exampl.m371a;
   if grp=2;
run;
data set3;
   set exampl.m371b;
   if grp=1;
run;
data set4;
   set exampl.m371b;
   if grp=2;
run;
data set5;
   set exampl.m371c;
   if grp=1;
run;
data set6;
   set exampl.m371c;
   if grp=2;
run;

title2 'Dataset=m371a Grp=1';
%multnorm(data=set1,
          var=col1 col2 col3,
          plot=yes);
run;

title2 'Dataset=m371a Grp=2';
%multnorm(data=set2,
          var=col1 col2 col3,
          plot=yes);
run;

title2 'Dataset=m371b Grp=1';
%multnorm(data=set3,
          var=col1 col2 col3,
          plot=yes);
run;

title2 'Dataset=m371b Grp=2';
%multnorm(data=set4,
          var=col1 col2 col3,
          plot=yes);
run;

title2 'Dataset=m371c Grp=1';
%multnorm(data=set5,
          var=col1 col2 col3,
          plot=yes);
run;

title2 'Dataset=m371c Grp=2';
%multnorm(data=set6,
          var=col1 col2 col3,
          plot=yes);
run;
quit;

proc iml;
   reset;
      use set1;
      read all var {col1 col2 col3} into y;
      n=nrow(y);
      p=ncol(y);
      m=y[ :,];
      d=y - j(n,1) * m;
      s=d` * d / (n-1);
      dsq=vecdiag(d * inv(s) * d`);
      r=rank(dsq);
      val=dsq;
      dsq [r, ] = val;
      z=((1:n)` - .5) /n;
      chisq=2*gaminv(z,p/2);
      dsqchi=dsq||chisq;
      cl1={'dsq' 'chisquan'};
      create dchi from dsqchi [colname=cl1];
      append from dsqchi;
      alpha=(p-2)/(2*p);
      beta=(n-p-2)/(2*(n-p-1));
      gamai=((1:n)-alpha)/(n-alpha-beta+1);
      df1=p/2;
      df2=(n-p-1)/2;
      betaquan=((((n-1)*(n-1))/n)*betainv(gamai,df1,df2))`;
      dsqbet = dsq||betaquan;
      cl2={'dsq' 'betaquan'};
      create dbet from dsqbet [colname=cl2];
      append from dsqbet;
   quit;

/* For Sas Version 6.12 need gsfname=out1 on goptions statement*/

filename timm 'c:\set1chi.eps';
goptions reset=all device=eps1200 gsfname=timm gsfmode=replace
   colors=(black) hsize=6in vsize=5in;
axis1 label=(angle=90 'D-Square');
axis2 label=('Chi-Square Quantile');
axis3 label=('Beta Quantile');
proc gplot data=dchi;
   title1 'Chi Square Q-Q Plot (Set A-Gr1)';
   plot dsq*chisquan /frame vaxis=axis1 haxis=axis2;
   symbol1 v=;
run;
quit;
/* For Sas Version 6.12 need gsfname=out2 on goptions statement*/

filename timm 'c:\set1bet.eps';
goptions device=eps1200 gsfname=timm gsfmode=replace
   colors=(black) hsize=6in vsize=5in;
proc gplot data=dbet;
   title1 'Beta Q-Q Plot (Set A-Gr1)';
   plot dsq*betaquan /frame vaxis=axis1 haxis=axis3;
   symbol1 v=;
run;

quit;
proc iml;
   reset;
      use set5;
      read all var {col1 col2 col3} into y;
      n=nrow(y);
      p=ncol(y);
      m=y[ :,];
      d=y - j(n,1) * m;
      s=d` * d / (n-1);
      dsq=vecdiag(d * inv(s) * d`);
      r=rank(dsq);
      val=dsq;
      dsq [r, ] = val;

      z=((1:n)` - .5) /n;
      chisq=2*gaminv(z,p/2);
      dsqchi=dsq||chisq;
      cl1={'dsq' 'chisquan'};
      create dchi from dsqchi [colname=cl1];
      append from dsqchi;

      alpha=(p-2)/(2*p);
      beta=(n-p-2)/(2*(n-p-1));
      gamai=((1:n)-alpha)/(n-alpha-beta+1);
      df1=p/2;
      df2=(n-p-1)/2;
      betaquan=((((n-1)*(n-1))/n)*betainv(gamai,df1,df2))`;
      dsqbet = dsq||betaquan;
      cl2={'dsq' 'betaquan'};
      create dbet from dsqbet [colname=cl2];
      append from dsqbet;
   quit;
/* For Sas Version 6.12 need gsfname=out3 on goptions statement*/
filename timm 'c:\set5chi.eps';
goptions reset=all device=eps1200 gsfname=timm gsfmode=replace
   colors=(black) hsize=6in vsize=5in;
proc gplot data=dchi;
   title1 'Chi Square Q-Q Plot (Set C-Gr1)';
   plot dsq*chisquan /frame vaxis=axis1 haxis=axis2;
   symbol1 v=;
run;
quit;
/* For Sas Version 6.12 need gsfname=out4 on goptions statement*/
filename timm 'c:\set5bet.eps';
goptions device=eps1200 gsfname=timm gsfmode=replace
   colors=(black) hsize=6in vsize=5in;
proc gplot data=dbet;
   title1 'Beta Q-Q Plot (Set C-Gr1)';
   plot dsq*betaquan /frame vaxis=axis1 haxis=axis3;
   symbol1 v=;
run;
quit;