function boottest;
N=400;
x=2*randn(N,1);  %% generation of data
mu1=mean(x);
se1=std(x)/sqrt(N);

for i=1:10
M(i)=50+(i-1)*50;     %% varying the number of bootstrap data samples
bs1 = bootstrp(M(i),'mean',x);  %% 'mean' is here the estimator
mu2(i)=mean(bs1);   %% mean and standard deviation of the bootstrapped estimator samples
se2(i)=std(bs1);
end

plot(M,mu2)   % plot bootstrap results
h=line([0,max(M)],[mu1,mu1])  % line = direct estimated result
set(h,'Color','b')
hold on

plot(M,se2,'r')   % plot bootstrap results
h=line([0,max(M)],[se1,se1])  % line = direct estimated result
set(h,'Color','r')
hold off
axis([0,max(M),-0.15,0.15])

estimated_mean=mu1; estimated_mean
estimated_std=se1;  estimated_std




