function mm=emclass;
K=3;                        %% number of classes of data
N=100;                      %% number of data
mu=[-1.2,1.5,3.5;0,0,0];    %% centers of data
sig=0.5;                    %% scattering of data around centers
[y,x]=simdaten(mu,sig,N);   %% simulation of data
plot(y(:,1),y(:,2),'*')
xalt=x;

x=fix(K*rand(N,1))+1;  %%%% start with a random classification
mu=[-1,0,1;0,0,0];         %%% and with guesses for the centers
mm=[mu(:,1)',mu(:,2)',mu(:,3)']; %% in mm the iteration results will be collected
for j=1:14  %%  14 iterations turn out to be sufficient
    % determine the probabilities of the x, given y,mu
    % px(i,j)=prob, that data i is of class j 
    for i=1:N
        px(i,:)=probxgiveny(y(i,:),mu,sig);   % the ':' refer not to the same
    end
    % calculation of the updates for the centers, see eqn.(13.92)
    z=y'*px;  nn=sum(px);
    for k=1:K
        mu(:,k)=z(:,k)/nn(k);
    end
    mm=[mm;mu(:,1)',mu(:,2)',mu(:,3)'];  %% collect the iteration results
end
% determine estimates by the maximum of the probabilities
for i=1:N
   xest(i)=find(px(i,:)==max(px(i,:)));
end
xest=xest';

%[xalt,xest]
r=length(find(xalt~=xest))/N*100  % percentage of errors
hold on
plot(mu(1,:),mu(2,:),'ro')  
hold off

function [y,x]=simdaten(mu,sig,N);
K=length(mu);
x=fix(K*rand(N,1))+1;
y=mu(:,x)+sig*randn(2,N);
y=y';

function px=probxgiveny(y,mu,sig);
for j=1:length(mu)
   px(j)=exp(-sum((y'-mu(:,j)).^2)/(2*sig^2));
end
px=px/sum(px);