function fgestprmhmm;
% generation of data
ndata=400; sig=0.1;
[y,x,n,a,mu]=simHMM2(ndata,sig);
aexact=a; muexact=mu;
% estimation for given data
sigma=sig*ones(1,2);   % let sigma be known
%  initial values for a and mu, try different initial values
a=[0.5,0.5;0.5,0.5]; 
mu=[1,1.5];          
for i=1:6            % number of iteration = 6 is enough
[ahut,muhut,stdhut,c,psi2,psi3]=estprmhmmcont(y,a,mu,sigma,ndata,n);
a=ahut; mu=muhut;
ahut    % see, how fast it converges
muhut   % see, how fast it converges
end
muhut
muexact
sigmahut=stdhut; sigmahut
sigma
ahut
aexact

function [ahut,muhut,stdhut,c,psi2,psi3]=estprmhmmcont(y,a,mu,sigma,ndata,n)
% estimation of parameters in a HMM-model with continous observations
p0=ones(1,n);
p0=p0/sum(p0);
for t=1:ndata
    for j=1:n
    bv(t,j) = gauss(y(t),mu(j),sigma(j));
    end
end
[alpha,c]=forward(a,bv,p0);
[beta,d]=backward(a,bv);
for t=1:ndata-1
   for k=1:n
    for l=1:n
    psi3(t,l,k)=beta(t+1,l)*a(l,k)*alpha(t,k)*bv(t+1,l);
    end
   end
   psi3(t,:,:)=psi3(t,:,:)/sum(sum(psi3(t,:,:)));
   for k=1:n
    psi2(t,k)= sum(psi3(t,:,k));
   end
end   
for k=1:n
   for l=1:n
      ahut(l,k)=sum(psi3(:,l,k))/sum(psi2(:,k));
   end
end
for i=1:n
   muhut(i)=sum(psi2(:,i).*y(1:ndata-1))/sum(psi2(:,i));
   varhut(i)=0;
   for t=1:ndata-1
      varhut(i)=varhut(i)+psi2(t,i)*(y(t)-muhut(i))^2;
   end
   varhut(i)=varhut(i)/sum(psi2(:,i));
end
stdhut=sqrt(varhut);

function [alpha,c]=forward(a,bv,p0);
[n1,n2]=size(bv);
n=length(p0);
aa=p0.*bv(1,:);
c(1)=1/sum(aa);
alpha(1,:)=c(1)*aa;
for t=2:n1
   for l=1:n
      aa(t,l)=0;
     for k=1:n
      aa(t,l) = aa(t,l) + alpha(t-1,k)*a(l,k)*bv(t,l);
     end
   end
c(t)=1/sum(aa(t,:));
alpha(t,:)=c(t)*aa(t,:);
end
c=c';

function [beta,d]=backward(a,bv);
[n1,n2]=size(bv);
beta(n1,:)=ones(1,n2);
d=ones(1,n1);
for t=n1:-1:2
bb=beta(t,:)*diag(bv(t,:))*a;
d(t-1)=1/sum(bb);
beta(t-1,:)=d(t-1)*bb;
end
d=d';

function [y,x,n,a,mu]=simHMM2(ndata,sig)
a=[0.9 0.05; 0.1 0.95]; n=2;  mu=[1,2];
s=1; x=s; y=s+sig*randn;
for t=1:ndata
   s=stepMP(n,a,s);      x=[x;s];
   z=mu(s)+sig*randn;    y=[y;z];  
end

function ss=stepMP(n,a,s);
for k=1:n
    p(k)=sum(a(1:k,s));
end
rr=rand;  ss=min(find(rr<p));  

function y=gauss(x,mu,sigma)
xn = (x - mu)/sigma;
y= exp(-0.5 * xn^2)/(sqrt(2*pi)*sigma);
