function fgilltest;
N=10;M=5;
a=[1:M]';   %% true parameters
X=rand(N,M);
[u,s,v]=svd(X);
k=0;
for i=1:min(N,M)
   s(i,i)=s(i,i)/i^k;
end
X=u*s*v';

sig=0.1;
data=X*a+sig*randn(N,1);    %% Definition of data
%% Estimation of a -> aest with std -> aerr
[aest,aerr,Dinv]=estls(data,sig,X);
subplot(2,2,1)
fs=8;
set(gca,'Fontsize',fs)
plot(a,'r*')
%title 'k=0'
xlabel 'x'
ylabel 'exact(*) and estimated'
hold on
errorbar(aest,aerr,'.')
hold off
subplot(2,2,3)
fs=8;
set(gca,'Fontsize',fs)
nn=min(N,M);
ss=diag(s);   
plot(ss)
ylabel 'singular values'
xlabel 'number of sing.values'

%% modification of singular values
%% so that they decrease rapidly
k=4;
for i=1:min(N,M)
   s(i,i)=s(i,i)/i^k;  
end
%% the same as above
X=u*s*v';
sig=0.1;
data=X*a+sig*randn(N,1);
[aest,aerr,Dinv]=estls(data,sig,X);
subplot(2,2,2)
fs=8;
set(gca,'Fontsize',fs)
plot(a,'r*')
xlabel 'x'
%title 'k=4'
ylabel 'exact(*) and estimated'

hold on
errorbar(aest,aerr,'.')
hold off
subplot(2,2,4)
fs=8;
set(gca,'Fontsize',fs)
nn=min(N,M);
ss=diag(s);
plot(ss)
ylabel 'singular values'
xlabel 'number of sing.values'



function [aest,aerr,Dinv]=estls(data,sig,X);
% [a,aerr,Dinv]=estls(data,sig,X);
% Given a set of data with its errors (data,sig)
% and given the linear operator X, so that data=X*a+sig*eta
% the estimate aest for a is determined, the estimation error aerr
% as well as the covariance matrix Dinv of the estimates 
% so that aerr=sqrt(diag(Dinv));
N=length(data);
if length(sig)==1,
   sig=sig*ones(N,1);
end

[N2,M]=size(X);
if N2~=N, break; end
N2=N;
for i=1:N
   K(i,:)=X(i,:)/sig(i);
   b(i)=data(i)/sig(i);
end
aest=pinv(K)*b';  %% K\data
D=K'*K;
Dinv=inv(D);
aerr=sqrt(diag(Dinv));