function xhut=fgkalman;
a=0.9; b=0.1; c=1;  sigr=0.3;  % parameters of a simplest state space model
n=20;   % number of data points
[x,y]=statspace(a,b,c,sigr,n);
xhut=kalman(a,b,c,sigr,y);
f=[1:n];
plot(f,x(1,:),'--')
hold on
h=plot(f,xhut(1,:));
plot(f,y,':r')
title 'broken blue line: Kalman-estimate, dotted red line: naive simple estimate'
hold off

function [x,y]=statspace(A,B,C,sigR,ndata) 
na=size(A);  nx1=na(1);
nb=size(B);  
nc=size(C);  ny1=nc(1); 
nr=size(sigR);
x(:,1)=0.1*ones(nx1,1);
y(:,1)=C*x(:,1)+ sigR*randn(ny1,1);
for t=2:ndata
   x(:,t)=A*x(:,t-1) + B*randn(nb(2),1);
   y(:,t)=C*x(:,t) + sigR*randn(nr(2),1);
end

function [xhut,xvar]=kalman(a,b,c,sigr,y)
nc=size(c); nx=nc(2);
n=length(y);
r=sigr*sigr';
xhut(:,1)=zeros(nx,1); phut=0.05*eye(nx,nx); % initial values
xvar(:,1)=diag(phut);
for t=2:n
   pt=a*phut*a' +  b*b';
   tmp=c*pt*c'+r;
   tmp=inv(tmp);
   K=pt*c'*tmp;
   phut=pt-K*c*pt;
   xhut(:,t)=a*xhut(:,t-1)+K*(y(t)-c*a*xhut(:,t-1));
   xvar(:,t)=diag(phut);
end

