function t=fgmc2arma;
N=500;  % Number of data points
p=2; a=[1,-1.86,0.96]; b=1; % Definition of an AR(2)-Model
%p=3; a=[1,-0.8,-0.25,0.2]; b=1; % Definition of an AR(3)-Model
ee=randn(N,1);
y=filter(b,a,ee);   %% Generation of a realization
mc=500;   %% Number of Monte Carlo steps
t=mcmcarma(y,p,mc);  %% MCMC-Method applied to an AR-process

means=mean(t(fix(0.4*mc):mc,:)); 
means
true_values=-a(2:3); true_values
standard_deviations=std(t(fix(0.4*mc):mc,:));
standard_deviations
plot(t)
for k=1:p
   line([0,mc],[-a(k+1),-a(k+1)]);
end

function t=mcmcarma(y,p,mc);
d=y';
b1=0.1*ones(p,1);  %% initial guesses for the parameters
N=length(y);   
[G,d]=gfun5(p,y);  %% Determination of the matrices containing the data
t=b1';    %% T will collect all estimates
for k=1:mc
   gg=G'*G;
   gd=G'*d;
   for i=1:length(b1)
      ggg=gg;
      ggg(:,i)=[];
      b11=b1; b11(i)=[];
      m=gd(i)-ggg(i,:)*b11;
      m=m/gg(i,i);
      vi=1/sqrt(gg(i,i));
      b1(i)=m+vi*randn;  %% random number with mean m and std=vi,
   end
t=[t;b1'];
end

function  [G,d]=gfun5(p,y);
N=length(y);
G=zeros(N-p,p);
for i=1:N-p
   G(i,:)=y(p+i-1:-1:i)';
end
d=y(p+1:N);


