function [x,x2]=fgsurrogate;
% generate an AR(2) process
N=1024; 
a=[1,-1.8 0.95]; b=1; e=randn(N,1);
x=filter(b,a,e);
x0=x;
% and plot it
subplot(2,2,1)
plot(x)
set(gca,'XLIM',[1,N]);
title 'original series'
ax1=axis;

subplot(2,2,3)
% estimate the periodogram of the AR(2) process
y=fft(x);
per=abs(y)./sqrt(N);
semilogy(per(1:N/2).^2);
set(gca,'XLIM',[1,N/2]);
title 'power spectrum'
ax=axis;

subplot(2,2,2)
% construct random phases subject to the constraints
phi=2*pi*rand(N,1);
phi(1)=0;      %  constraint
phi(N/2+1)=0;  %  constraint
for i=1:N/2-1
phi(N+1-i)=-phi(i+1);  % constraint
end
% Fourier components with the random phases
% with given periodogram:
z=sqrt(N)*per.*exp(-j*phi);  
% corresponding time series by inverse Fourier transform:
x2=ifft(z);  
plot(real(x2)) % x2 is already real, real(x2) only for safety
title 'surrogate series'
axis(ax1)

subplot(2,2,4)
% as test, once more the periodogram derived from the time series
per2=abs(fft(x2))./sqrt(N);
semilogy(per2(1:N/2).^2)
title 'power spectrum'
axis(ax)



