function ptr=fgviterbi
%% simulation of data
ndata=200; sig=0.1;
[y,xex,n,a]=simHMM(ndata,sig);
%% estimation of hidden process
p0=[0.99,0.01]; mu=[1:n];
[x,x2]=viterbi(y,ndata,n,a,mu,sig,p0);
   
subplot(3,2,1)
plot([1:ndata+1],y)
hold on
plot([1:ndata+1],xex,'r')
set(gca,'XLim',[1,ndata+1]);
hh=axis;
title 'Hidden and observed data, sig=0.1'
hold off

subplot(3,2,3)
plot([1:ndata+1],xex,'r')
set(gca,'XLim',[1,ndata+1]);
axis(hh);
hold on
plot(x,'b:')
hold off

subplot(3,2,5)
plot([1:ndata+1],xex,'r')
set(gca,'XLim',[1,ndata+1]);
axis(hh);
hold on
plot(x2,'b:')
xlabel 'time'
hold off

%%% The same as above, but now sig=0.3
ndata=200; sig=0.3;
[y,xex,n,a]=simHMM(ndata,sig);
%% estimation of hidden process
p0=[0.99,0.01]; mu=[1:n];
[x,x2]=viterbi(y,ndata,n,a,mu,sig,p0);
   
subplot(3,2,2)
plot([1:ndata+1],y)
hold on
plot([1:ndata+1],xex,'r')
title 'Hidden and observed data, sig=0.3'
set(gca,'XLim',[1,ndata+1]);
hh=axis;
hold off

subplot(3,2,4)
plot([1:ndata+1],xex,'r')
axis(hh);
hold on
plot(x,'b:')
hold off

subplot(3,2,6)
plot([1:ndata+1],xex,'r')
axis(hh);
hold on
plot(x2,'b:');
xlabel 'time'
hold off


function [x,x2]=viterbi(y,ndata,n,a,mu,sig,p0)
%% x=forward estimation, x2=backward filter
sig2=sig^2;
for alpha=1:n
   llmin(1,alpha)=(y(1)-mu(alpha))^2/(2*sig2)- log(p0(alpha));
   ptr(1,alpha)=1; 
end
xx=min(llmin(1,:));
x(1)=find(xx==llmin(1,:));
for t=2:ndata
   for alpha=1:n
      llhood(alpha,:)=(y(t)-alpha)^2/(2*sig2)-log(a(alpha,:))+llmin(t-1,:);
      llmin(t,alpha)=min(llhood(alpha,:));
      ptr(t,alpha)=find(llmin(t,alpha)==llhood(alpha,:));   
   end
   xx=min(llmin(t,:));
   x(t)=find(xx==llmin(t,:));
end
xx=min(llmin(ndata,:));
x(ndata)=find(xx==llmin(ndata,:));
%% backward filter
x2(ndata)=x(ndata);
for t=ndata:-1:2
  x2(t-1)=ptr(t,x2(t));
end

function [y,x,n,a]=simHMM(ndata,sig)
a=[0.9 0.05; 0.1 0.95]; n=2;
s=1; x=s; y=s+sig*randn;
for t=1:ndata
   s=stepMP(n,a,s);  x=[x,s];
   z=s+sig*randn;    y=[y;z];  
end

function ss=stepMP(n,a,s);
for k=1:n
    p(k)=sum(a(1:k,s));
end
rr=rand;  ss=min(find(rr<p));  