function hmmcasino;
ndata=1000;
[y,x,n,a]=simHMM3(ndata);
%% estimation
%% initial values
aold=a;
x1=0.01; x2=0.01;
a=[1-x1,x2; x1, 1-x2];
%a=[0.8 0.1;0.2,0.9];      %% try different initial values
%a=[0.95 0.02; 0.05 0.98]; %% try different initial values
zz(1,:)=[a(1,2),a(2,1)];
rhoyx=ones(6,2)*1/6;
rhoyx(1:3,2)=[0.17,0.16,0.17]';
rhoyx(6,2)=1-sum(rhoyx(1:5,1));
%%% end initial values
m1=20; %% number of iterations, 
for m=1:m1
   [a,rhoyx,pxi,psi3]=estprmhmm(y,n,a,rhoyx); 
   zz(m+1,:)=[a(1,2),a(2,1)]; 
   [a(1,2),a(2,1)] %% see the slow convergence.
%% in the final stage one should use direct minimization of
%% the likelihood
end
subplot(2,1,1)
plot(zz,':')
line([1,m1+1],[aold(1,2),aold(1,2)])
line([1,m1+1],[aold(2,1),aold(2,1)])
subplot(2,1,2)
plot(x), hold on
plot(1+pxi(:,2),'r:');
axis([0,ndata,0,3]);
hold off
rhoyx
sum(rhoyx)

function [ahut,rhoyxhut,pxi,psi3]=estprmhmm(y,n,a,rhoyx);
%% estimation of parameters in a HMM modell with discrete obseravtions
ndata=length(y);
p0=ones(1,n); p0=p0/sum(p0);
for t=1:ndata
bv(t,:) = rhoyx(y(t),:);
end
[alpha,c]=forward(a,bv,p0);
[beta,d]=backward(a,bv);
pxi=alpha.*beta;
for t=1:ndata
   pxi(t,:)=pxi(t,:)/sum(pxi(t,:));
end
for t=1:ndata-1
   for k=1:n
      for l=1:n
      psi3(t,l,k)=beta(t+1,l)*a(l,k)*alpha(t,k)*bv(t+1,l);
      end
   end
   psi3(t,:,:)=psi3(t,:,:)/sum(sum(psi3(t,:,:)));
   for k=1:n
      psi2(t,k)= sum(psi3(t,:,k));
   end
   psi2(t,:)=psi2(t,:)/sum(psi2(t,:));
end   
for k=1:n
   for l=1:n
      ahut(l,k)=sum(psi3(:,l,k))/sum(psi2(:,k));
   end
end
for i=1:6
   for k=1:n
      rhoyxhut(i,k)=0;
      for t=1:ndata-1
         if y(t)==i,
         rhoyxhut(i,k)=rhoyxhut(i,k) + psi2(t,k);   
         end
      end
   end
end
for k=1:n
rhoyxhut(:,k)=rhoyxhut(:,k)/sum(rhoyxhut(:,k));
end

function [alpha,c]=forward(a,bv,p0);
[n1,n2]=size(bv);
n=length(p0);
aa=p0.*bv(1,:);
c(1)=1/sum(aa);
alpha(1,:)=c(1)*aa;
for t=2:n1
   for l=1:n
      aa(t,l)=0;
     for k=1:n
      aa(t,l) = aa(t,l) + alpha(t-1,k)*a(l,k)*bv(t,l);
     end
   end
c(t)=1/sum(aa(t,:));
alpha(t,:)=c(t)*aa(t,:);
end
c=c';

function [beta,d]=backward(a,bv);
[n1,n2]=size(bv);
beta(n1,:)=ones(1,n2);
d=ones(1,n1);
for t=n1:-1:2
bb=beta(t,:)*diag(bv(t,:))*a;
d(t-1)=1/sum(bb);
beta(t-1,:)=d(t-1)*bb;
end
d=d';

function [y,x,n,a]=simHMM3(ndata)
a=[0.95 0.02; 0.05 0.98]; n=2; 
s=1; x=s; y=fix(6*rand)+1;
for t=1:ndata
   s=stepMP(n,a,s);      x=[x;s];
   z=fix(6*rand)+1;      %s=1: fair die - rhoyx(1:6,1)=1/6;
   if s==2, 
      z=min(fix(10*rand)+1,6);   % unfair die
   end
   %%rhoyx(1:5,2)=1/10; rhoyx(6,2)=1/2;
   y=[y;z];  
end

function ss=stepMP(n,a,s);
for k=1:n
    p(k)=sum(a(1:k,s));
end
rr=rand;  ss=min(find(rr<p));  