function t=mc2onefrequ;
global G
%% generation of data
N=400; x=linspace(1,10,N);
sig=1;
y=sin(10*x)+sig*randn(1,N);
%plot(y), break;   % Plot data first
d=y';
b1=[0.1;0.1];  b2=[9.3;1];   %% Initial values
mc=1000;                    %% number of MC steps
t=[b1',b2'];
%%% parameters like om, which enter nonlinearly, 
%%% are collected in b2. For these the Gibbs sampler
%%% has to be applied
om=b2(1);  G=[cos(om*x'),sin(om*x')]; 
for k=1:mc
   gg=G'*G;
   gd=G'*d;
   for i=1:length(b1)    %%% see also fgmc2arma.m
      ggg=gg;
      ggg(:,i)=[];
      b11=b1; b11(i)=[];
      m(i)=gd(i)-ggg(i,:)*b11;
      m(i)=m(i)/gg(i,i);
      vi=1/sqrt(gg(i,i));
      b1(i)=m(i)+vi*randn;
   end
   for i=1:length(b2)   
      pold=probdens(d,b1,b2);
      bold=b2(i);
      Gold =G;
      b2(i)=bold+badd(i);  %% change b2
      om=b2(1);
      G=[cos(om*x'),sin(om*x')];
      pnew=probdens(d,b1,b2);
      ee=rand;
      if pold > 0
         if pnew/pold < ee, 
            b2(i)=bold; G=Gold;
         end,
      end
    end
t=[t;b1',b2'];
end
plot(t)
line([0,mc],[1,1]);
line([0,mc],[0,0]);
line([0,mc],[1,1]);
line([0,mc],[10,10]);
prm1=[mean(t(mc/2:mc,1)),std(t(mc/2:mc,1))]; prm1
prm2=[mean(t(mc/2:mc,2)),std(t(mc/2:mc,2))]; prm2
omega=[mean(t(mc/2:mc,3)),std(t(mc/2:mc,3))]; omega

function y=badd(i);
switch(i)
case 1
   y=0.1*randn;  %% b2(1)=omega==om
case 2
   y=0*randn;   %% b2(2)=sigma, will be held fixed
end


function p=probdens(d,b1,b2)
global G
nd=size(d);
if nd(1)==1, d=d'; end;
nb=size(b1);
if nb(1)==1, b1=b1'; end;
nb=size(b2);
if nb(1)==1, b2=b2'; end;
N=length(d);
M2=length(b2);
sig=b2(M2);
aa=d-G*b1;
p=(2*pi*sig^2)^(-N/2)*exp(-aa'*aa/(2*sig^2));

  