function sidelobes;
n=1024;        %% number of data points
w0=8*2*pi/n;   %% frequency
t=1:n;
x=sin(w0*t);   
%%  plot time series
subplot(2,2,1)
plot(x)
ylabel 'y(t)'
xlabel 't'
set(gca,'XLIM',[0,n])
set(gca,'YLIM',[-1.2,1.2])
%%  plot power spectrum  
subplot(2,2,3)
y=abs(fft(x,n)).^2/n;
fs=16;
x0=[1:fs]/n*2;
stem(x0,y(1:fs)','b')
xlabel '\omega'
ylabel 'periodogram'

w0=8.5*2*pi/n;  %% different frequency
t=1:n;
x=sin(w0*t);
%%  plot time series
subplot(2,2,2)
plot(x)
ylabel 'y(t)'
xlabel 't'
set(gca,'XLIM',[0,n])
set(gca,'YLIM',[-1.2,1.2])
%%  plot power spectrum  
subplot(2,2,4)
y=abs(fft(x,n)).^2/n;
fs=16;
x0=[1:fs]/n*2;
stem(x0,y(1:fs)','b')
xlabel '\omega'
ylabel 'periodogram'