function results=textclass;
nv=10;   %% # words in the vocabulary
nt1=15;  %% # scripts of sort 1
nt2=12;  %% # scripts of sort 2
lt=60;   % # words per script
v=1:nv;  % vocabulary
pr=rand(nv,2);
%% Generation of scripts
%% scripts of sort 1
pr1=pr(:,1)/sum(pr(:,1));
for i=1:nv
   sumpr1(i)=sum(pr1(1:i));
end
for i=1:nt1
   for j=1:lt
      ii=rand;
      jj=min(find(ii<sumpr1));
      t1(i,j)=jj;
   end
end
%% scripts of sort 2
pr2=pr(:,2)/sum(pr(:,2));
for i=1:nv
   sumpr2(i)=sum(pr2(1:i));
end
for i=1:nt2
   for j=1:lt
      ii=rand;
      jj=min(find(ii<sumpr2));
      t2(i,j)=jj;
   end
end
t=[t1;t2];
%% Estimation of the probability
pp(:,1)=estprobtexte(t1,v);
pp(:,2)=estprobtexte(t2,v);

%%%% Test
results=[];
r=0;   %  initializing the number of errors
nl=100;
for l=1:nl
   %%% Generation of n1 new scripts
    kk=fix(2*rand)+1;
    sumpr=sumpr1;
    if kk==2, sumpr=sumpr2; end;   %% script of class 1 or 2
    for j=1:lt
      ii=rand;
      jj=min(find(ii<sumpr));
      tnew(j)=jj;   % tnew(j) is 'word' jj
    end 
    %%% Classification of tnew
    [class,nn]=estclasstext(tnew,pp,v);
    if class~=kk,r=r+1; [kk,class], end;
    results=[results;kk,class];
    clear aa pr
end
r/nl  %  percentage of errors: r=0 -> no error

function pr=estprobtexte(texte,v);
nv=length(v);
[lt,nt]=size(texte);
for i=1:nt
   for j=1:nv
      nw1(i,j)=length(find(texte(:,i)==v(j)));
   end
end
nn=sum(sum(nw1));
pr=(sum(nw1)+1)/(nn+nv);
pr=pr';

function [class,nn]=estclasstext(text,pr,v)
lt=length(text);
nv=length(v);
nn=0;
for j=1:lt
   k=find(text(j)==v);
   if isempty(k)==0, 
      a1(j,:)=log(pr(k,:));
      else nn=nn+1;
   end
end
aa=sum(a1);
class=find(aa==max(aa));
