function y=threear2;
T=30; tau=200; N=4098; % N= number of data
[x1,zf1]=genAR2(T,tau,N); % generates an AR(2) process, given period and damping

T=10; tau=200; N=4098;
[x2,zf2]=genAR2(T,tau,N);

T=5;  tau=200; N=4098;
[x3,zf3]=genAR2(T,tau,N);

% concatenate the time series
y=[x1;x2;x3];

specgram(y)  % spectogram
colorbar

function [x,zf]=genAR2(T,tau,N)
% generates an AR(2) process, given period and damping
r=exp(-1/tau); om=2*pi/T;
a1=2*cos(om)*r;  a2=-r^2;
a=[1,-a1,-a2]; b=1;
e=randn(N,1);
[x,zf]=filter(b,a,e);