// ----------------------------------------------------------------------------
// (c) Copyright 2005, Springer.  All Rights Reserved. The code in this CD-ROM is
// distributed by Springer with ABSOLUTELY NO SUPPORT and NO WARRANTY from
// Springer. Use or reproduction of the information provided on this code for
// commercial gain is strictly prohibited. Explicit permission is given for the
// reproduction and use of this information in an instructional setting provided
// proper reference is given to the original source.
//
// Authors and Springer shall not be liable for damage in connection with, or
// arising out of, the furnishing, performance or use of the contents of the
// CD-ROM.
// ----------------------------------------------------------------------------

#include "TestBuilder.h"
#include "tbvCell.h"
#include "tbvPkt.h"

class pl3RxGenTvmT;

// ****************************************
// a task pp3RxGen 
// ****************************************

/// This task generates the controls and the data

class pp3RxGenTaskT : public tbvTaskTypeSafeT<tbvCellT> {
  public:
    //parent tvm, make it easy to access in task body
   pl3RxGenTvmT& pp3RGen;
    tbvSmartUnsignedT randBit; // To generate random bits

    //constructor, destructor
    pp3RxGenTaskT ( pl3RxGenTvmT& );
    virtual ~pp3RxGenTaskT();

    //body function for task functionality
    virtual void body ( tbvCellT *arg );
};


// ****************************************
// a TVM pl3RxGen
// ****************************************

/// The main class for implementing the pl3 Rx generator

class pl3RxGenTvmT : public tbvTvmT
{

  public:
    //constructor, destructor
    pl3RxGenTvmT ();
    virtual ~pl3RxGenTvmT();

    //hdl interface signals
tbvSignalHdlT   pp3rfclk;
tbvSignalHdlT   rst_l;
tbvSignalHdlT   pp3renb_n;
tbvSignalHdlT   pp3rsx;
tbvSignalHdlT   pp3rsop;
tbvSignalHdlT   pp3reop;
tbvSignalHdlT   pp3rdat;
tbvSignalHdlT   pp3rmod;
tbvSignalHdlT   pp3rprty;
tbvSignalHdlT   pp3rerr;
tbvSignalHdlT   pp3rval;


    // The pl3If Mutex
    tbvMutexT pp3RxGenMutex;

    // the recording fiber is needed to avoid using the parent task fiber
    tbvFiberT pp3RxGenFiber;

    //basic tasks 
    pp3RxGenTaskT pp3RxGen;

    // Event Expressions
    tbvEventExprT posedge_clk;
    tbvEventExprT pp3renb_n_0;

    unsigned int prtySense;
    void setPrtySense(unsigned int k){prtySense = k;}

    unsigned int badParity;
    void setBadParity(unsigned int k){badParity = k;}

    unsigned int badMode;
    void setBadMode(unsigned int k){badMode = k;}

    unsigned int curr_port;

   // This function is called from $tbv_tvm_connect, to Create a TVM object.
    static void create ( );


};


