// ----------------------------------------------------------------------------
// (c) Copyright 2005, Springer.  All Rights Reserved. The code in this CD-ROM is
// distributed by Springer with ABSOLUTELY NO SUPPORT and NO WARRANTY from
// Springer. Use or reproduction of the information provided on this code for
// commercial gain is strictly prohibited. Explicit permission is given for the
// reproduction and use of this information in an instructional setting provided
// proper reference is given to the original source.
//
// Authors and Springer shall not be liable for damage in connection with, or
// arising out of, the furnishing, performance or use of the contents of the
// CD-ROM.
// ----------------------------------------------------------------------------
//****************************************************************
//
//     File Name :     pl3RxGen.v
//
//****************************************************************

module pl3RxGenTvm(pp3rfclk,
                    rst_l,
                    pp3renb_n,
                    pp3rsx,
                    pp3rsop,
	            pp3reop,
                    pp3rdat,
                    pp3rmod,
                    pp3rprty,
                    pp3rerr,
                    pp3rval);

input               pp3rfclk;
input               rst_l;
input               pp3renb_n;

output              pp3rsx;
output              pp3rsop;
output              pp3reop;
output  [31:0]      pp3rdat;
output  [1:0]       pp3rmod;
output              pp3rprty;
output              pp3rerr;
output              pp3rval;


// These registers are driven from C++
reg           pp3rsx_o;
reg           pp3rsop_o;
reg           pp3reop_o;
reg  [31:0]   pp3rdat_o;
reg  [1:0]    pp3rmod_o;
reg           pp3rprty_o;
reg           pp3rerr_o;
reg           pp3rval_o;
reg           pp3renb_n_r;

always @(posedge pp3rfclk)
  pp3renb_n_r <= #1 pp3renb_n;

  // These assignments create Verilog drivers for the C++ regs
assign pp3rsx = pp3rsx_o;
assign pp3rsop = pp3rsop_o;
assign pp3reop = pp3reop_o;
assign pp3rdat = pp3rdat_o;
assign pp3rmod = pp3rmod_o;
assign pp3rprty = pp3rprty_o;
assign pp3rerr = pp3rerr_o;
assign pp3rval = pp3rval_o;

  //
  //  register every instance of this TVM to test builder
  //
  initial
    $tbv_tvm_connect;


  initial
  begin
    pp3rsx_o = 0;
    pp3rsop_o = 0;
    pp3reop_o = 0;
    pp3rdat_o = 0;
    pp3rmod_o = 0;
    pp3rprty_o = 0;
    pp3rerr_o = 0;
    pp3rval_o = 0;
  end


endmodule



