// ----------------------------------------------------------------------------
// (c) Copyright 2005, Springer.  All Rights Reserved. The code in this CD-ROM is
// distributed by Springer with ABSOLUTELY NO SUPPORT and NO WARRANTY from
// Springer. Use or reproduction of the information provided on this code for
// commercial gain is strictly prohibited. Explicit permission is given for the
// reproduction and use of this information in an instructional setting provided
// proper reference is given to the original source.
//
// Authors and Springer shall not be liable for damage in connection with, or
// arising out of, the furnishing, performance or use of the contents of the
// CD-ROM.
// ----------------------------------------------------------------------------

#include "spi4IfMon.h"
#include "TestBuilder.h"


// *****************************************************************
//                         spi4CtlDatMon Task
// *****************************************************************

//
// Tvm spi4IfMonTvm Task spi4CtlDatMon Constructor & Destructor
//
spi4CtlDatMonTaskT::spi4CtlDatMonTaskT ( spi4IfMonTvmT & spi4IfMonTvm ) :
    tbvMonitorTaskT  (&spi4IfMonTvm, spi4IfMonTvm.dclk, spi4IfMonTvm.reset, "spi4CtlDatMon" ),

    // TVM reference
    spi4IfMonTvm ( spi4IfMonTvm )
{
  // Disable the mutex built into the fiber and turn off automatic
  // transaction recording
  setSynchronization(FALSE, FALSE);
  if (strncmp(spi4IfMonTvm.getInstanceNameP(),"spi4MonIn",9) == 0)  {
    setUserExceptionTypeString("SPI_IN PARITY ERROR");
    setUserExceptionTypeString("SPI_IN PACKET ERROR");
    setUserExceptionTypeString("SPI_IN NONZERO BYTE");
  }
  else {
    setUserExceptionTypeString("SPI_OUT PARITY ERROR");
    setUserExceptionTypeString("SPI_OUT PACKET ERROR");
    setUserExceptionTypeString("SPI_OUT NONZERO BYTE");
  }
}

tbvDataComT * spi4CtlDatMonTaskT::allocate(){
return new tbvCellT(64, NULL, "spi4");
};

spi4CtlDatMonTaskT::~spi4CtlDatMonTaskT () {}

//
// Tvm spi4IfMonTvm Task spi4CtlDatMon body method
//
void spi4CtlDatMonTaskT::monitorBody ( tbvCellT *spi4MonArgP )
{

  //
  // Do one transaction at a time
  //

  spi4IfMonTvm.spi4MonSem.wait();
  spi4IfMonTvm.spi4CtlDatMonMutex.lock();



  unsigned int temp;
  temp = (spi4IfMonTvm.dat.getValue());

  unsigned int temp_type;
  unsigned int temp_sop;
  unsigned int temp_addr;


  temp = (spi4IfMonTvm.dat.getValue());

  if (spi4IfMonTvm.ctl == 0)
    temp = spi4IfMonTvm.temp_cntr0;
  else
   {
    while (tbv4StateNotEqual(spi4IfMonTvm.ctl, 0))
      {
         temp = (spi4IfMonTvm.dat.getValue());
         tbvWaitCycle(spi4IfMonTvm.dclk, tbvThreadT::ANYEDGE);
      }
   }


  temp_type = (temp & 0x8000) ? 1 : 0;
  temp_sop  = (temp & 0x1000) ? 1 : 0;
  temp_addr  = ((temp & 0xff0) >> 4);

  if (temp_type)
  {

  // Get the fiber to record the transaction on
  tbvFiberT &fiber = spi4IfMonTvm.spi4CtlDatMonFiber;

  // Start transaction recording
  fiber.beginTransactionH("spi4CtlDatMon");


  spi4MonArgP->setValid(temp_type);   // set bit 15
  spi4MonArgP->setSOP(temp_sop);   // set bit 12
  spi4MonArgP->setInputPort(temp_addr);   // set bits 11-4
  spi4MonArgP->setOutputPort(temp_addr); 
  tbvListT<CONTROL_FIELD_TYPE>   test_fields;
  test_fields.pushBack(INPUT_PORT);
  test_fields.pushBack(OUTPUT_PORT);
  test_fields.pushBack(VALID);
  test_fields.pushBack(SOP);
  test_fields.pushBack(EOP);
  spi4MonArgP->setValidFields(test_fields);

  spi4IfMonTvm.celldata.resize(0);
  spi4IfMonTvm.mon_data.resize(0);

  while (tbv4StateNotEqual(spi4IfMonTvm.ctl, 1))
    {
      spi4IfMonTvm.celldata.push_back( (spi4IfMonTvm.dat(15,8).getValue()) );
      spi4IfMonTvm.celldata.push_back( (spi4IfMonTvm.dat(7,0).getValue()) );

      spi4IfMonTvm.mon_data.push_back( (spi4IfMonTvm.dat.getValue()) );

      tbvWaitCycle(spi4IfMonTvm.dclk, tbvThreadT::ANYEDGE);
    }

  spi4IfMonTvm.spi4CtlMon.run(spi4MonArgP);

  if (spi4MonArgP->getValid()) {
    tbvOut << dec << "@ " << tbvGetInt64Time(TBV_NS) << " " << spi4IfMonTvm.getInstanceNameP() << *spi4MonArgP << endl;
    tbvOut << dec << "@ " << setw(5) << tbvGetInt64Time(TBV_NS);
    if (strncmp(spi4IfMonTvm.getInstanceNameP(),"spi4MonIn",9) == 0)  {
      tbvOut << "   SPI->In" ;  
      tbvOut << dec << "   I/p Port " << setw(2) << spi4MonArgP->getInputPort();
    }
    else {
      tbvOut << "   SPI->Out" ;  
      tbvOut << dec << "   O/p Port " << setw(2) << spi4MonArgP->getOutputPort();
    }
    tbvOut << dec << "   SOP " << spi4MonArgP->getSOP();
    tbvOut << dec << "   EOP " << spi4MonArgP->getEOP();
    tbvOut << endl;
    tbvOut << dec << "       ";
    tbvOut << dec << "   Size " << spi4MonArgP->getPayloadSize();
    tbvOut << endl << endl;
    
  } 

  // Record the values in the argument block
  fiber.recordAttribute(*spi4MonArgP, "spi4CtlDatMon");

  // Finish Transaction Recording
  fiber.endTransaction();
  }
  else
  {
    if (spi4IfMonTvm.ctl != 1)
       spi4IfMonTvm.ctl_1.wait();
  }


  // release the semaphore
  spi4IfMonTvm.spi4CtlDatMonMutex.unlock();
  spi4IfMonTvm.spi4MonSem.post();

}

// *****************************************************************
//                         spi4CtlMon Task
// *****************************************************************

//
// Tvm spi4IfMonTvm Task spi4CtlMon Constructor & Destructor
//
spi4CtlMonTaskT::spi4CtlMonTaskT ( spi4IfMonTvmT & spi4IfMonTvm ) :
    tbvMonitorTaskT  (&spi4IfMonTvm, spi4IfMonTvm.dclk, spi4IfMonTvm.reset, "spi4CtlMon" ),

    // TVM reference
    spi4IfMonTvm ( spi4IfMonTvm )
{
  // Disable the mutex built into the fiber and turn off automatic
  // transaction recording
  setSynchronization(FALSE, FALSE);
  setUserExceptionTypeString("SPI_IN PARITY ERROR");
}

tbvDataComT * spi4CtlMonTaskT::allocate(){
return new tbvCellT(64, NULL, "spi4");
};

spi4CtlMonTaskT::~spi4CtlMonTaskT () {}

//
// Tvm spi4IfMonTvm Task spi4CtlMon body method
//
void spi4CtlMonTaskT::body ( tbvCellT *spi4MonArgP )
{

  //
  // Do one transaction at a time
  //

  spi4IfMonTvm.spi4CtlMonMutex.lock();

  // Get the fiber to record the transaction on
  tbvFiberT &fiber = spi4IfMonTvm.spi4CtlMonFiber;

  // Start transaction recording
  fiber.beginTransactionH("spi4CtlMon");

  switch (spi4IfMonTvm.dat(14,13).getValue()) {
  case 0:
    spi4MonArgP->setEOP(0);
    break;
  case 1:
    spi4MonArgP->setBad(1);
    if (strncmp(spi4IfMonTvm.getInstanceNameP(),"spi4MonIn",9) == 0)  {
      reportUserException("SPI_IN PACKET ERROR",
			  tbvExceptionT::ERROR,
			  "EOP Abort set");
    }
    else {
      reportUserException("SPI_OUT PACKET ERROR",
			  tbvExceptionT::ERROR,
			  "EOP Abort set");    
    }
    spi4MonArgP->setEOP(1);
    break;
  case 3:
    if (spi4IfMonTvm.celldata.back()) {
      if (strncmp(spi4IfMonTvm.getInstanceNameP(),"spi4MonIn",9) == 0)  {
	reportUserException("SPI_IN NONZERO BYTE",
			    tbvExceptionT::ERROR,
			    "Unused last byte is nonzero");
      }
      else {
	reportUserException("SPI_OUT NONZERO BYTE",
			    tbvExceptionT::ERROR,
			    "Unused last byte is nonzero");
      }      
    }
    spi4IfMonTvm.celldata.pop_back();
    spi4MonArgP->setEOP(1);    
    break;
  default:
    spi4MonArgP->setEOP(1);    
  }
  spi4MonArgP->setPayload(spi4IfMonTvm.celldata);

  spi4IfMonTvm.mon_data.push_back( (spi4IfMonTvm.dat.getValue()) );

  spi4IfMonTvm.temp_cntr0 = (spi4IfMonTvm.dat.getValue());
  tbvWaitCycle(spi4IfMonTvm.dclk, tbvThreadT::ANYEDGE);

  unsigned int lines;
  unsigned int jj;
  unsigned int t;
  unsigned int dip4, dip16, dip16_1, dip16_2, dip16_3;
  unsigned int abcd;
  unsigned int data_cntr;

  lines = 0;
  dip4 = 0;
  dip16 = 0;

  lines = spi4IfMonTvm.mon_data.size();
  if (lines != 0){

  abcd = spi4IfMonTvm.mon_data[lines-1] & 0xf;
  spi4IfMonTvm.mon_data[lines-1] = spi4IfMonTvm.mon_data[lines-1] | 0xf;
  data_cntr = spi4IfMonTvm.mon_data[lines-1] | 0xf;


  for (unsigned int k = 0; k < 16; k++)
    {
      jj = k;
      t = 0;
      for (unsigned int m = 0; m < (lines - 1); m++)
        {
          t = t ^ ((spi4IfMonTvm.mon_data[m] & (0x8000 >> (jj % 16))) ? 1 : 0);
          jj = jj + 1;
        }

      // dip16 = dip16 + ((t ^ ((data_cntr & (0x8000 >> (jj % 16))) ? 1 : 0)) << (jj%16));
      //dip16 = dip16 + ((((t != 0) ? 0x8000 : 0)) >> ((k + lines - 1)%16));

      dip16_1 = (((t != 0) ? 0x8000 : 0) >> ((jj)%16));
      dip16_2 = (0x8000 >> ((jj)%16)) & data_cntr;
      dip16_3 = dip16_1 ^ dip16_2;

      dip16 = dip16 | dip16_3;

    }



  dip4 = ((((dip16 & (0x8000 >> 0)) ? 1 : 0) ^ ((dip16 & (0x8000 >> 4)) ? 1 : 0) ^ ((dip16 & (0x8000 >> 8)) ? 1 : 0) ^ ((dip16 & (0x8000 >> 12)) ? 1 : 0)) << 3) + ((((dip16 & (0x8000 >> 1)) ? 1 : 0) ^ ((dip16 & (0x8000 >> 5)) ? 1 : 0) ^ ((dip16 & (0x8000 >> 9)) ? 1 : 0) ^ ((dip16 & (0x8000 >> 13)) ? 1 : 0)) << 2) + ((((dip16 & (0x8000 >> 2)) ? 1 : 0) ^ ((dip16 & (0x8000 >>  6)) ? 1 : 0) ^ ((dip16 & (0x8000 >> 10)) ? 1 : 0) ^ ((dip16 & (0x8000 >> 14)) ? 1 : 0)) << 1) + (((dip16 & (0x8000 >> 3)) ? 1 : 0) ^ ((dip16 & (0x8000 >>  7)) ? 1 : 0) ^ ((dip16 & (0x8000 >> 11)) ? 1 : 0) ^ ((dip16 & (0x8000 >> 15)) ? 1 : 0));

if (spi4MonArgP->getValid())
if (dip4 != abcd) 
{
  tbvOut << "@: " << tbvGetInt64Time(TBV_NS) << endl;
  tbvOut << "Parity ERROR on: " << *spi4MonArgP << endl;
  spi4MonArgP->setBad(1);
  if (strncmp(spi4IfMonTvm.getInstanceNameP(),"spi4MonIn",9) == 0)  {
    reportUserException("SPI_IN PARITY ERROR",
			tbvExceptionT::ERROR,
			"Parity error in the burst");
  }
  else {
    reportUserException("SPI_OUT PARITY ERROR",
			tbvExceptionT::ERROR,
			"Parity error in the burst");    
  }
}
}

  // Record the values in the argument block
  fiber.recordAttribute(*spi4MonArgP, "spi4CtlMon");

  // Finish Transaction Recording
  fiber.endTransaction();

  // release the semaphore
  spi4IfMonTvm.spi4CtlMonMutex.unlock();

}


// ****************************************
// a task spi4StatMon
// ****************************************
spi4StatMonTaskT::spi4StatMonTaskT(spi4IfMonTvmT& spi4IfMonTvm)
  : tbvTaskTypeSafeT<tbvCellT>(&spi4IfMonTvm, "spi4StatMonTask"),
    spi4IfMonTvm(spi4IfMonTvm)

{
  // Disable the mutex built into the fiber and turn off automatic
  // transaction recording
  setSynchronization(FALSE, FALSE);
 }


spi4StatMonTaskT::~spi4StatMonTaskT() {}

  //
  // TVM spi4IfMonTvm : body method for task spi4StatMon
  //

void spi4StatMonTaskT::body(tbvCellT *spi4MonArgP)
{

  //
  // Do one transaction at a time
  //

  spi4IfMonTvm.spi4StatMonMutex.lock();

  // Start transaction recording
//      spi4IfMonTvm.spi4IfMonFiber.beginTransactionH("spi4IfMonFiber");

  vector <uint8> status(257);
  int statusRead = 0;


  if (spi4IfMonTvm.stat == 3)
     spi4IfMonTvm.stat_3.wait();
     
  for (unsigned int k = 0; k < spi4IfMonTvm.cal_m; k++)
    for (unsigned int i = 0; i < spi4IfMonTvm.cal_len; i++)
      {
        status[statusRead] = ((unsigned char) (spi4IfMonTvm.stat.getValue()))%3;
        statusRead++;
        tbvWaitCycle(spi4IfMonTvm.sclk, tbvThreadT::POSEDGE);
      }
  status[statusRead] = ((unsigned char) (spi4IfMonTvm.stat.getValue()))%3;

  tbvWaitCycle(spi4IfMonTvm.sclk, tbvThreadT::POSEDGE);

  status.resize(statusRead);

  spi4MonArgP->setPayload(status);


  // Record the values in the argument block onto the fiber
//      spi4IfMonTvm.spi4IfMonFiber.recordAttribute(*spi4MonArgP, "spi4IfMonFiber");

  // Finish Transaction Recording
//      spi4IfMonTvm.spi4IfMonFiber.endTransaction();


  spi4IfMonTvm.spi4StatMonMutex.unlock();

}


// *****************************************************************
//                      spi4IfMonTvm TVM
// *****************************************************************

//
// TVM spi4IfMonTvm Constructor & Destructor
//
spi4IfMonTvmT::spi4IfMonTvmT ( ) :
  tbvTvmT (),
  celldata(1,0),
  mon_data(1,0),
  temp_cntr0(0),

  // Initialize the TVM Signals
        dclk (getFullInterfaceHdlNameP("dclk") ),
        sclk (getFullInterfaceHdlNameP("sclk") ),
        reset (getFullInterfaceHdlNameP("reset") ),
        dat (getFullInterfaceHdlNameP("dat") ),
        ctl (getFullInterfaceHdlNameP("ctl") ),
        stat (getFullInterfaceHdlNameP("stat") ),


  // Initialize the Mutex
 
  spi4MonSem( "spi4MonSem",2 ),
  spi4CtlDatMonMutex( "spi4CtlDatMonMutex" ),
  spi4CtlMonMutex( "spi4CtlMonMutex" ),
  spi4StatMonMutex( "spi4StatMonMutex" ),

  spi4CtlDatMonFiber( this, "spi4CtlDatMonFiber"),
  spi4CtlMonFiber( this, "spi4CtlMonFiber"),

  // Create the task objects
  spi4CtlDatMon(* this),
  spi4CtlMon(* this),
  spi4StatMon(* this),

  // Create the Event Expressions

  posedge_sclk ( sclk, tbvThreadT::POSEDGE ),
  anyedge_dclk ( dclk, tbvThreadT::ANYEDGE ),
  ctl_1(anyedge_dclk, ctl()),
  stat_3(posedge_sclk, stat()),

  cal_len(20),
  cal_m(5)

{
 //add any construtor code needed for tvm spi4IfMonTvm
 spi4CtlDatMonFiber.setRecording(TRUE);
 spi4CtlMonFiber.setRecording(TRUE);
}

//destructor for tvm spi4IfMonTvm
spi4IfMonTvmT::~spi4IfMonTvmT()
{
  //add any clean up code needed for tvm spi4IfMonTvm

}

//
// Method called from $tbv_tvm_connect, to create the TVM object.
//
void spi4IfMonTvmT::create ( )
{
  new spi4IfMonTvmT ( );
};




