// ----------------------------------------------------------------------------
// (c) Copyright 2005, Springer.  All Rights Reserved. The code in this CD-ROM is
// distributed by Springer with ABSOLUTELY NO SUPPORT and NO WARRANTY from
// Springer. Use or reproduction of the information provided on this code for
// commercial gain is strictly prohibited. Explicit permission is given for the
// reproduction and use of this information in an instructional setting provided
// proper reference is given to the original source.
//
// Authors and Springer shall not be liable for damage in connection with, or
// arising out of, the furnishing, performance or use of the contents of the
// CD-ROM.
// ----------------------------------------------------------------------------

#ifndef TBV_ATMCELL_H 
#define TBV_ATMCELL_H

#include "tbvCell.h"
#include "crcFunctions.h"


class tbvATMCellT : public tbvCellT {
public:
  
    //
    // constructors
    //
    tbvATMCellT(bool nni = true, 
                const tbvControlDataT * controlP = NULL, 
                const char * nameP = NULL);  
    tbvATMCellT(const char* header, 
                const char* payload,  
                bool nni = true,
                const tbvControlDataT * controlP = NULL, 
                const char * nameP = NULL);
    tbvATMCellT(const vector<uint8> & header,
                const vector<uint8> & payload,
                bool nni = true, 
                const tbvControlDataT * controlP = NULL, 
                const char * nameP = NULL);

    //copy constructor
    tbvATMCellT(const tbvATMCellT & rhs, 
                const char * nameP = NULL);
    //copy constructor
    tbvATMCellT(const tbvCellT & rhs, 
                const char * nameP = NULL);
  
    //destructor
    virtual ~tbvATMCellT();

    //field constructor
    tbvATMCellT(const tbvSmartDataT * parentP, 
                const char * nameP = NULL,
                bool derived = false);

    //assign operator
    tbvATMCellT & operator=(const tbvATMCellT & rhs);

    //duplicate functions
    virtual tbvATMCellT * duplicate(const char* nameP = NULL) const;
    virtual tbvATMCellT * duplicate(const tbvSmartDataT * parentP,
                                    const char* nameP = NULL,
                                    bool derived = false ) const;


private:
    tbvSmartUnsignedT _gfc, _vpi, _vci, _pti,_hec,_atm_header_clp;
    bool _nni; // Boolean
    bool _ishec; //Flag to set PayloadSize 
    void setup();
    void wrapup();
    

public:

    //access function for the header fields
    virtual void                        setGFC(const unsigned int);
    virtual const tbvSmartUnsignedT&    getGFC() const;
    virtual void                        setVPI(const unsigned int);
    virtual tbvSmartUnsignedT&           getVPI();
    virtual void                        setVCI(const unsigned int);
    virtual tbvSmartUnsignedT&           getVCI();
    virtual void                        setPTI(const unsigned int);
    virtual tbvSmartUnsignedT&    getPTI();
    virtual const bool                  getNNI() const;
    virtual DATACOM_TYPE                          getType();
    unsigned long long                        getKey() const;
    void				setPTIUseControlData();
    void 				setHec();
    bool				isHec() const;
    virtual vector<uint8> getHeader() const ;
    virtual vector<uint8> getPayload() const;// Use payloadSize

    void createHeader(const vector<uint8> &);
    void createPayload(const vector<uint8> &); 
    void setHeader(const vector<uint8> &);
    void setHeader(const char *);
    void setPayload(const vector<uint8> &);
    void setPayload(const char *, int);
    virtual void randomHeader();
    void  setATMHeaderCLP(const unsigned int clp);
    const unsigned int  getATMHeaderCLP() const;
    void setATMHeaderOAM(const unsigned int oam);
    const unsigned int  getATMHeaderOAM() const;
    void setATMHeaderEFCI(const unsigned int efci);
    const unsigned int  getATMHeaderEFCI() const; 
    void  setPTIEOP(const unsigned int eop);
    unsigned short getPTIEOP() ; 

};




class tbvAAL1CellT : public tbvCellT {
public:

    //
    // constructors
    //
    tbvAAL1CellT(
        bool csi = false, 
        const tbvControlDataT * controlP = NULL, 
        const char * nameP = NULL);
    tbvAAL1CellT(
        const char* header, 
        const char* payload,
        bool csi = false,  
        const tbvControlDataT * controlP = NULL, 
        const char * nameP = NULL);
    tbvAAL1CellT(
        const vector<uint8> & header,
        const vector<uint8> & payload, 
        bool csi = false,
        const tbvControlDataT * controlP = NULL, 
        const char * nameP = NULL);

    //copy constructor
    tbvAAL1CellT(
        const tbvAAL1CellT & rhs, 
        const char * nameP = NULL);
  
    //destructor
    virtual ~tbvAAL1CellT();

    //field constructor
    tbvAAL1CellT(
        const tbvSmartDataT * parentP, 
        const char * nameP = NULL,
        bool derived = false);

    //assign operator
    tbvAAL1CellT & operator=(const tbvAAL1CellT & rhs);

    //duplicate functions
    virtual tbvAAL1CellT * duplicate(const char* nameP = NULL) const;
    virtual tbvAAL1CellT * duplicate(
        const tbvSmartDataT * parentP,
        const char* nameP = NULL,
        bool derived = false ) const;

private:

    void                setup();
    void                wrapup();  
    tbvSmartUnsignedT   _pointer;
    bool _csi;
    crc10<unsigned int,unsigned int> crc;

 
public:

    //access functions for the header fields
    virtual void                        setNextMsgPointer(const unsigned int);
    virtual const tbvSmartUnsignedT&            getNextMsgPointer() const;
    // for record purpose not for randomization

    virtual const bool getCSI() const; 
    virtual vector<uint8> getHeader() const;
    virtual vector<uint8> getPayload() const;// Use payloadSize
    void createHeader(const vector<uint8> &);
    void createPayload(const vector<uint8> &);
    void setHeader(const vector<uint8> &);
    void setHeader(const char *);

};
#endif // class tbvATMCellT

