// ----------------------------------------------------------------------------
// (c) Copyright 2005, Springer.  All Rights Reserved. The code in this CD-ROM is
// distributed by Springer with ABSOLUTELY NO SUPPORT and NO WARRANTY from
// Springer. Use or reproduction of the information provided on this code for
// commercial gain is strictly prohibited. Explicit permission is given for the
// reproduction and use of this information in an instructional setting provided
// proper reference is given to the original source.
//
// Authors and Springer shall not be liable for damage in connection with, or
// arising out of, the furnishing, performance or use of the contents of the
// CD-ROM.
// ----------------------------------------------------------------------------

#ifndef TBV_ATOMCONTROLWORD_H 
#define TBV_ATOMCONTROLWORD_H

#include "TestBuilder.h"
#include "tbvDataCom.h"


class tbvATOMControlWordT : public tbvSmartRecordT {
public:
  //
  // constructors
  //
  tbvATOMControlWordT(const char * nameP = NULL);
  tbvATOMControlWordT(const vector<uint8> controlWord, const char * nameP = NULL);

  //copy constructor
  tbvATOMControlWordT(const tbvATOMControlWordT & rhs, 
 	           const char* nameP = NULL);

  //destructor
  ~tbvATOMControlWordT();

  //assignment operator
  tbvATOMControlWordT & operator=(const tbvATOMControlWordT & rhs);

  //duplicate function
  tbvATOMControlWordT * duplicate(const char* nameP = NULL) const;

public:
  void 			setTransportType(unsigned int T);
  void			setEFCI(unsigned int E);
  void			setCLP(unsigned int C);
  void			setCommandResponse(unsigned int U);
  void			setLength(unsigned int L);
  void			setSequenceNumber(unsigned int SN);

  void			setControlWord(vector<uint8>);

  const unsigned int		getTranportType() const;
  const unsigned int 		getEFCI() const;
  const unsigned int		getCLP() const;
  const unsigned int		getCommandResponse() const;
  const unsigned int            getLength() const;
  const unsigned int            getSequenceNumber() const;
  const vector<uint8>			getControlWord() const;

protected:
  

private:

  void 			setup();
  void			wrapup();

  vector<uint8>         controlWord;
};  

#endif // class tbvATOMControlWordT
