// ----------------------------------------------------------------------------
// (c) Copyright 2005, Springer.  All Rights Reserved. The code in this CD-ROM is
// distributed by Springer with ABSOLUTELY NO SUPPORT and NO WARRANTY from
// Springer. Use or reproduction of the information provided on this code for
// commercial gain is strictly prohibited. Explicit permission is given for the
// reproduction and use of this information in an instructional setting provided
// proper reference is given to the original source.
//
// Authors and Springer shall not be liable for damage in connection with, or
// arising out of, the furnishing, performance or use of the contents of the
// CD-ROM.
// ----------------------------------------------------------------------------

#include "tbvDataCom.h"

void rcs_tbvDataCom_cc() { tbvOut << "$Id:$" << endl; }

/**************************************************************************/
tbvDataComT::tbvDataComT( const char * nameP = NULL) :
	       tbvSmartRecordT(nameP),
	       _payloadsize(this,"payload size",true),
	       _control(this,"control data", true) 
{
  setup();
  randomPayload(_payloadsize);
} 


/**************************************************************************/
tbvDataComT::tbvDataComT(const tbvDataComT & rhs, 
			 const char * nameP = NULL) :
	       tbvSmartRecordT(nameP),
//	       tbvSmartRecordT(RECORD, nameP, &rhs),
	       _payloadsize(this,"payload size",true),
	       _control(this,"control data", true) 
{ 
  operator=(rhs);
} 


/**************************************************************************/
tbvDataComT::tbvDataComT(int size, const tbvControlDataT * controlP = NULL, 
			 const char * nameP = NULL) :
	       tbvSmartRecordT(nameP),
	       _payloadsize(this,"payload size",true),
	       _control(this,"control data", true)
{ 
  setup();

  if (controlP != NULL) _control = *controlP;
  if (size > (_htsize + _trailerSize))
  { 
    _payloadsize = size - (_htsize + _trailerSize);
    randomPayload(_payloadsize);
  } 
}

/**************************************************************************/
tbvDataComT::tbvDataComT(const char * payload, int sz,
			 const tbvControlDataT * controlP = NULL, 
			 const char * nameP = NULL) :
	       tbvSmartRecordT(nameP),
	       _payloadsize(this,"payload size",true),
	       _control(this,"control data", true)
{ 
  setup();
 
  if (controlP != NULL) _control = *controlP;
  setPayload(payload, sz);
}


/**************************************************************************/
tbvDataComT::tbvDataComT(const vector<uint8> & payload, 
			 const tbvControlDataT * controlP = NULL, 
			 const char * nameP = NULL) :
	       tbvSmartRecordT(nameP),
	       _payloadsize(this,"payload size",true),
	       _control(this,"control data", true)
{ 
  setup();
  
  if (controlP != NULL) _control = *controlP;
  setPayload(payload);
}


/**************************************************************************/
tbvDataComT::tbvDataComT(const tbvSmartDataT * parentP,  
			 const char * nameP = NULL,
			 bool derived = false) :
	       tbvSmartRecordT(parentP, nameP, derived),
	       _payloadsize(this,"payload size",true),
	       _control(this,"control data", true)
{ 
  setup();
  randomPayload(_payloadsize);
}


/**************************************************************************/
tbvDataComT & tbvDataComT::operator=(const tbvDataComT & rhs)
{
  tbvSmartRecordT::operator=(rhs);
  _control.transactionHandle = rhs._control.transactionHandle;
  setPayload(rhs.getPayload());
  _htsize  = rhs.getHeaderSize();
  _trailerSize = rhs.getTrailerSize();
  _isPkt = rhs.isPkt();
  _isCell = rhs.isCell();
  return *this;
}


/**************************************************************************/
tbvDataComT * tbvDataComT::duplicate(const char * nameP = NULL) const
{
  return new tbvDataComT(*this, nameP);
}


/**************************************************************************/
tbvDataComT * tbvDataComT::duplicate(const tbvSmartDataT * parentP,
				     const char * nameP = NULL,
				     bool derived = false ) const
{
  tbvDataComT * a = new tbvDataComT(parentP, nameP, derived);
  *a = *this;
  return a;
}


/**************************************************************************/
tbvDataComT::~tbvDataComT() { wrapup(); }


/**************************************************************************/
void tbvDataComT::setup() { 

  _payloadsize.keepOnly(0,MAX_PAYLOAD_SIZE);
 
  _isPkt = false;
  _isCell = false; 
  _htsize = 0;
  _trailerSize = 0;
  
}


/**************************************************************************/
void tbvDataComT::wrapup() { } 


/**************************************************************************/
int tbvDataComT::getSize() const 
{ 
  //return (_htsize+_payloadsize+_trailerSize);
  return (getData()).size();
}

/**************************************************************************/
int tbvDataComT::getPayloadSize() const 
{ 
  return _payloadsize;
} 

/**************************************************************************/
void tbvDataComT::setHeaderSize(const unsigned int htsize)  
{
  if (htsize >= 0) {
    _htsize = htsize;
  }
} 
/**************************************************************************/
unsigned int tbvDataComT::getHeaderSize() const
{
    return _htsize;
}
/**************************************************************************/
void tbvDataComT::setTrailerSize(const unsigned int trailerSize){
  if(trailerSize >= 0){
    _trailerSize = trailerSize;
  }
}
/**************************************************************************/
int tbvDataComT::getTrailerSize() const{
  return _trailerSize;
}


/**************************************************************************/
vector<uint8>   tbvDataComT::getHeader() const
{
  vector<uint8>  header =  vector<uint8>();
  return header;
} 

/**************************************************************************/
vector<uint8>   tbvDataComT::getTrailer() const
{ 
  vector<uint8>  trailerP =  vector<uint8>();
  return trailerP;
} 


/**************************************************************************/
vector<uint8>   tbvDataComT::getPayload() const 
{ 
  vector<uint8>  payloadP =  vector<uint8>(_payload);

#ifdef DATACOM_DEBUG
  for (unsigned int i = 0; i < payloadP->size(); i++)
  {
    tbvOut << "in getPayload  payload[" << dec <<i<<"] = " << hex <<(uint64)(*payloadP)[i] << endl;
  }
#endif

  return payloadP;
} 


/**************************************************************************/
vector<uint8>   tbvDataComT::getData() const
{ 
  vector<uint8>  dataP = vector<uint8>();
  
  vector<uint8>  vtmp = getHeader();
  dataP.insert(dataP.end(), vtmp.begin(), vtmp.end());
#ifdef DATACOM_DEBUG
  for (unsigned int i = 0; i < dataP.size(); i++)
    {
      tbvOut<<"in getData after getHeader data[" << dec << i <<"] = "<<hex<<(uint64)dataP[i]<<endl;
    }
#endif
  vtmp = getPayload();
  
#ifdef DATACOM_DEBUG
  for (unsigned int i = 0; i < dataP.size(); i++)
    {
      tbvOut<<"in getData after getPayload data[" << dec << i <<"] = "<<hex<<(uint64)dataP[i]<<endl;
    }
#endif
  dataP.insert(dataP.end(), vtmp.begin(), vtmp.end());

  //Insert Pad
  unsigned int pad = _payloadsize;
  unsigned int plsize = vtmp.size();
  if (pad > plsize) dataP.insert(dataP.end(), pad - plsize, 0);
  vtmp = getTrailer();
  
#ifdef DATACOM_DEBUG
  for (unsigned int i = 0; i < vtmp.size(); i++)
    {
      tbvOut<<"in getData after getTrailer data[" << dec << i <<"] = "<<hex<<(uint64)vtmp[i]<<endl;
    }
#endif
  
  dataP.insert(dataP.end(), vtmp.begin(), vtmp.end());
  
#ifdef DATACOM_DEBUG
  for (unsigned int i = 0; i < dataP.size(); i++)
    {
      tbvOut<<"in getData data[" << dec << i <<"] = "<<hex<<(uint64)(dataP)[i]<<endl;
    }
#endif
  
  
  return dataP;
}


/**************************************************************************/
void tbvDataComT::setPayload(const char * payload, int sz)
{ 
  _payloadsize = sz;
  _payload.erase(_payload.begin(), _payload.end());
  for (unsigned int i = 0; i < _payloadsize; i++)
  {
    _payload.push_back((uint8) *payload);
    payload++;
  }
}


/**************************************************************************/
void tbvDataComT::setPayload(const vector<uint8> & payload)
{ 
  _payloadsize = payload.size();
  _payload = payload;
}


/**************************************************************************/
void  tbvDataComT::insertBytes(const unsigned int start_index, const vector<uint8> & bytes)
{ 
  if (start_index > _payload.size())
  {
     tbvExceptionT::setUserExceptionTypeString("PAYLOAD_SIZE_TOO_SMALL");
     tbvExceptionT::reportUserException("PAYLOAD_SIZE_TOO_SMALL",
					tbvExceptionT::ERROR,
					"in tbvDataComT::insertBytes start_index is too large");
  }
  _payload.insert((_payload.begin() + start_index), bytes.begin(), bytes.end());
  _payloadsize = _payloadsize + bytes.size();
}


/**************************************************************************/
vector<uint16>   tbvDataComT::getDataBy16() const
{
  //auto_ptr<vector<uint16> > dataP(new vector<uint16>);
  vector<uint16>  dataP = vector<uint16>();
  uint16  data;
			// template data to hold uint16
  int     size8;
			// size of the vector<uint8>
  int     size16;
			// size of the vector<uint16>
  int     index8;
			// index used for vector<uint8>
  int     index16;
			// index used for vector<uint16>
  int     j;
			// index used to indicate which round is in
  int     ratio = 2;   
			// it takes ratio = 2 elements from vector<uint8> to 
 		        // form vector<uint16>

  vector<uint8>  vtmp = getData();
  size8 = vtmp.size();
  size16 = (int) ceil(0.5*size8);

#ifdef DATACOM_DEBUG
  tbvOut<<"data size is "<< dec << size8<<" bytes " << " which is equal to " << size16 << " 16bits in getDataBy16."<< endl;
#endif

  index16 = 0;
  while (index16 < size16)
  {
    data = 0;
    j = 0;
    while (j < ratio)
    {
      index8 = ratio*index16 + j;
      if (index8 < size8) 
      {
        data = data<<8;
        data = data + vtmp[index8];
      } else {
        data = data<<8;
      }
      j++;
    }

#ifdef DATACOM_DEBUG
    tbvOut<<"in getDataBy16 data["<< dec << index16 <<"] = "<<hex << data << endl;
#endif

    dataP.push_back(data);
    index16++;
  }

#ifdef DATACOM_DEBUG
  tbvOut<<"in getDataBy16 data size is "<< dec << dataP->size()<< endl;
#endif

  return dataP;
}  


/**************************************************************************/
vector<uint32>   tbvDataComT::getDataBy32() const
{
  vector<uint32>  dataP = vector<uint32>();
  uint32  data;
			// template data to hold uint32
  int     size8;
			// size of the vector<uint8>
  int     size32;
			// size of the vector<uint32>
  int     index8;
			// index used for vector<uint8>
  int     index32;
			// index used for vector<uint32>
  int     j;
			// index used to indicate which round is in
  int     ratio = 4;   
			// it takes ratio = 4 elements from vector<uint8> to 
 		        // form vector<uint32>

  vector<uint8>  vtmp = getData();
  size8 = vtmp.size();
  size32 = (int) ceil(0.25*size8);

#ifdef DATACOM_DEBUG
  tbvOut<<"data size is "<< dec << size8<<" bytes " << " which is equal to " << size32 << " 32bits in getDataBy32."<< endl;
#endif

  index32 = 0;
  while (index32 < size32)
  {
    data = 0;
    j = 0;
    while (j < ratio)
    {
      index8 = ratio*index32 + j;
      if (index8 < size8) 
      {
        data = data<<8;
        data = data + vtmp[index8];
      } else {
        data = data<<8;
      }
      j++;
    }

#ifdef DATACOM_DEBUG
    tbvOut<<"in getDataBy32 data["<< dec << index32 <<"] = "<<hex << data << endl;
#endif

    dataP.push_back(data);
    index32++;
  }

#ifdef DATACOM_DEBUG
  tbvOut<<"in getDataBy32 data size is "<< dec << dataP->size()<< endl;
#endif

  return dataP;
}  


/**************************************************************************/
vector<uint64>   tbvDataComT::getDataBy64() const
{
  vector<uint64>  dataP =  vector<uint64>();
  uint64  data;
			// template data to hold uint64
  int     size8;
			// size of the vector<uint8>
  int     size64;
			// size of the vector<uint64>
  int     index8;
			// index used for vector<uint8>
  int     index64;
			// index used for vector<uint64>
  int     j;
			// index used to indicate which round is in
  int     ratio = 8;   
			// it takes ratio = 8 elements from vector<uint8> to 
 		        // form vector<uint64>


  vector<uint8>  vtmp = getData();
  size8 = vtmp.size();
  size64 = (int) ceil(0.125*size8);

#ifdef DATACOM_DEBUG
  tbvOut<<"data size is "<< dec << size8<<" bytes " << " which is equal to " << size64 << " 64bits in getDataBy64."<< endl;
#endif

  index64 = 0;
  while (index64 < size64)
  {
    data = 0;
    j = 0;
    while (j < ratio)
    {
      index8 = ratio*index64 + j;

#ifdef DATACOM_DEBUG
      tbvOut<<dec << "index64 = " << index64 <<" index8 = "<< index8 << " j = " << j <<" ratio = " << ratio << endl;
#endif

      if (index8 < size8) 
      {
        data = data<<8;

#ifdef DATACOM_DEBUG
        tbvOut<<"data  = "<<hex << data << endl;
#endif

        data = data + vtmp[index8];

#ifdef DATACOM_DEBUG
        tbvOut<<"data = "<< hex << data << " vtmp["<<dec<<index8<<"] = " << hex << (uint64) vtmp[index8] << endl;
#endif

      } else {
        data = data<<8;

#ifdef DATACOM_DEBUG
        tbvOut<<"data = "<< hex << data << endl;
#endif

      }
      j++;
    }

#ifdef DATACOM_DEBUG
    tbvOut<<"in getDataBy64 data["<< dec << index64 <<"] = "<<hex << data << endl;
#endif

    dataP.push_back(data);
    index64++;
  }

  return dataP;
}  


/**************************************************************************/
bool  tbvDataComT::isPkt() const
{
  return _isPkt;
}


/**************************************************************************/
bool  tbvDataComT::isCell() const
{
  return _isCell;
}


/**************************************************************************/
DATACOM_TYPE  tbvDataComT::getType() 
{
  return DATACOM;
}


/**************************************************************************/
const tbvControlDataT &  tbvDataComT::getControlData() const
{
  return _control;
}


/**************************************************************************/
void  tbvDataComT::setControlData(const tbvControlDataT & control)
{
  _control = control;
}


/**************************************************************************/
void  tbvDataComT::setInputPort(const unsigned int input_port)
{ 
   _control.fid.input_port = input_port;
   if(!_control.fid.input_port.satisfyConstraints())
   {
   tbvExceptionT::setUserExceptionTypeString("CONSTRAINT_VIOLATION");
   tbvExceptionT::reportUserException("CONSTRAINT_VIOLATION",
				       tbvExceptionT::ERROR,
				       "input port field constraint violated");
   }
}


/**************************************************************************/
const tbvSmartUnsignedT &  tbvDataComT::getInputPort() const
{ 
   return _control.fid.input_port;
}


/**************************************************************************/
void  tbvDataComT::setOutputPort(const unsigned int output_port)
{ 
   _control.fid.output_port = output_port;
   if(!_control.fid.output_port.satisfyConstraints())
   {
   tbvExceptionT::setUserExceptionTypeString("CONSTRAINT_VIOLATION");
   tbvExceptionT::reportUserException("CONSTRAINT_VIOLATION",
				       tbvExceptionT::ERROR,
				       "output port field constraint violated");
   }
}


/**************************************************************************/
const tbvSmartUnsignedT &  tbvDataComT::getOutputPort() const
{ 
  return _control.fid.output_port;
}


/**************************************************************************/
void  tbvDataComT::setQos(const unsigned int qos)
{ 
   _control.fid.qos = qos;
   if(!_control.fid.qos.satisfyConstraints())
   {
   tbvExceptionT::setUserExceptionTypeString("CONSTRAINT_VIOLATION");
   tbvExceptionT::reportUserException("CONSTRAINT_VIOLATION",
				       tbvExceptionT::ERROR,
				       "Qos field constraint violated");
   }
}


/**************************************************************************/
const tbvSmartUnsignedT &  tbvDataComT::getQos() const
{ 
  return _control.fid.qos;
}


/**************************************************************************/
void  tbvDataComT::setFid(const tbvFlowIdT & fid)
{ 
   _control.fid = fid;
   if(!_control.fid.satisfyConstraints())
   {
   tbvExceptionT::setUserExceptionTypeString("CONSTRAINT_VIOLATION");
   tbvExceptionT::reportUserException("CONSTRAINT_VIOLATION",
				       tbvExceptionT::ERROR,
				       "flow ID field constraint violated");
   }
}


/**************************************************************************/
const tbvFlowIdT &  tbvDataComT::getFid() const
{ 
  return _control.fid;
}


/**************************************************************************/
void  tbvDataComT::setBidList(const tbvListT<tbvSmartUnsignedT> & bidList)
{
   _control.bidList = bidList;
/*   if(!_control.bidList.satisfyConstraints())
   {
   tbvExceptionT::setUserExceptionTypeString("CONSTRAINT_VIOLATION");
   tbvExceptionT::reportUserException("CONSTRAINT_VIOLATION",
                                       tbvExceptionT::ERROR,
                                       "flow ID field constraint violated");
   }
*/
}


/**************************************************************************/
const tbvListT<tbvSmartUnsignedT> &  tbvDataComT::getBidList() const
{
  return _control.bidList;
}


/**************************************************************************/
void  tbvDataComT::setBid(const unsigned int bid)
{
   _control.bidList.clear(); 
   _control.bidList.pushFront(bid);
}


/**************************************************************************/
const tbvSmartUnsignedT&  tbvDataComT::getBid() const
{
   if(_control.bidList.size() != 1)
   {
   
   tbvExceptionT::setUserExceptionTypeString("MORE_THAN_ONE_BID");
   tbvExceptionT::reportUserException("MORE_THAN_ONE_BID",
                                       tbvExceptionT::ERROR,
                                       "More than one BID allocated");
   }
   return _control.bidList.front();
}




/**************************************************************************/
void  tbvDataComT::setTrafficType(const unsigned int traffic_type)
{ 
   _control.traffic_type = traffic_type;
   if(!_control.traffic_type.satisfyConstraints())
   {
   tbvExceptionT::setUserExceptionTypeString("CONSTRAINT_VIOLATION");
   tbvExceptionT::reportUserException("CONSTRAINT_VIOLATION",
				       tbvExceptionT::ERROR,
				       "Traffic Type field constraint violated");
   }
}


/**************************************************************************/
const tbvSmartUnsignedT &  tbvDataComT::getTrafficType() const
{ 
  return _control.traffic_type;
}


/**************************************************************************/
void  tbvDataComT::setSN(const unsigned int sn)
{ 
   _control.SN = sn;
   if(!_control.SN.satisfyConstraints())
   {
   tbvExceptionT::setUserExceptionTypeString("CONSTRAINT_VIOLATION");
   tbvExceptionT::reportUserException("CONSTRAINT_VIOLATION",
				       tbvExceptionT::ERROR,
				       "Sequence Number field constraint violated");
   };
}


/**************************************************************************/
const tbvSmartUnsignedT &  tbvDataComT::getSN() const
{ 
  return _control.SN;
}

/**************************************************************************/
void  tbvDataComT::setSOP(const unsigned int sop)
{ 
  _control.sop = sop;
  if(!_control.sop.satisfyConstraints())
    {
      tbvExceptionT::setUserExceptionTypeString("CONSTRAINT_VIOLATION");
      tbvExceptionT::reportUserException("CONSTRAINT_VIOLATION",
					 tbvExceptionT::ERROR,
					 "SOP field constraint violated");
    }
}


/**************************************************************************/
const tbvSmartUnsignedT &  tbvDataComT::getSOP() const
{ 
  return _control.sop;
}


/**************************************************************************/
void  tbvDataComT::setEOP(const unsigned int eop)
{ 
   _control.eop = eop;
   if(!_control.eop.satisfyConstraints())
   {
   tbvExceptionT::setUserExceptionTypeString("CONSTRAINT_VIOLATION");
   tbvExceptionT::reportUserException("CONSTRAINT_VIOLATION",
				       tbvExceptionT::ERROR,
				       "EOP field constraint violated");
   }
}


/**************************************************************************/
const tbvSmartUnsignedT &  tbvDataComT::getEOP() const
{ 
  return _control.eop;
}


/**************************************************************************/
void  tbvDataComT::setSOB(const unsigned int sob)
{ 
   _control.sob = sob;
   if(!_control.sob.satisfyConstraints())
   {
   tbvExceptionT::setUserExceptionTypeString("CONSTRAINT_VIOLATION");
   tbvExceptionT::reportUserException("CONSTRAINT_VIOLATION",
				       tbvExceptionT::ERROR,
				       "SOB field constraint violated");
   }
}


/**************************************************************************/
const tbvSmartUnsignedT &  tbvDataComT::getSOB() const
{ 
  return _control.sob;
}


/**************************************************************************/
void  tbvDataComT::setEOB(const unsigned int eob)
{ 
   _control.eob = eob;
   if(!_control.eob.satisfyConstraints())
   {
   tbvExceptionT::setUserExceptionTypeString("CONSTRAINT_VIOLATION");
   tbvExceptionT::reportUserException("CONSTRAINT_VIOLATION",
				       tbvExceptionT::ERROR,
				       "EOB field constraint violated");
   }
}


/**************************************************************************/
const tbvSmartUnsignedT &  tbvDataComT::getEOB() const
{ 
  return _control.eob;
}


/**************************************************************************/
void  tbvDataComT::setCLP(const unsigned int clp)
{ 
   _control.clp = clp;
   if(!_control.clp.satisfyConstraints())
   {
   tbvExceptionT::setUserExceptionTypeString("CONSTRAINT_VIOLATION");
   tbvExceptionT::reportUserException("CONSTRAINT_VIOLATION",
				       tbvExceptionT::ERROR,
				       "CLP field constraint violated");
   }
}


/**************************************************************************/
const tbvSmartUnsignedT &  tbvDataComT::getCLP() const
{ 
  return _control.clp;
}


/**************************************************************************/
void  tbvDataComT::setEFCI(const unsigned int efci)
{ 
   _control.efci = efci;
   if(!_control.efci.satisfyConstraints())
   {
   tbvExceptionT::setUserExceptionTypeString("CONSTRAINT_VIOLATION");
   tbvExceptionT::reportUserException("CONSTRAINT_VIOLATION",
				       tbvExceptionT::ERROR,
				       "EFCI field constraint violated");
   }
}


/**************************************************************************/
const tbvSmartUnsignedT &  tbvDataComT::getEFCI() const
{ 
  return _control.efci;
}


/**************************************************************************/
void  tbvDataComT::setValid(const unsigned int valid)
{ 
   _control.valid = valid;
   if(!_control.valid.satisfyConstraints())
   {
   tbvExceptionT::setUserExceptionTypeString("CONSTRAINT_VIOLATION");
   tbvExceptionT::reportUserException("CONSTRAINT_VIOLATION",
				       tbvExceptionT::ERROR,
				       "Valid field constraint violated");
   }
}


/**************************************************************************/
const tbvSmartUnsignedT &  tbvDataComT::getValid() const
{ 
  return _control.valid;
}


/**************************************************************************/
void  tbvDataComT::setBad(const unsigned int bad)
{ 
   _control.bad = bad;
   if(!_control.bad.satisfyConstraints())
   {
   tbvExceptionT::setUserExceptionTypeString("CONSTRAINT_VIOLATION");
   tbvExceptionT::reportUserException("CONSTRAINT_VIOLATION",
				       tbvExceptionT::ERROR,
				       "bad field constraint violated");
   }
}


/**************************************************************************/
const tbvSmartUnsignedT &  tbvDataComT::getBad() const
{ 
  return _control.bad;
}


/**************************************************************************/
void  tbvDataComT::setOAM(const unsigned int oam)
{ 
   _control.oam = oam;
   if(!_control.oam.satisfyConstraints())
   {
   tbvExceptionT::setUserExceptionTypeString("CONSTRAINT_VIOLATION");
   tbvExceptionT::reportUserException("CONSTRAINT_VIOLATION",
				       tbvExceptionT::ERROR,
				       "OAM field constraint violated");
   }
}


/**************************************************************************/
const tbvSmartUnsignedT &  tbvDataComT::getOAM() const
{ 
  return _control.oam;
}


/**************************************************************************/
void  tbvDataComT::setArriveTime(const uint64 time)
{ 
  _control.arriveTime = time;
}


/**************************************************************************/
const uint64  tbvDataComT::getArriveTime() const
{ 
  return _control.arriveTime;
}


/**************************************************************************/
void  tbvDataComT::setDepartureTime(const uint64 time)
{ 
  _control.departureTime = time;
}


/**************************************************************************/
const uint64  tbvDataComT::getDepartureTime() const
{ 
  return _control.departureTime;
}


/**************************************************************************/
void  tbvDataComT::setTransactionHandle(const tbvTransactionHandleT & handle)
{ 
  _control.transactionHandle = handle;
}


/**************************************************************************/
const tbvTransactionHandleT tbvDataComT::getTransactionHandle() const
{ 
  return _control.transactionHandle;
}

/**************************************************************************/
void  tbvDataComT::setMPLSCount(const unsigned int mpls_count)
{
   tbvExceptionT::setUserExceptionTypeString("WRONG_CONTROL_FIELD");
   tbvExceptionT::reportUserException("WRONG_CONTROL_FIELD",
				      tbvExceptionT::ERROR,
				      "MPLS Count is a wrong control field in tbvDataComT");
}


/**************************************************************************/
const unsigned int  tbvDataComT::getMPLSCount() const
{
  tbvExceptionT::setUserExceptionTypeString("WRONG_CONTROL_FIELD");
   tbvExceptionT::reportUserException("WRONG_CONTROL_FIELD",
				      tbvExceptionT::ERROR,
				      "MPLS Count is a wrong control field");
   return _control.MPLS_count;
}


/**************************************************************************/
bool tbvDataComT::isControlEqual(const tbvDataComT & datacom,
				 tbvListT<CONTROL_FIELD_TYPE> & fields,
				 bool keep = false, 
				 bool error = TRUE,
				 tbvFiberT * fiberP = NULL) const
{ 
  tbvListT<CONTROL_FIELD_TYPE>   test_fields;
  tbvListT<CONTROL_FIELD_TYPE>::iteratorT iter;
  bool isEqual = TRUE;

  if (keep == true)
  {
    test_fields = fields;
  }
  else
  {
    test_fields.pushBack(INPUT_PORT);
    test_fields.pushBack(OUTPUT_PORT);
    test_fields.pushBack(QOS);
    test_fields.pushBack(FID);
    test_fields.pushBack(TRAFFIC_TYPE);
    test_fields.pushBack(SEQUENCE_NUMBER);
    test_fields.pushBack(SOP);
    test_fields.pushBack(EOP);
    test_fields.pushBack(SOB);
    test_fields.pushBack(EOB);
    test_fields.pushBack(OAM);
    test_fields.pushBack(CLP);
    test_fields.pushBack(EFCI);
    test_fields.pushBack(VALID);
    test_fields.pushBack(BIDLIST);
    test_fields.pushBack(BAD);
    for (iter = fields.begin(); iter != fields.end(); iter++)
    {
      test_fields.remove(*iter);
    }
  }

  for (iter = test_fields.begin(); iter != test_fields.end(); iter++)
  {
    switch (*iter)
    {
      case INPUT_PORT:
        if (getInputPort().getUnsignedValue() != datacom.getInputPort().getUnsignedValue()) 
        {
	  if (fiberP) fiberP->reportErrorTransactionH("CONTROL_FIELD INPUT_PORT MISMATCH");
	  tbvExceptionT::setUserExceptionTypeString("INPUT_PORT_MISMATCH");
          if (error) tbvExceptionT::reportUserException("INPUT_PORT_MISMATCH",
                                          tbvExceptionT::ERROR,
                           "in tbvDataComT::isControlEqual the INPUT_PORTs do not match");
	  isEqual = FALSE;
        }
        break;
      case OUTPUT_PORT:
        if (getOutputPort().getUnsignedValue() != datacom.getOutputPort().getUnsignedValue())
        {
	  if (fiberP) fiberP->reportErrorTransactionH("CONTROL_FIELD OUTPUT_PORT MISMATCH");
	  tbvExceptionT::setUserExceptionTypeString("OUTPUT_PORT_MISMATCH");
          if (error) tbvExceptionT::reportUserException("OUTPUT_PORT_MISMATCH",
                                          tbvExceptionT::ERROR,
                           "in tbvDataComT::isControlEqual the OUTPUT_PORTs do not match");
	  isEqual = FALSE;
        }
        break;
      case QOS:
        if (getQos().getUnsignedValue() != datacom.getQos().getUnsignedValue())
        {
	  if (fiberP) fiberP->reportErrorTransactionH("CONTROL_FIELD QOS MISMATCH");
	  tbvExceptionT::setUserExceptionTypeString("QOS_MISMATCH");
          if (error) tbvExceptionT::reportUserException("QOS_MISMATCH",
                                          tbvExceptionT::ERROR,
                           "in tbvDataComT::isControlEqual the QOSes do not match");
	  isEqual = FALSE;
        }
        break;
      case FID:
        if (getFid().fid.getUnsignedValue() != datacom.getFid().fid.getUnsignedValue())
        {
	  if (fiberP) fiberP->reportErrorTransactionH("CONTROL_FIELD FID MISMATCH");
	  tbvExceptionT::setUserExceptionTypeString("FID_MISMATCH");
          if (error) tbvExceptionT::reportUserException("FID_MISMATCH",
                                          tbvExceptionT::ERROR,
                           "in tbvDataComT::isControlEqual the FIDs do not match");
	  isEqual = FALSE;
        }
        break;
      case TRAFFIC_TYPE:
        if (getTrafficType().getUnsignedValue() != datacom.getTrafficType().getUnsignedValue())
        {
	  if (fiberP) fiberP->reportErrorTransactionH("CONTROL_FIELD TRAFFIC_TYPE MISMATCH");
	  tbvExceptionT::setUserExceptionTypeString("TRAFFIC_TYPE_MISMATCH");
          if (error) tbvExceptionT::reportUserException("TRAFFIC_TYPE_MISMATCH",
                                          tbvExceptionT::ERROR,
                           "in tbvDataComT::isControlEqual the TRAFFIC_TYPEs do not match");
	  isEqual = FALSE;
        }
        break;
      case SEQUENCE_NUMBER:
        if (getSN().getUnsignedValue() != datacom.getSN().getUnsignedValue())
        {
	  if (fiberP) fiberP->reportErrorTransactionH("CONTROL_FIELD SEQUENCE_NUMBER MISMATCH");
	  tbvExceptionT::setUserExceptionTypeString("SEQUENCE_NUMBER_MISMATCH");
          if (error) tbvExceptionT::reportUserException("SEQUENCE_NUMBER_MISMATCH",
                                          tbvExceptionT::ERROR,
                           "in tbvDataComT::isControlEqual the SEQUENCE_NUMBERs do not match");
	  isEqual = FALSE;
        }
        break;
      case SOP:
        if (getSOP().getUnsignedValue() != datacom.getSOP().getUnsignedValue())
        {
	  if (fiberP) fiberP->reportErrorTransactionH("CONTROL_FIELD SOP MISMATCH");
	  tbvExceptionT::setUserExceptionTypeString("SOP_MISMATCH");
          if (error) tbvExceptionT::reportUserException("SOP_MISMATCH",
                                          tbvExceptionT::ERROR,
                           "in tbvDataComT::isControlEqual the SOPs do not match");
	  isEqual = FALSE;
        }
        break;
      case EOP:
        if (getEOP().getUnsignedValue() != datacom.getEOP().getUnsignedValue())
        {
	  if (fiberP) fiberP->reportErrorTransactionH("CONTROL_FIELD EOP MISMATCH");
	  tbvExceptionT::setUserExceptionTypeString("EOP_MISMATCH");
          if (error) tbvExceptionT::reportUserException("EOP_MISMATCH",
                                          tbvExceptionT::ERROR,
                           "in tbvDataComT::isControlEqual the EOPs do not match");
	  isEqual = FALSE;
        }
        break;
      case SOB:
        if (getSOB().getUnsignedValue() != datacom.getSOB().getUnsignedValue())
        {
	  if (fiberP) fiberP->reportErrorTransactionH("CONTROL_FIELD SOB MISMATCH");
	  tbvExceptionT::setUserExceptionTypeString("SOB_MISMATCH");
          if (error) tbvExceptionT::reportUserException("SOB_MISMATCH",
                                          tbvExceptionT::ERROR,
                           "in tbvDataComT::isControlEqual the SOBs do not match");
	  isEqual = FALSE;
        }
        break;
      case EOB:
        if (getEOB().getUnsignedValue() != datacom.getEOB().getUnsignedValue())
        {
	  if (fiberP) fiberP->reportErrorTransactionH("CONTROL_FIELD EOB MISMATCH");
	  tbvExceptionT::setUserExceptionTypeString("EOB_MISMATCH");
          if (error) tbvExceptionT::reportUserException("EOB_MISMATCH",
                                          tbvExceptionT::ERROR,
                           "in tbvDataComT::isControlEqual the EOBs do not match");
	  isEqual = FALSE;
        }
        break;
      case OAM:
        if (getOAM().getUnsignedValue() != datacom.getOAM().getUnsignedValue())
        {
          if (fiberP) fiberP->reportErrorTransactionH("CONTROL_FIELD OAM MISMATCH");
          tbvExceptionT::setUserExceptionTypeString("OAM_MISMATCH");
          if (error) tbvExceptionT::reportUserException("OAM_MISMATCH",
                                          tbvExceptionT::ERROR,
                           "in tbvDataComT::isControlEqual the OAMs do not match");
          isEqual = FALSE;
        }
        break;

      case CLP:
        if (getCLP().getUnsignedValue() != datacom.getCLP().getUnsignedValue())
        {
	  if (fiberP) fiberP->reportErrorTransactionH("CONTROL_FIELD CLP MISMATCH");
	  tbvExceptionT::setUserExceptionTypeString("CLP_MISMATCH");
          if (error) tbvExceptionT::reportUserException("CLP_MISMATCH",
                                          tbvExceptionT::ERROR,
                           "in tbvDataComT::isControlEqual the CLPs do not match");
	  isEqual = FALSE;
        }
        break;
      case EFCI:
        if (getEFCI().getUnsignedValue() != datacom.getEFCI().getUnsignedValue())
        {
	  if (fiberP) fiberP->reportErrorTransactionH("CONTROL_FIELD EFCI MISMATCH");
	  tbvExceptionT::setUserExceptionTypeString("EFCI_MISMATCH");
          if (error) tbvExceptionT::reportUserException("EFCI_MISMATCH",
                                          tbvExceptionT::ERROR,
                           "in tbvDataComT::isControlEqual the EFCIs do not match");
	  isEqual = FALSE;
        }
        break;
      case VALID:
        if (getValid().getUnsignedValue() != datacom.getValid().getUnsignedValue())
        {
	  if (fiberP) fiberP->reportErrorTransactionH("CONTROL_FIELD VALID MISMATCH");
	  tbvExceptionT::setUserExceptionTypeString("VALID_MISMATCH");
          if (error) tbvExceptionT::reportUserException("VALID_MISMATCH",
                                          tbvExceptionT::ERROR,
                           "in tbvDataComT::isControlEqual the VALIDs do not match");
	  isEqual = FALSE;
        }
        break;
      case BIDLIST:
        if (getBidList() != datacom.getBidList())
        {
          if (fiberP) fiberP->reportErrorTransactionH("CONTROL_FIELD BID MISMATCH");
          tbvExceptionT::setUserExceptionTypeString("BID_MISMATCH");
          if (error) tbvExceptionT::reportUserException("BID_MISMATCH",
                                          tbvExceptionT::ERROR,
                           "in tbvDataComT::isControlEqual the BIDs do not match");
          isEqual = FALSE;
        }
        break;
      case BAD:
        if (getBad() != datacom.getBad())
        {
          if (fiberP) fiberP->reportErrorTransactionH("CONTROL_FIELD BAD MISMATCH");
          tbvExceptionT::setUserExceptionTypeString("BAD_MISMATCH");
          if (error) tbvExceptionT::reportUserException("BAD_MISMATCH",
                                          tbvExceptionT::ERROR,
                           "in tbvDataComT::isControlEqual the BADs do not match");
          isEqual = FALSE;
        }
        break;


      default:
        isEqual = FALSE;
        break;
    }
  }

  if (isEqual)
    return TRUE;
  else
    return FALSE;
}







/**************************************************************************/
void  tbvDataComT::randomize()
{
  tbvSmartRecordT::randomize();
  randomPayload(_payloadsize);
}


/**************************************************************************/
void  tbvDataComT::randomData()
{
  randomHeader();
  randomPayload(_payloadsize);
  randomTrailer();
}


/**************************************************************************/
void  tbvDataComT::randomPayload(int size = 0)
{
  if (size > MAX_PAYLOAD_SIZE)
  {
    tbvOut<<"MAX_PAYLO"<<MAX_PAYLOAD_SIZE<<endl;
    tbvExceptionT::setUserExceptionTypeString("PAYLOAD_SIZE_OVERFLOW");
    tbvExceptionT::reportUserException("PAYLOAD_SIZE_OVERFLOW",
                                        tbvExceptionT::WARNING,
                                        "in tbvDataComT::randomPayload(size) size is larger than MAX_PAYLOAD_SIZE, set size to MAX_PAYLOAD_SIZE.");
    size = MAX_PAYLOAD_SIZE;
    _payloadsize = size; 
  }
			//if the size is larger than the maximum size, 
			//the size is set to the maximum size
  else if (size == 0)
  {
    size = _payloadsize;
  }

  tbvSmartUnsignedT rand;
  
  rand.keepOnly(0,0xFF);
			//only create an unsigned integer in 0~255 to match
			//it to a char
  _payload.erase(_payload.begin(), _payload.end());
			//clear the old data before generate the new data

  for (int i = 0; i < size; i++)
  {
    rand.randomize();

#ifdef DATACOM_DEBUG
    tbvOut << "in randomPayload  rand[" << dec <<i<<"] = " << hex <<rand.getUnsignedValue() << endl;
#endif

    _payload.push_back((uint8) rand.getUnsignedValue());
  }

#ifdef DATACOM_DEBUG
  for (unsigned int i = 0; i < _payload.size(); i++)
  {
    tbvOut << "in randomPayload  payload[" << dec <<i<<"] = " << hex <<(uint64)_payload[i] << endl;
  }
#endif
    
}


/**************************************************************************/
void  tbvDataComT::convertFrom(const tbvDataComT * rhsP, 
			       PROTOCOL_LEVEL dir = EQUAL,
                               const vector<uint8> * headerP = NULL,
                               const vector<uint8> * payloadP = NULL,
                               const vector<uint8> * trailerP = NULL)
{
  if (isPkt() != rhsP->isPkt() || isCell() != rhsP->isCell()) 
  {
    tbvExceptionT::setUserExceptionTypeString("DATACOM_TYPE_MISMATCH");
    tbvExceptionT::reportUserException("DATACOM_TYPE_MISMATCH",
                                        tbvExceptionT::ERROR,
                                        "can not switch datacoms since they are not the same type.");
  }

  _control = rhsP->getControlData();

  switch (dir)
  {
    case ADD:
    case UP:
      if (headerP != NULL) setHeader(*headerP);
      setPayload(rhsP->getData());
      if (trailerP != NULL) setTrailer(*trailerP);
      break;
    case EQUAL:
      createHeader(rhsP->getData());
      setPayload(rhsP->getPayload());
      createTrailer(rhsP->getTrailer());
      break;
    case DOWN:
    case REMOVE:
      createHeader(rhsP->getPayload());
      createPayload(rhsP->getPayload());
      createTrailer(rhsP->getPayload());
      break;
    default:
      tbvExceptionT::setUserExceptionTypeString("DATACOM_CONVERSION_UNKNOWN");
      tbvExceptionT::reportUserException("DATACOM_CONVERSION_UNKNOWN",
                                        tbvExceptionT::ERROR,
                                        "unknown datacom convertion directions");
      break;
   }

}
   

/**************************************************************************/
void  tbvDataComT::createHeader(const vector<uint8> & header) {}
   

/**************************************************************************/
void  tbvDataComT::createPayload(const vector<uint8> &  payload) 
{
  _payload = payload;
}
   

/**************************************************************************/
void  tbvDataComT::createTrailer(const vector<uint8> & data) {}
   
/**************************************************************************/
ostream& operator<<(ostream& ostr, const tbvDataComT &x)
{
 vector <uint32> packetData = x.getDataBy32();
 
 vector <uint32>::iterator i;
 ostr << endl << "Size = " << dec << x.getPayloadSize() << endl;
  for (i=packetData.begin(); i != packetData.end(); i++)
  {
     ostr << setw(8) << setfill('0') << hex << *i << endl;
  }
  return(ostr);
  
}
  
/**************************************************************************/
ostream& printDatacom(ostream& ostr, const tbvDataComT &x)
{
vector <uint8> packetData = x.getData();
if (!ostr.opfx()) return ostr;
vector <uint8>::iterator i;
ostr << endl << "DATACOMBEGIN" << endl;
ostr << "SIZE " << dec << x.getPayloadSize() << endl;
for (i=packetData.begin(); i != packetData.end(); i++)
{
    ostr << resetiosflags(ios::showbase) << hex << unsigned(*i) << " ";
}
ostr << endl << x.getControlData();
ostr.osfx();
return(ostr);

}

/**************************************************************************/
istream& operator>>(istream& istr, tbvDataComT &x)
{
    istr.ipfx(0);
    if (!istr) {
       tbvOut << "tbvDataComT::operator>> istr is false!" << endl; 
    }

    if (istr.eof()) {
        tbvOut << "tbvDataComT::operator>> file is EOF!" << endl;
    }

    long oldFlags = istr.flags(0);
    istr.setf(ios::skipws);
    vector <uint8> packetData(64,0);
    tbvControlDataT control;
    unsigned int size;
    string field;
    unsigned times = 0;
    do {
        istr >> field;
    } while (field != "DATACOMBEGIN" && times++ < 10);
    istr >> field;
    if (field == "SIZE") { 
        istr >> dec >> size;
        unsigned int data;
        for (unsigned i=0; i < size; i++)
            {
                istr >> hex >> data;
                packetData[i] = data;
            }
        
        istr >> control;
        packetData.resize(size);
        x.setControlData(control);
        x.setPayload(packetData);
        istr.flags(oldFlags);
        return istr;
    }
    istr.clear(ios::failbit | istr.rdstate());
    return(istr);

}
/**************************************************************************/
unsigned long long tbvDataComT::getKey() const {return 0;}
/**************************************************************************/
void tbvDataComT::setValidFields(tbvListT<CONTROL_FIELD_TYPE> & fields) {
    _control.setValidFields(fields);
}
/**************************************************************************/

tbvListT<CONTROL_FIELD_TYPE> tbvDataComT::getValidFields() const {
    return _control.getValidFields();
}
/**************************************************************************/
