// ----------------------------------------------------------------------------
// (c) Copyright 2005, Springer.  All Rights Reserved. The code in this CD-ROM is
// distributed by Springer with ABSOLUTELY NO SUPPORT and NO WARRANTY from
// Springer. Use or reproduction of the information provided on this code for
// commercial gain is strictly prohibited. Explicit permission is given for the
// reproduction and use of this information in an instructional setting provided
// proper reference is given to the original source.
//
// Authors and Springer shall not be liable for damage in connection with, or
// arising out of, the furnishing, performance or use of the contents of the
// CD-ROM.
// ----------------------------------------------------------------------------

#include "tbvEtherPkt.h"


/**************************************************************************/
tbvEtherPktT::tbvEtherPktT(int size = RAND_SIZE,
			   const tbvSmartArrayT<tbvSmartUnsignedT, ETHER_ADDR_LEN> * daP = NULL, 
			   const tbvSmartArrayT<tbvSmartUnsignedT, ETHER_ADDR_LEN> * saP = NULL, 
			   const tbvControlDataT * controlP = NULL,
    		 	   const char * nameP = NULL) :
	        tbvDataComT(size, controlP, nameP),
		_len(this, "Length of Data Field", true),
		_da(this, "Destination Address", true),
		_sa(this, "Source Address", true) 
{ 
  setup();

  if (daP != NULL) _da = *daP;   
  if (saP != NULL) _sa = *saP;   
}


/**************************************************************************/
tbvEtherPktT::tbvEtherPktT(const char * payload, const tbvControlDataT * controlP = NULL, 
    		 const char * nameP = NULL) :
	        tbvDataComT(payload, controlP, nameP) { setup(); }


/**************************************************************************/
tbvEtherPktT::tbvEtherPktT(const vector<uint8> & payload, 
		 const tbvControlDataT * controlP = NULL,
    		 const char * nameP = NULL) :
	        tbvDataComT(payload, controlP, nameP) { setup(); }


/**************************************************************************/
tbvEtherPktT::tbvEtherPktT(const tbvEtherPktT & rhs, 
		 PROTOCOL_LEVEL dir = EQUAL,
		 const vector<uint8> * headerP = NULL,
		 const vector<uint8> * payloadP = NULL,
		 const vector<uint8> * trailerP = NULL,
		 const char * nameP = NULL) :
	         tbvDataComT(nameP) 
{ 
  setup(); 
  protectCopyCtor(rhs, dir, headerP, payloadP, trailerP);
}


/**************************************************************************/
tbvEtherPktT::tbvEtherPktT(const tbvSmartDataT * parentP, const char * nameP = NULL,
		 bool derived = false) :
	       tbvDataComT(parentP, nameP, derived) { setup(); }


/**************************************************************************/
tbvEtherPktT & tbvEtherPktT::operator=(const tbvEtherPktT & rhs)
{
  tbvDataComT::operator=(rhs); 
  return *this;
}


/**************************************************************************/
tbvEtherPktT::~tbvEtherPktT() { wrapup(); }


/**************************************************************************/
void tbvEtherPktT::setup() 
{ 
  _isPkt = true;
}


/**************************************************************************/
void tbvEtherPktT::wrapup() { } 


/**************************************************************************/
tbvSmartUnsignedT &  tbvEtherPktT::getInputPort() 
{
  return getControlData().fid.input_port;
} 


/**************************************************************************/
tbvSmartUnsignedT &  tbvEtherPktT::getOutputPort() 
{
  return getControlData().fid.output_port;
} 


/**************************************************************************/
tbvSmartUnsignedT &  tbvEtherPktT::getQos() 
{
  return getControlData().fid.qos;
} 


/**************************************************************************/
tbvFlowIdT &  tbvEtherPktT::getFid() 
{
  return getControlData().fid;
} 


/**************************************************************************/
tbvFlowIdT &  tbvEtherPktT::getTrafficType() 
{
  return getControlData().traffic_type;
} 


/**************************************************************************/
tbvFlowIdT &  tbvEtherPktT::getMPLSCount() 
{
  return getControlData().MPLS_count;
} 


/**************************************************************************/
tbvFlowIdT &  tbvEtherPktT::getValid() 
{
  return getControlData().valid;
} 

