// ----------------------------------------------------------------------------
// (c) Copyright 2005, Springer.  All Rights Reserved. The code in this CD-ROM is
// distributed by Springer with ABSOLUTELY NO SUPPORT and NO WARRANTY from
// Springer. Use or reproduction of the information provided on this code for
// commercial gain is strictly prohibited. Explicit permission is given for the
// reproduction and use of this information in an instructional setting provided
// proper reference is given to the original source.
//
// Authors and Springer shall not be liable for damage in connection with, or
// arising out of, the furnishing, performance or use of the contents of the
// CD-ROM.
// ----------------------------------------------------------------------------

#ifndef TBV_ETHERPKT_H 
#define TBV_ETHERPKT_H

#include "tbvPkt.h"


#ifndef ETHER_ADDR_LEN
#define ETHER_ADDR_LEN 2
#endif

class tbvEtherPktT : public tbvPktT {
public:
  //
  // constructors
  //
  tbvEtherPktT(int size = RAND_SIZE, 
 	       const tbvSmartArrayT<tbvSmartUnsignedT, ETHER_ADDR_LEN> * daP = NULL, 
 	       const tbvSmartArrayT<tbvSmartUnsignedT, ETHER_ADDR_LEN> * saP = NULL, 
	       const tbvControlDataT * controlP = NULL,
	       const char * nameP = NULL);
  tbvEtherPktT(const char* payload, 
 	       const tbvSmartArrayT<tbvSmartUnsignedT, ETHER_ADDR_LEN> * daP = NULL, 
 	       const tbvSmartArrayT<tbvSmartUnsignedT, ETHER_ADDR_LEN> * saP = NULL, 
	       const tbvControlDataT * controlP = NULL,
	       const char * nameP = NULL);
  tbvEtherPktT(const vector<uint8> & payload, 
 	       const tbvSmartArrayT<tbvSmartUnsignedT, ETHER_ADDR_LEN> * daP = NULL, 
 	       const tbvSmartArrayT<tbvSmartUnsignedT, ETHER_ADDR_LEN> * saP = NULL, 
	       const tbvControlDataT * controlP = NULL,
	       const char * nameP = NULL);
  tbvEtherPktT(const vector<uint8> & header, 
               const vector<uint8> & payload, 
	       const tbvControlDataT * controlP = NULL,
	       const char * nameP = NULL);
  tbvEtherPktT(const vector<uint8> & header, 
               const char * payload, 
	       const tbvControlDataT * controlP = NULL,
	       const char * nameP = NULL);
  
  // destructor
  virtual ~tbvEtherPktT();

  // copy constructor
  tbvEtherPktT(const tbvEtherPktT & rhs,
	       const char * nameP = NULL);
  
  // field constructor
  tbvEtherPktT(const tbvSmartDataT * parentP, const char * nameP = NULL,
	       bool derived = false);

  // assign operator
  tbvEtherPktT & operator=(const tbvEtherPktT & rhs);

  // override the get header and trailer method to implement the Ethernet format
  virtual vector<uint8> 	getHeader();
					//get the header of the packet 
  virtual vector<uint8> 	getTrailer();
					//get the trailer of the packet 

  //access functions
  tbvSmartUnsignedT &			getLength();
  tbvSmartArrayT<tbvSmartUnsignedT, ETHER_ADDR_LEN> &	getDA;
  tbvSmartArrayT<tbvSmartUnsignedT, ETHER_ADDR_LEN> &	getSA;
  int					getChecksum();

  //override the randomize method so that the lenth of data field, pad and
  //checksum can be adjusted according to the data.
  virtual void randomPayload(int sz = 0);
				//changing _len and _csum according to data

protected:

  // override the create header, payload, tailer methods for ethernet format
  virtual void			createHeader(const vector<uint8> & header);
  virtual void			createPayload(const vector<uint8> & payload);
  virtual void			createTrailer(const vector<uint8> & trailer);

private:

  tbvSmartUnsignedT				_len;
  tbvSmartArrayT<tbvSmartUnsignedT, ETHER_ADDR_LEN>	_da;
  tbvSmartArrayT<tbvSmartUnsignedT, ETHER_ADDR_LEN>	_sa;
  int					_csum;
  
  int 			crc32();
  void 			setup();
  void			wrapup();

};  

#endif // class tbvEtherPktT
