// ----------------------------------------------------------------------------
// (c) Copyright 2005, Springer.  All Rights Reserved. The code in this CD-ROM is
// distributed by Springer with ABSOLUTELY NO SUPPORT and NO WARRANTY from
// Springer. Use or reproduction of the information provided on this code for
// commercial gain is strictly prohibited. Explicit permission is given for the
// reproduction and use of this information in an instructional setting provided
// proper reference is given to the original source.
//
// Authors and Springer shall not be liable for damage in connection with, or
// arising out of, the furnishing, performance or use of the contents of the
// CD-ROM.
// ----------------------------------------------------------------------------

#include "tbvMPLS.h"


/**************************************************************************/
tbvMPLST::tbvMPLST(const char * nameP = NULL) :
	       tbvSmartRecordT(nameP),
	       label(this,"MPLS label",true),
               qos(this, "MPLS qos", true),
	       stack(this, "MPLS stack", true),
	       ttl(this, "MPLS time to live", true) { setup(); }


/**************************************************************************/
tbvMPLST::tbvMPLST(vector<uint8> & mpls, const char * nameP = NULL) :
	       tbvSmartRecordT(nameP),
	       label(this,"MPLS label",true),
               qos(this, "MPLS qos", true),
	       stack(this, "MPLS stack", true),
	       ttl(this, "MPLS time to live", true) 
{ 
  setup(); 
  setMPLS(mpls);
}


/**************************************************************************/
tbvMPLST::tbvMPLST(const tbvMPLST & rhs, const char * nameP = NULL) :
	       tbvSmartRecordT(RECORD, nameP, &rhs),
	       label(this,"MPLS label",true),
               qos(this, "MPLS qos", true),
	       stack(this, "MPLS stack", true),
	       ttl(this, "MPLS time to live", true) {operator=(rhs);setup(); }

/**************************************************************************/
tbvMPLST::tbvMPLST(const tbvSmartDataT * parentP, const char * nameP = NULL,
		       bool derived = false) :
	       tbvSmartRecordT(parentP, nameP, derived),
	       label(this,"MPLS label",true),
               qos(this, "MPLS qos", true),
	       stack(this, "MPLS stack", true),
	       ttl(this, "MPLS time to live", true) { setup(); }


/**************************************************************************/
tbvMPLST & tbvMPLST::operator=(const tbvMPLST & rhs)
{
  tbvSmartRecordT::operator=(rhs); 
  return *this;
}


/**************************************************************************/
tbvMPLST * tbvMPLST::duplicate(const char * nameP = NULL) const
{
  return new tbvMPLST(*this, nameP);
}


/**************************************************************************/
tbvMPLST * tbvMPLST::duplicate(const tbvSmartDataT * parentP,
				   const char * nameP = NULL,
				   bool derived = false) const
{
  tbvMPLST * a = new tbvMPLST(parentP, nameP, derived);
  *a = *this;
  return a;
}


/**************************************************************************/
tbvMPLST::~tbvMPLST() { wrapup(); }


/**************************************************************************/
void tbvMPLST::setup() { 

  label.keepOnly(0,0xFFFFF);
  qos.keepOnly(0,7);
  stack.keepOnly(0,1);
  ttl.keepOnly(0,0xFF);
  
}


/**************************************************************************/
void tbvMPLST::wrapup() { } 


/**************************************************************************/
vector<uint8>  tbvMPLST::getMPLS() const
{ 
  vector<uint8>  mpls(4,0);
  mpls[3] = ttl;
  mpls[2] = (stack & 0x1) | ((qos & 0x7) << 1) | ((label & 0xf) << 4);  
  mpls[1] = (label & 0xff0 ) >> 4;
  mpls[0] = (label & 0xff000) >> 12;

  return mpls;
} 

/**************************************************************************/
void  tbvMPLST::setMPLS(vector<uint8> & mpls)
{ 
  uint8 data;

  ttl = mpls[3];
  data = mpls[2];
  stack = data & 0x1;
  qos = (data >> 1) & 0x7;
  label = (mpls[0] << 12) | (mpls[1] << 4) | (data >> 4);
}
