// ----------------------------------------------------------------------------
// (c) Copyright 2005, Springer.  All Rights Reserved. The code in this CD-ROM is
// distributed by Springer with ABSOLUTELY NO SUPPORT and NO WARRANTY from
// Springer. Use or reproduction of the information provided on this code for
// commercial gain is strictly prohibited. Explicit permission is given for the
// reproduction and use of this information in an instructional setting provided
// proper reference is given to the original source.
//
// Authors and Springer shall not be liable for damage in connection with, or
// arising out of, the furnishing, performance or use of the contents of the
// CD-ROM.
// ----------------------------------------------------------------------------

#ifndef TBV_MPLS_H 
#define TBV_MPLS_H

#include "TestBuilder.h"


typedef tbvUByteT uint8;

class tbvMPLST : public tbvSmartRecordT {
public:
  //
  // constructors
  //
  tbvMPLST(const char * nameP = NULL);
  tbvMPLST(vector<uint8> & mpls, const char * nameP = NULL);
  tbvMPLST(const tbvMPLST & rhs, const char * nameP = NULL);
  virtual ~tbvMPLST();

  //field constructor
  tbvMPLST(const tbvSmartDataT * parentP, const char * nameP = NULL,
	     bool derived = false);

  //assignment operator
  tbvMPLST & operator=(const tbvMPLST & rhs);

  //duplicate function
  virtual tbvMPLST * duplicate(const char * nameP = NULL) const;
  virtual tbvMPLST * duplicate(const tbvSmartDataT * parentP,
				 const char * nameP = NULL,
				 bool derived = false) const;

  // data access methods
  vector<uint8>  	getMPLS() const;
				//return the mpls in bytes
  void		  	setMPLS(vector<uint8> & mpls);

  tbvSmartUnsignedT		label;
				//the label field, it is 20 bits 
  tbvSmartUnsignedT		qos;
				//the experimental field, it is 3 bits 
  tbvSmartUnsignedT		stack;
				//the stack field, it is 1 bits 
  tbvSmartUnsignedT		ttl;
				//time to live field, it is 8 bits 


private:

  void 			setup();
  void			wrapup();

};  

#endif // class tbvMPLST
