// ----------------------------------------------------------------------------
// (c) Copyright 2005, Springer.  All Rights Reserved. The code in this CD-ROM is
// distributed by Springer with ABSOLUTELY NO SUPPORT and NO WARRANTY from
// Springer. Use or reproduction of the information provided on this code for
// commercial gain is strictly prohibited. Explicit permission is given for the
// reproduction and use of this information in an instructional setting provided
// proper reference is given to the original source.
//
// Authors and Springer shall not be liable for damage in connection with, or
// arising out of, the furnishing, performance or use of the contents of the
// CD-ROM.
// ----------------------------------------------------------------------------

#include "tbvMonitorTask.h"

vector <uint8> tbvMonitorTaskT::readBus(tbvSignalHdlT &data, tbvSignalHdlT &clk, tbvSignalHdlT &eob, tbvSignalHdlT *byte_enableP = NULL) {
    unsigned int bitsInBus = data.msb()-data.lsb()+1;
    unsigned int bytesInBus = bitsInBus/8;
    vector <uint8> byte_en(bytesInBus,1);
    vector <uint8> celldata(80);
    unsigned int dataRead = 0;
       

//wait while EOB is not set
    while (((eob.getValue()) != 1) && (dataRead < 72))
        {
            for (unsigned int i = 0; i < bytesInBus; i++)
                {
                    if (byte_en[i] == 1)
                        {
                            celldata[dataRead] = (data(bitsInBus -(8*i) - 1,
                                                        bitsInBus -(8*i) - 8).getValue());
                            dataRead++;
                        }
        
                }
            tbvWaitCycle(clk, tbvThreadT::POSEDGE);


        }

    byte_en = getByteEnable(byte_enableP);
    for (unsigned int i = 0; i < bytesInBus; i++)
        {
            if (byte_en[i] == 1)
                {
                    celldata[dataRead] = (data(bitsInBus -(8*i) - 1,
                                                bitsInBus -(8*i) - 8).getValue());
                    dataRead++;
                }
        }
    celldata.resize(dataRead);
    return celldata;
}

vector<uint8> tbvMonitorTaskT::getByteEnable(tbvSignalHdlT *byte_enableP) {
    vector<uint8> byte_en(8,1);
    if(byte_enableP)
        switch ((byte_enableP->getValue())){
        case 0 : byte_en[0] = 1;byte_en[1] = 1;byte_en[2] = 1;byte_en[3] = 1;
            byte_en[4] = 1;byte_en[5] = 1;byte_en[6] = 1;byte_en[7] = 1; break;
        case 1 : byte_en[0] = 1;byte_en[1] = 0;byte_en[2] = 0;byte_en[3] = 0;
            byte_en[4] = 0;byte_en[5] = 0;byte_en[6] = 0;byte_en[7] = 0; break;
        case 2 : byte_en[0] = 1;byte_en[1] = 1;byte_en[2] = 0;byte_en[3] = 0;
            byte_en[4] = 0;byte_en[5] = 0;byte_en[6] = 0;byte_en[7] = 0; break;
        case 3 : byte_en[0] = 1;byte_en[1] = 1;byte_en[2] = 1;byte_en[3] = 0;
            byte_en[4] = 0;byte_en[5] = 0;byte_en[6] = 0;byte_en[7] = 0; break;
        case 4 : byte_en[0] = 1;byte_en[1] = 1;byte_en[2] = 1;byte_en[3] = 1;
            byte_en[4] = 0;byte_en[5] = 0;byte_en[6] = 0;byte_en[7] = 0; break;
        case 5 : byte_en[0] = 1;byte_en[1] = 1;byte_en[2] = 1;byte_en[3] = 1;
            byte_en[4] = 1;byte_en[5] = 0;byte_en[6] = 0;byte_en[7] = 0; break;
        case 6 : byte_en[0] = 1;byte_en[1] = 1;byte_en[2] = 1;byte_en[3] = 1;
            byte_en[4] = 1;byte_en[5] = 1;byte_en[6] = 0;byte_en[7] = 0; break;
        case 7 : byte_en[0] = 1;byte_en[1] = 1;byte_en[2] = 1;byte_en[3] = 1;
            byte_en[4] = 1;byte_en[5] = 1;byte_en[6] = 1;byte_en[7] = 0; break;
        }
    return byte_en;
}
tbvSignalHdlT & tbvMonitorTaskT::getClk(){
	return * clk;
}

void tbvMonitorTaskT::setInputFile(char *filename) {
    if (filename) {
        inputStream.open(filename);
        readInput = true;
    }
}

void tbvMonitorTaskT::setOutputFile(char *filename) {
    if (filename) {
        outputStream.open(filename);
        writeOutput = true;
    }
}

void tbvMonitorTaskT::readCell(tbvDataComPtrT x) {
    if (readInput) {
        if (inputStream) {
            if (x) {
                inputStream >> *x;
            } else {
                tbvOut << "x == NULL in tbvMonitorTaskT::readCell()" << endl;
            }
        } else {
            tbvOut << "inputStream is broken" << endl;
        }
    }
}


void tbvMonitorTaskT::writeCell(tbvDataComPtrT x) {
    if (writeOutput && outputStream) {
       printDatacom(outputStream, *x);
    }
}

void tbvMonitorTaskT::body(tbvCellT *cellPtr) {
    if (readInput) {
        if (inputStream) {
            if (!inputStream.eof()) {
                readCell(cellPtr);
                writeCell(cellPtr);
                return;
            }
        } else {
            if (inputStream.eof()) {
                tbvOut << "End of file for " << getNameP() << endl;
                cellPtr->setValid(0);
            } else {
                // throw exception here
                tbvOut << "Error in inputStream" << endl;
                cellPtr->setValid(0);
            }
        }
    } else {
        monitorBody(cellPtr);
        if (writeOutput) {
            writeCell(cellPtr);
        }
    }
}

void tbvMonitorTaskT::disableException(const char *exceptionString) {
  string expStr(exceptionString);
  exceptionDisable.insert(expStr);
}

void tbvMonitorTaskT::disableException() {
  exceptionDisableAll = 1;
}

void tbvMonitorTaskT::restoreException(const char *exceptionString) {
  string expStr(exceptionString);
  exceptionDisable.erase(expStr);
}

void tbvMonitorTaskT::restoreException() {
  exceptionDisableAll = 0;
}

void tbvMonitorTaskT::disableExitOnException(const char *exceptionString) {
  string expStr(exceptionString);
  exceptionExitDisable.insert(expStr);
}

void tbvMonitorTaskT::disableExitOnException() {
  exceptionExitDisableAll = 1;
}

void tbvMonitorTaskT::restoreExitOnException(const char *exceptionString) {
  string expStr(exceptionString);
  exceptionExitDisable.erase(expStr);
}

void tbvMonitorTaskT::restoreExitOnException() {
  exceptionExitDisableAll = 0;
}

void tbvMonitorTaskT::setUserExceptionTypeString(const char *exceptionString) {
  tbvExceptionT::setUserExceptionTypeString(exceptionString);
}

void tbvMonitorTaskT::reportUserException( const char *exceptionString,
					   tbvExceptionT::severityLevelT sevLevel,
					   const char *messageString) {
  string expStr(exceptionString);
  if((exceptionDisable.find(expStr) == exceptionDisable.end()) && !exceptionDisableAll) {
    tbvExceptionT::reportUserException(exceptionString, sevLevel, messageString);
    if((exceptionExitDisable.find(expStr) == exceptionExitDisable.end()) && !exceptionExitDisableAll)
      tbvExit();
  }
}

