// ----------------------------------------------------------------------------
// (c) Copyright 2005, Springer.  All Rights Reserved. The code in this CD-ROM is
// distributed by Springer with ABSOLUTELY NO SUPPORT and NO WARRANTY from
// Springer. Use or reproduction of the information provided on this code for
// commercial gain is strictly prohibited. Explicit permission is given for the
// reproduction and use of this information in an instructional setting provided
// proper reference is given to the original source.
//
// Authors and Springer shall not be liable for damage in connection with, or
// arising out of, the furnishing, performance or use of the contents of the
// CD-ROM.
// ----------------------------------------------------------------------------

#include "tbvSar.h"

void rcs_tbvSar_cc() { tbvOut << "$Id:$" << endl; }


/**************************************************************************/
tbvPktT tbvSarT::tbvCellToPkt(tbvPriorityListT<tbvCellT> * cells, const char * nameP = NULL) 
{
  /* Constructs packet from list of tbvCells.The pointer to tbvPriorityListT<tbvCellT> that
     is passed as argument must be deleted by caller.
  */
  vector<uint8> payload;
  vector<uint8> vtmp;
  tbvControlDataT control;
  tbvCellT cell(0);
  tbvCellT firstcell(0);
  tbvCellT lastcell(0);
  bool validPkt = true;
			//a valid packet must have: the first cell has sop,
			//none of the other cells should have sop. The last
			//cell has eop, none of the other cells should have 
			//eop. The fid of the cells should be the same. 
			//If there is a sequence number, the sequence number
			//should be continuous.
			//most of the fields of the control data should be the 
			//same for all the cells, except sop, eop, sob, eob, sequence number.
  bool has_sop = false;
  bool has_eop = false;
  unsigned int sequence_num;
  tbvListT<CONTROL_FIELD_TYPE> invalid_fields;

  invalid_fields.pushBack(SEQUENCE_NUMBER);
  invalid_fields.pushBack(SOP);
  invalid_fields.pushBack(EOP);
  invalid_fields.pushBack(SOB);
  invalid_fields.pushBack(EOB);
  invalid_fields.pushBack(BAD);
  invalid_fields.pushBack(QOS);
  invalid_fields.pushBack(FID);
  invalid_fields.pushBack(TRAFFIC_TYPE);
  
  firstcell = cells->front();
  cells->popFront();
  if (firstcell.getSOP().getUnsignedValue() != 1) 
  {
    tbvExceptionT::setUserExceptionTypeString("NO_SOP");
    tbvExceptionT::reportUserException("NO_SOP",
					tbvExceptionT::WARNING,
					"no sop for the list of the cells");
    validPkt = false;
  }
  else
  {
    has_sop = true;
  }
  if (firstcell.getEOP().getUnsignedValue() == 1)  has_eop = true;
  sequence_num = firstcell.getSN();
  payload = firstcell.getPayload();
  while (cells->size() > 0)
  {
    cell = cells->front();
    cells->popFront(); 

    if (!cell.isControlEqual(firstcell, invalid_fields, false))
    {
      tbvExceptionT::setUserExceptionTypeString("INCONSISTENT_CONTROL_DATA");
      tbvExceptionT::reportUserException("INCONSISTENT_CONTROL_DATA",
                                          tbvExceptionT::WARNING,
                                          "the cells' control data is inconsistent");
      validPkt = false;
    }
				//check the control data consistence

    if (cell.getSOP().getUnsignedValue() == 1)
    {
      if (has_sop)
      {
        tbvExceptionT::setUserExceptionTypeString("MULTIPLE_SOP");
        tbvExceptionT::reportUserException("MULTIPLE_SOP",
 					    tbvExceptionT::WARNING,
					    "multiple sops in the cells");
      }
      else
      {
        tbvExceptionT::setUserExceptionTypeString("WRONG_SOP_POSITION");
        tbvExceptionT::reportUserException("WRONG_SOP_POSITION",
 					    tbvExceptionT::WARNING,
					    "sop position is wrong in the cells");
        has_sop = true;
      }
      validPkt = false;
    }
				//check the sop

    if (cell.getEOP().getUnsignedValue() == 1 && cells->size() > 0)
				//cell has eop and is not last cell
    {
      if (has_eop)
      {
        tbvExceptionT::setUserExceptionTypeString("MULTIPLE_EOP");
        tbvExceptionT::reportUserException("MULTIPLE_EOP",
 					    tbvExceptionT::WARNING,
					    "multiple eops in the cells");
      }
      else
      {
        tbvExceptionT::setUserExceptionTypeString("WRONG_EOP_POSITION");
        tbvExceptionT::reportUserException("WRONG_EOP_POSITION",
 					    tbvExceptionT::WARNING,
					    "eop position is wrong in the cells");
        has_eop = true;
      }
      validPkt = false;
    }
    else if (cell.getEOP().getUnsignedValue() == 1 && cells->size() == 0)
				//cell has eop and is last cell
    {
      if (has_eop)
      {
        tbvExceptionT::setUserExceptionTypeString("MULTIPLE_EOP");
        tbvExceptionT::reportUserException("MULTIPLE_EOP",
 					    tbvExceptionT::WARNING,
					    "multiple eops in the cells");
        validPkt = false;
      }
    }
    else if (cell.getEOP().getUnsignedValue() == 0 && cells->size() == 0)
				//cell does not have eop and is last cell
    {
      tbvExceptionT::setUserExceptionTypeString("NO_EOP");
      tbvExceptionT::reportUserException("NO_EOP",
 					  tbvExceptionT::WARNING,
					  "no eop in the last cell");
      validPkt = false;
    }
      
				//check the eop

    if (cell.getSN().getUnsignedValue() != ++sequence_num)
    {
      tbvExceptionT::setUserExceptionTypeString("SEQUENCE_NUMBER_DISCONTINUED");
      tbvExceptionT::reportUserException("SEQUENCE_NUMBER_DISCONTINUED",
 					  tbvExceptionT::WARNING,
					  "sequence number %d is not contineous", cell.getSN().getUnsignedValue());
      validPkt = false;
    }
				//check the sequence number
    
    vtmp = cell.getPayload();
    payload.insert(payload.end(), vtmp.begin(), vtmp.end());
  }

  control = firstcell.getControlData();
  if (validPkt)
  {
    control.valid = 1;
  }
  else
  {
    control.valid = 0;
  }
  return tbvPktT(payload, &control);
}


/**************************************************************************/
int tbvSarT::SNPriority(const tbvCellT & a, const tbvCellT & b)
{
/*
  According to tests builder reference manual:
  Priority function takes two arguments.It returns
  . A +ve integer if the first element has higher priority than the second element
  . 0 if the two elements have same priority
  . A -ve integer if the second element has higher priority than first element.

  In our case: 

  Higher the SN lower the priority.That is why  returns positive value if a < b
*/
  return a.getSN().getUnsignedValue() < b.getSN().getUnsignedValue();
}

 
/**************************************************************************/
tbvPriorityListT<tbvCellT> * tbvSarT::tbvPktToCell(tbvPktT &pkt,tbvSmartUnsignedT & sizeOfCell){
  /* Splits pkt to cells,return pointer to tbvPriorityListT<tbvCellT> 
     which must be deleted by caller
  */
  tbvPriorityListT<tbvCellT> * returnList = new tbvPriorityListT<tbvCellT>("returnList", tbvDataStructureT::CUSTOM_FIFO, tbvSarT::SNPriority);
  tbvControlDataT controlData = pkt.getControlData();
  controlData.sop = 0;
  controlData.eop = 0;
  
  vector<uint8> packetData(pkt.getData());
  unsigned int pointerPD = 0;

  vector<uint8> payload;
  
  vector<uint8>::iterator startIter = packetData.begin() + pointerPD;
  vector<uint8>::iterator intermediateIter = startIter + sizeOfCell.getUnsignedValue();
  int i = 0;
  while((packetData.size()-pointerPD)>0){
	sizeOfCell.randomize();
	if(int(packetData.size() - pointerPD) <=(int)sizeOfCell)
                sizeOfCell = packetData.size() - pointerPD;

        startIter =  packetData.begin() + pointerPD;
        intermediateIter = startIter + sizeOfCell.getUnsignedValue();
	payload.clear();
        payload.insert(payload.begin(), startIter, intermediateIter);
	controlData.SN = i;
	++i;
	tbvCellT * newCellP = new tbvCellT(payload, &controlData);
	returnList->push(*newCellP);
	pointerPD += sizeOfCell.getUnsignedValue();
	delete newCellP;
  }


  if((pointerPD) != unsigned(pkt.getSize())){
    tbvExceptionT::setUserExceptionTypeString("INVALID LENGTH");
    tbvExceptionT::reportUserException("INVALID LENGTH",
				       tbvExceptionT::WARNING,
				       "all data in packet not segmented");
  }

  returnList->begin()->setSOP(1);
  tbvPriorityListT<tbvCellT>::iteratorT returnIter = returnList->end();
  --returnIter;
  returnIter->setEOP(1);
  tbvListT <tbvSmartUnsignedT> bidList = pkt.getBidList();
  if(bidList.size() == returnList->size())
    { 
     tbvListT <tbvSmartUnsignedT> bidNew;
     tbvListT <tbvSmartUnsignedT>::iteratorT bidListIter;

     for(returnIter = returnList->begin(), bidListIter = bidList.begin(); 
         returnIter != returnList->end(); returnIter++, bidListIter++)
       {
        bidNew.pushBack(*bidListIter);
        returnIter->setBidList(bidNew);
        bidNew.clear();
       }
    }
  return(returnList);
}

tbvPriorityListT<tbvCellT> * tbvSarT::tbvPktToCell(tbvPktT &pkt, unsigned int sizeCell)
{
  tbvSmartUnsignedT _sizeCell("_sizeCell"), _numCell("_numCell");
  _sizeCell.keepOnly(int(sizeCell));

  _numCell.keepOnly(int(ceil(pkt.getSize()/((sizeCell+1.0)-1.0))));

 #if 0
 tbvOut << "tbvSar: _numCell = " << _numCell <<endl ;
#endif

  _sizeCell.randomize();
  _numCell.randomize();
 return tbvPktToCell(pkt, _sizeCell);
}


tbvPriorityListT<tbvCellT>  tbvSarT::removeAAL5Trailer(tbvPriorityListT<tbvCellT> &origList){
tbvPriorityListT<tbvCellT> returnList(origList);
return returnList;
}


tbvPriorityListT<tbvCellT> * tbvSarT::addAAL5Trailer(tbvPriorityListT<tbvCellT> *origList,unsigned int sizeCell)
{ 
  return addAAL5Trailer(origList, sizeCell, -1); // aal5Length < 0 is ignored and the correct packet size is used
}
tbvPriorityListT<tbvCellT> * tbvSarT::addAAL5Trailer(tbvPriorityListT<tbvCellT> *origList,unsigned int sizeCell, int aal5Length, bool crc32Error = false)
{ 
crc32<uint8, uint32> AAL5CRC;
uint32 crcAccumulator = 0xFFFFFFFF;
unsigned int packetSize = 0;
tbvControlDataT control;
tbvPriorityListT<tbvCellT> * returnList = new tbvPriorityListT<tbvCellT>(*origList);
tbvPriorityListT<tbvCellT>::iteratorT  lastCellIter = returnList->end();

tbvPriorityListT<tbvCellT>::iteratorT returnIter;
for (returnIter = returnList->begin(); returnIter != lastCellIter; returnIter++)
{ vector <uint8> temp = returnIter->getPayload(); 
  #if 0 
	tbvOut<<"temp"<<temp<<endl;
  #endif
  packetSize+=temp.size();
  #if 0 
	tbvOut<<"pkt size"<<temp.size()<<endl;
  #endif
  temp = returnIter->getData();
  for(unsigned int i = 0; i < temp.size(); i++){
      crcAccumulator = AAL5CRC(temp[i], crcAccumulator);
  }
}
--lastCellIter;
unsigned int cellSize = sizeCell;
unsigned int payloadSize = lastCellIter->getPayloadSize();

#if 0 
tbvOut << "tbvSar: fid = " << lastCellIter->getFid().fid
       << " cellSize = " << cellSize
       << " payloadSize = " << payloadSize 
       << "cellSize"<<cellSize<<endl;
#endif
    
if(payloadSize > (cellSize - 8)) {

    // creating a new cell

 vector <uint8> newCell(cellSize,0);
 vector <uint8> temp = lastCellIter->getPayload();
 unsigned int runtSize = temp.size();
 temp.resize(cellSize);

 //packetSize+= runtSize;
 for(unsigned int i =runtSize;i < temp.size();++i){
	 crcAccumulator = AAL5CRC(temp[i],crcAccumulator);
 } 

 if (aal5Length >= 0) // Introduce erroneous packet length in AAL5 trailer
   packetSize = aal5Length;
 newCell[newCell.size() - 5] = (packetSize & 0x000000ff); 
 newCell[newCell.size() - 6] = (packetSize >> 8) & 0x000000ff;
 newCell[newCell.size() - 7] = 0xaa;
 newCell[newCell.size() - 8] = 0xbb;
 for(unsigned int i = 0; i < newCell.size()-4; i++) {
   crcAccumulator = AAL5CRC(newCell[i], crcAccumulator);
 }
 crcAccumulator = 0xffffffff-crcAccumulator;
 newCell[newCell.size() - 1] = (crcAccumulator & 0x000000ff); 
 newCell[newCell.size() - 2] = (crcAccumulator & 0x0000ff00) >> 8;
 newCell[newCell.size() - 3] = (crcAccumulator & 0x00ff0000) >> 16; 
 newCell[newCell.size() - 4] = (crcAccumulator & 0xff000000) >> 24;
 if (crc32Error) {
   newCell[newCell.size() - 4] = newCell[newCell.size() - 4] ^ 0x10101010;
 }

 control = lastCellIter->getControlData();
 tbvCellT oldLastCell(temp, &control);
 control.sop=0;
 tbvCellT newLastCell(newCell, &control) ;
 newLastCell.setSN(lastCellIter->getSN() + 1);
 *lastCellIter = oldLastCell;
 lastCellIter->setEOP(0);
 returnList->push(newLastCell); 

#if 0 
  tbvOut << "tbvSar: packetSize = " << packetSize << ", CRC = " << crcAccumulator << endl;
 tbvOut << "tbvSar: adding new cell to fid "<< newLastCell.getFid().fid << endl;
#endif 

}


else
//This is for using the last cell(data+pad) and replacing it with 
//cell + AAL5 Trailer 
{

  vector <uint8> newCell =  lastCellIter->getPayload();

 uint32 oldCellSize = newCell.size();
 if (aal5Length >= 0) // Introduce erroneous packet length in AAL5 trailer
   packetSize = aal5Length;
 newCell.resize(cellSize);
 newCell[cellSize - 5] = (packetSize & 0x000000ff); 
 newCell[cellSize - 6] = (packetSize >> 8) & 0x000000ff;

 newCell[cellSize - 7] = (packetSize & 0x000000ff);
 newCell[cellSize - 8] = (packetSize >> 8) & 0x000000ff;


 //only compute the crc for the padding and length
for (unsigned int i = oldCellSize; i < newCell.size()-4; i++){
    crcAccumulator = AAL5CRC(newCell[i], crcAccumulator);
}
crcAccumulator = 0xffffffff-crcAccumulator;
 newCell[cellSize - 1] = (crcAccumulator & 0x000000ff); 
 newCell[cellSize - 2] = (crcAccumulator & 0x0000ff00) >> 8;
 newCell[cellSize - 3] = (crcAccumulator & 0x00ff0000) >> 16; 
 newCell[cellSize - 4] = (crcAccumulator & 0xff000000) >> 24;
 if (crc32Error) {
   newCell[newCell.size() - 4] = newCell[newCell.size() - 4] ^ 0x10101010;
 }

 #if 0
tbvOut << "tbvSar: packetSize = " << packetSize << ", CRC = " << crcAccumulator << endl;
 #endif

    control = lastCellIter->getControlData();
  tbvCellT newLastCell(newCell, &control) ;
  *lastCellIter = newLastCell;
}

return returnList;
}

tbvPriorityListT<tbvCellT> * tbvSarT::tbvPktToAAL5Cell(tbvPktT &pkt, tbvCellT*  cellPrototype) {
  return tbvPktToAAL5Cell(pkt,cellPrototype,pkt.getSize());
}
tbvPriorityListT<tbvCellT> * tbvSarT::tbvPktToAAL5Cell(tbvPktT &pkt, tbvCellT*  cellPrototype, unsigned aal5Length, bool crc32Error = false) {
   # if 0 
	tbvOut<<"Fid in pkt"<<pkt.getFid()<<endl;
   #endif

    tbvSmartUnsignedT sizeCell("sizeCell");
    tbvPriorityListT <tbvCellT> * _cellList(tbvSarT::tbvPktToCell(pkt,cellPrototype->getPayloadSize()));
    tbvPriorityListT <tbvCellT> * cellList(tbvSarT::addAAL5Trailer(_cellList,cellPrototype->getPayloadSize(), aal5Length, crc32Error));
    delete _cellList;
    tbvPriorityListT <tbvCellT> * returnList = new tbvPriorityListT <tbvCellT>("returnList", tbvDataStructureT::CUSTOM_FIFO, tbvSarT::SNPriority);;
    tbvPriorityListT <tbvCellT>::iteratorT returnIter;
    tbvPriorityListT <tbvCellT>::iteratorT cellIter;
    tbvCellT newCell(0);
    tbvCellT* duplicateCell = cellPrototype->duplicate();
    for(cellIter = cellList->begin(); cellIter != cellList->end(); cellIter++)
        {
            duplicateCell->convertFrom(&(*cellIter), ADD);
            newCell.convertFrom(duplicateCell, ADD);
            returnList->push(newCell);
        }
    delete cellList;
    delete duplicateCell;
    returnIter = returnList->end();
    --returnIter;
    if(cellPrototype->getType() == ATM_CELL){
    	tbvPriorityListT<tbvCellT>::iteratorT returnIter;
    	tbvPriorityListT <tbvCellT>::iteratorT cellIterEnd = returnList->end();
    	tbvPriorityListT <tbvCellT>::iteratorT cellIter = returnList->end();
    	--cellIter;
    	for(returnIter = returnList->begin();returnIter !=cellIterEnd;returnIter++){
		tbvATMCellT ptiCell;
                if(cellPrototype->isHec()){
                  ptiCell.setHec();
                }
		ptiCell.convertFrom(&(*returnIter),DOWN);
                ptiCell.setControlData(cellPrototype->getControlData());
                
		if(returnIter == cellIter){
		  ptiCell.setPTI(ptiCell.getPTI() | 0x01); // AAL5 EOP is 1
                }
		else {
		  ptiCell.setPTI(ptiCell.getPTI() & 0x6); // AAL5 EOP is 0
		}
 		if(cellPrototype->getSOP() == 0 && cellPrototype->getEOP() ==0){
			tbvINTCellT ptiIntCell; 
			ptiIntCell.convertFrom(&ptiCell,UP);
			tbvCellT newPtiCell(0);
			newPtiCell.convertFrom(&ptiIntCell,UP);
			*returnIter = newPtiCell;
		}else{
                	tbvCellT newPtiCell(0);
                	newPtiCell.convertFrom(&ptiCell,ADD);
			*returnIter = newPtiCell;
		}
        }
    }
    tbvPriorityListT <tbvCellT>::iteratorT returnIterBegin = returnList->begin();
    tbvPriorityListT <tbvCellT>::iteratorT returnIterEnd = returnList->end();
    --returnIterEnd;
		(*returnIterBegin).setSOP(1);
		(*returnIterEnd).setEOP(1);
    //This is to set SOP at beginning and EOP at end 
    return(returnList);
    
}

tbvPriorityListT<tbvCellT> * tbvSarT::tbvPktToAAL5ATMCell(tbvPktT &pkt, tbvATMCellT*  cellPrototype) {
    tbvPriorityListT <tbvCellT> * cellList( tbvSarT::tbvPktToAAL5Cell(pkt,cellPrototype));
    tbvPriorityListT<tbvCellT>::iteratorT returnIter;
    tbvPriorityListT<tbvCellT> * returnList = new tbvPriorityListT<tbvCellT>(*cellList);
    delete cellList;
    tbvPriorityListT <tbvCellT>::iteratorT cellIter = returnList->end();
    tbvPriorityListT <tbvCellT>::iteratorT cellIterEnd = returnList->end();
    --cellIter;
    for(returnIter = returnList->begin();returnIter !=cellIterEnd;returnIter++){
	
    	tbvATMCellT ptiCell;
    	ptiCell.convertFrom(&(*returnIter),DOWN);   
	if(returnIter == cellIter){
        ptiCell.setPTI(ptiCell.getPTI() | 0x01);
	}
    	tbvCellT newPtiCell(0);
    	newPtiCell.convertFrom(&ptiCell,ADD);
    	*returnIter = newPtiCell;
   }
    return returnList;
}


tbvPriorityListT<tbvCellT> * tbvSarT::tbvSwitchPktToCell (tbvSwitchPktT &swPkt, unsigned int size) {

    vector<uint8> x = swPkt.getPayload();
    tbvPktT packet(x,&(swPkt.getControlData()));
  
    tbvPriorityListT<tbvCellT> * sw_pkt_list = tbvSarT::tbvPktToCell(packet, size);
 
    tbvSwitchCellT FrontCell;//(size+swPkt.getHeaderSize());
    FrontCell.setHeaderSize(swPkt.getHeaderSize());
    x = swPkt.getHeader();
    FrontCell.convertFrom(&(sw_pkt_list->front()), ADD, &x);
    FrontCell.setHeader(x);
    if(sw_pkt_list->size() != 1) //if there only one cell in list then sop,eop = 1
    	FrontCell.setEOP(0);    //otherwise eop = 0 for first cell
				//in tbvSwitchcellT it set eop,sop =1 always
  
    sw_pkt_list->popFront();
    tbvCellT newCell(0);
    newCell.convertFrom(&FrontCell, ADD);
    sw_pkt_list->push(newCell);
    return sw_pkt_list;
}

tbvPriorityListT<tbvCellT> * tbvSarT::tbvSwitchCellToCell(tbvPriorityListT <tbvCellT> * temp_sw_cell_list,tbvSwitchCellT* switchcellPrototype){
   tbvPriorityListT <tbvCellT> * sw_cell_list = new tbvPriorityListT <tbvCellT>(*temp_sw_cell_list);
   tbvSwitchCellT switchcell;
   switchcell.setHeaderSize(switchcellPrototype->getHeaderSize());
   vector<uint8>x = switchcellPrototype->getHeader();


   tbvPriorityListT <tbvCellT>::iteratorT switchcellIter = sw_cell_list->begin();
   tbvPriorityListT <tbvCellT>::iteratorT switchcellIterend = sw_cell_list->end();
   --switchcellIterend;
   tbvINTCellT intcell;
   while(switchcellIter!=sw_cell_list->end()){
         intcell.convertFrom(&(*switchcellIter),UP);
         *switchcellIter=intcell;
          ++switchcellIter;
   }
   switchcellIter = sw_cell_list->begin();     
   while(switchcellIter!=sw_cell_list->end()){
   	switchcell.convertFrom(&(*switchcellIter),UP);
    	tbvIngressSwitchHeaderT *ingHeader = new tbvIngressSwitchHeaderT();
	if(x.size() == 8)
        	ingHeader->setHdrSize(1);
	else
		ingHeader->setHdrSize(2);
      	ingHeader->setHeader(x);
        ingHeader->setSOP(0);
   	ingHeader->setEOP(0);
        if(switchcellIter == sw_cell_list->begin()){
          ingHeader->setSOP(1); 
        }else{
		if(switchcellIter == switchcellIterend){
			ingHeader->setEOP(1);
		}
        }
        
        if(sw_cell_list->size() == 1){
		ingHeader->setEOP(1);
	}
              
	switchcell.setHeader(ingHeader->getHeader());
        tbvCellT newCell(0);
        newCell.convertFrom(&switchcell,ADD);
        newCell.setSOP(1);
        newCell.setEOP(1);
        *switchcellIter = newCell;
        
        ++switchcellIter;
        delete ingHeader;
        
   }
   return sw_cell_list;
}
   
   
   
