// ----------------------------------------------------------------------------
// (c) Copyright 2005, Springer.  All Rights Reserved. The code in this CD-ROM is
// distributed by Springer with ABSOLUTELY NO SUPPORT and NO WARRANTY from
// Springer. Use or reproduction of the information provided on this code for
// commercial gain is strictly prohibited. Explicit permission is given for the
// reproduction and use of this information in an instructional setting provided
// proper reference is given to the original source.
//
// Authors and Springer shall not be liable for damage in connection with, or
// arising out of, the furnishing, performance or use of the contents of the
// CD-ROM.
// ----------------------------------------------------------------------------

#include "tbvSwitchPkt.h"


/**************************************************************************/
tbvSwitchPktT::tbvSwitchPktT(int size, const tbvControlDataT * controlP = NULL,
			   const char* nameP = NULL) :
	        tbvPktT(size, controlP, nameP)
{ 
  setup(); 
}


/**************************************************************************/
tbvSwitchPktT::tbvSwitchPktT(const vector<uint8> & payload,
			   const tbvControlDataT * controlP = NULL, 
    		   	   const char * nameP = NULL) :
	        tbvPktT(payload,controlP, nameP) 
{ 
  setup();
}


/**************************************************************************/
tbvSwitchPktT::tbvSwitchPktT(const char * payloadP, int sz,
			   const tbvControlDataT * controlP = NULL, 
    		   	   const char * nameP = NULL) :
	        tbvPktT(payloadP, sz, controlP, nameP) 
{ 
  setup();
}


/**************************************************************************/
tbvSwitchPktT::tbvSwitchPktT(const vector<uint8> & header,
			       const vector<uint8> & payload, 
		 	       const tbvControlDataT * controlP = NULL,
    		 	       const char * nameP = NULL) :
	        tbvPktT(payload, controlP, nameP)
{
  setup();
  setHeader(header);
} 


/**************************************************************************/
tbvSwitchPktT::tbvSwitchPktT(const char * headerP, int hsz,
			       const char * payloadP, int psz, 
		 	       const tbvControlDataT * controlP = NULL,
    		 	       const char * nameP = NULL) :
	        tbvPktT(payloadP, psz, controlP, nameP)
{
  setup();
  setHeader(headerP, hsz);
}


/**************************************************************************/
tbvSwitchPktT::tbvSwitchPktT(const tbvSwitchPktT & rhs, 
    		 const char * nameP = NULL) :
	         tbvPktT(nameP) { operator=(rhs); setup(); } 

/**************************************************************************/
tbvSwitchPktT::tbvSwitchPktT(const tbvPktT & rhs, 
    		 const char * nameP = NULL) :
	         tbvPktT(rhs, nameP) { operator=(rhs); setup(); } 

/**************************************************************************/
tbvSwitchPktT::tbvSwitchPktT(const tbvSmartDataT * parentP, const char * nameP = NULL,
		 bool derived = false) :
	       tbvPktT(parentP, nameP, derived) { setup(); }


/**************************************************************************/
tbvSwitchPktT & tbvSwitchPktT::operator=(const tbvSwitchPktT & rhs)
{
  tbvPktT::operator=(rhs);
  _header = rhs.getHeader();
  return *this;
}


/**************************************************************************/
tbvSwitchPktT * tbvSwitchPktT::duplicate(const char * nameP = NULL) const
{
  return new tbvSwitchPktT(*this, nameP);
}


/**************************************************************************/
tbvSwitchPktT * tbvSwitchPktT::duplicate(const tbvSmartDataT * parentP,
                                     const char * nameP = NULL,
                                     bool derived = false ) const
{
  tbvSwitchPktT * a = new tbvSwitchPktT(parentP, nameP, derived);
  *a = *this;
  return a;
}


/**************************************************************************/
tbvSwitchPktT::~tbvSwitchPktT() { wrapup(); }


/**************************************************************************/
void tbvSwitchPktT::setup() { }


/**************************************************************************/
void tbvSwitchPktT::wrapup() {}


/**************************************************************************/
vector<uint8>  tbvSwitchPktT::getHeader() const 
{
  vector<uint8>  headerP =  vector<uint8>(_header);
  return headerP;
}


/**************************************************************************/
void tbvSwitchPktT::setHeader(const char * headerP, int sz) 
{
  _header.erase(_header.begin(), _header.end());

  for (int i = 0; i < sz; i++)
  {
    _header.push_back((uint8) *headerP);
    headerP++;
  }
  setHeaderSize(sz);
}


/**************************************************************************/
void tbvSwitchPktT::setHeader(const vector<uint8> & header) 
{
  _header = header;
  setHeaderSize(header.size());
}


/**************************************************************************/
void tbvSwitchPktT::createHeader(const vector<uint8> & data) 
{
  _header = data;
  _header.erase(_header.begin()+getHeaderSize(), _header.end()); 
}


/**************************************************************************/
void tbvSwitchPktT::createPayload(const vector<uint8> & data) 
{
  vector<uint8> x = data;
  x.erase(x.begin(), x.begin() + getHeaderSize());
  setPayload(x);
}


/**************************************************************************/
DATACOM_TYPE tbvSwitchPktT::getType()
{
  return SW_PACKET;
}
/**************************************************************************/
void  tbvSwitchPktT::randomPayload(int size = 0)
{
  /* the randomPayload in tbvDataComT randomises whole payload,but we may not want to
     randomise mpls tag(which are really a part of payload),so randomise excluding
     mpls tag */
  if (size > MAX_PAYLOAD_SIZE)
  {
    tbvOut<<"MAX_PAYLOAD"<<MAX_PAYLOAD_SIZE<<endl;
    tbvExceptionT::setUserExceptionTypeString("PAYLOAD_SIZE_OVERFLOW");
    tbvExceptionT::reportUserException("PAYLOAD_SIZE_OVERFLOW",
                                        tbvExceptionT::WARNING,
                                        "in tbvDataComT::randomPayload(size) size 
is larger than MAX_PAYLOAD_SIZE, set size to MAX_PAYLOAD_SIZE.");
    size = MAX_PAYLOAD_SIZE;
    _payloadsize = size;
  }
                        //if the size is larger than the maximum size,
                        //the size is set to the maximum size
  else if (size == 0)
  {
    size = _payloadsize;
  }

  tbvSmartUnsignedT rand;
  unsigned int _MPLS = getMPLSCount()*4;

  rand.keepOnly(0,0xFF);
                        //only create an unsigned integer in 0~255 to match
                        //it to a char
  _payload.erase(_payload.begin() + _MPLS, _payload.end());
                        //clear the old data before generate the new data

  for (unsigned int i = 0; i < (size - _MPLS); i++)
  {
    rand.randomize();

#ifdef DATACOM_DEBUG
    tbvOut << "in randomPayload  rand[" << dec <<i<<"] = " << hex <<rand.getUnsignedValue() << endl;
#endif

    _payload.push_back((uint8) rand.getUnsignedValue());
  }

#ifdef DATACOM_DEBUG
  for (unsigned int i = 0; i < _payload.size(); i++)
  {
    tbvOut << "in randomPayload  payload[" << dec <<i<<"] = " << hex <<(uint64)_payload[i] << endl;
  }
#endif

}
/**************************************************************************************************/
const unsigned int tbvSwitchPktT::getMPLSCount() const{
  /* This is realy a fake,even though switch pkt does not know anything about no. of mpls tags
     in payload,and if switch pkt is constructed using pkt,(which knew about no. of mpls tag)
     using convertFrom,the _control knows about mpls count,and make use of this to randomise payload
     except mpls tags.
  */ 
  return (getControlData()).MPLS_count;
}


