// ----------------------------------------------------------------------------
// (c) Copyright 2005, Springer.  All Rights Reserved. The code in this CD-ROM is
// distributed by Springer with ABSOLUTELY NO SUPPORT and NO WARRANTY from
// Springer. Use or reproduction of the information provided on this code for
// commercial gain is strictly prohibited. Explicit permission is given for the
// reproduction and use of this information in an instructional setting provided
// proper reference is given to the original source.  
// 
// Authors and Springer shall not be liable for damage in connection with, or
// arising out of, the furnishing, performance or use of the contents of the
// CD-ROM. 
// ----------------------------------------------------------------------------

#ifndef _REASSEMBLYTRANSFORM_H
#define _REASSEMBLYTRANSFORM_H

#include <stl.h>
#include <queue>
#include "dataGram.h"
#include "dataPayload.h"

typedef vector<unsigned char> byteVector;

class reassemblyInputControl: public sidebandControlT {

private:
   bool sop;
	bool eop;
   bool sof;
	bool eof;
	
public:
   void setStartOfPacket (bool _sop) { sop = _sop; }
   void setEndOfPacket (bool _eop) { eop = _eop; }
   void setStartOfFragment (bool _sof) { sof = _sof; }
   void setEndOfFragment (bool _eof) { eof = _eof; }
	
   bool getStartOfPacket () { return sop; }
   bool getEndOfPacket () { return eop; }
   bool getStartOfFragment () { return sof; }
   bool getEndOfFragment () { return eof; }

};

class rasInputCell : public dataGramT{
	public:
		rasInputCell();
		
};

typedef rasInputCell rasOutputCell;

typedef queue<dataGramT * > reassemblyInputQueue;
typedef queue<dataGramT * > reassemblyOutputQueue;

class reassemblyTransformT {
  public:
  	  void type0 (reassemblyInputQueue &i, reassemblyOutputQueue &o);
  	  void type1 (reassemblyInputQueue &i, reassemblyOutputQueue &o);
};	  


#endif
