// ----------------------------------------------------------------------------
// (c) Copyright 2005, Springer.  All Rights Reserved. The code in this CD-ROM is
// distributed by Springer with ABSOLUTELY NO SUPPORT and NO WARRANTY from
// Springer. Use or reproduction of the information provided on this code for
// commercial gain is strictly prohibited. Explicit permission is given for the
// reproduction and use of this information in an instructional setting provided
// proper reference is given to the original source.  
// 
// Authors and Springer shall not be liable for damage in connection with, or
// arising out of, the furnishing, performance or use of the contents of the
// CD-ROM. 
// ----------------------------------------------------------------------------

#ifndef _REASSEMBLYTRANSFORMTEST_H
#define _REASSEMBLYTRANSFORMTEST_H

#include "cppunitVerif.h"
#include "reassemblyTransform.h"

class reassemblyTransformTest : public CppUnit::TestCase {
protected:
    byteVector *atmDataVectorP;
    byteVector *atmMemoryDataVectorP;
    dataPayloadT *atmDataP;
    dataPayloadT *atmMemoryDataP;
	 reassemblyTransformT ras;
	 reassemblyInputQueue rasInput;
	 reassemblyOutputQueue rasOutput;
	 rasInputCell *atmCellP;
	 rasInputCell *atmMemoryCellP;
	 
public:
    void setUp() {
        atmDataVectorP = new byteVector(52,0);
		  atmMemoryDataVectorP = new byteVector(64,0);

        for (unsigned i = 0; i < atmDataVectorP->size(); i++) {
            (*atmDataVectorP)[i] = rand() % 255;
            (*atmMemoryDataVectorP)[i] = (*atmDataVectorP)[i];
        }
		  rasInput = reassemblyInputQueue();  //calling constructor to create a new Queue
		  rasOutput = reassemblyOutputQueue();
		  atmCellP = new rasInputCell();
		  atmCellP->setDataComP(new dataPayloadT(*atmDataVectorP));
		  atmMemoryCellP = new rasInputCell();
		  atmMemoryCellP->setDataComP(new dataPayloadT(*atmMemoryDataVectorP));
 
	 }		  
    void tearDown() {
        delete atmDataVectorP;
        delete atmMemoryDataVectorP;
        delete atmCellP;
        delete atmMemoryCellP;
	 }

    CPPUNIT_TEST_SUITE( reassemblyTransformTest );  
    CPPUNIT_TEST( testType0 );
    CPPUNIT_TEST_SUITE_END();

    void testType0();

public: 
//     bool compare(byteVector &, byteVector &);

};


#endif
