// ----------------------------------------------------------------------------
// (c) Copyright 2005, Springer.  All Rights Reserved. The code in this CD-ROM is
// distributed by Springer with ABSOLUTELY NO SUPPORT and NO WARRANTY from
// Springer. Use or reproduction of the information provided on this code for
// commercial gain is strictly prohibited. Explicit permission is given for the
// reproduction and use of this information in an instructional setting provided
// proper reference is given to the original source.  
// 
// Authors and Springer shall not be liable for damage in connection with, or
// arising out of, the furnishing, performance or use of the contents of the
// CD-ROM. 
// ----------------------------------------------------------------------------

#include "cellDispatcher.h"

cellDispatcherTaskT::cellDispatcherTaskT() :
    backgroundTaskT("cellDispatcherTaskT") {}

cellDispatcherTaskT::~cellDispatcherTaskT(){
  // delete *  spawnMonitorT that is created for every monitor to be spawned.
  // The destcructor in spawnMonitorT will delete the * monitorTaskT
  for(list<monitorTaskT *>::iterator monitorIter = monitorTaskList.begin();
      monitorIter != monitorTaskList.end();++monitorIter){
    delete monitorTaskToSpawnMonitorInstance[*monitorIter];
  }

  
}

/********************************************************************************/

void cellDispatcherTaskT::body() {
}

/********************************************************************************/
/** Registers monitor with checker.
 /param monitor is monitorTask to be spawned
 /param ptr is checker function pointer,indicating whether the cell returned by monitor is
 input cell to checker or output cell to compare
 /param checker is reference to checker instance.

 Look \a registerMonitor(monitorTaskT * monitor) also.
*/
void cellDispatcherTaskT::registerProcessHandleWithMonitor(monitorTaskT * monitor,
							   checkerProcessFunctionPtr ptr,
							   checkerT & checker){
  // allocate one spawnMonitorTask Instance for this monitor task if it is not already
  // allocated, and call registerFunctionPointers(..) on that instace.
  if(monitorTaskToSpawnMonitorInstance.find(monitor) == monitorTaskToSpawnMonitorInstance.end()){
    // spawnMonitorTaskT instance not found for this monitorTask,create one
    monitorTaskToSpawnMonitorInstance[monitor] = new spawnMonitorTaskT(monitor->getNameP());
    monitorTaskList.push_back(monitor);
  }
  
  (*monitorTaskToSpawnMonitorInstance[monitor]).registerFunctionPointersWithChecker(ptr,checker);
  (*monitorTaskToSpawnMonitorInstance[monitor]).setChildTaskP(monitor);  
  
}

/********************************************************************************/
void cellDispatcherTaskT::unregisterProcessHandleWithMonitor(monitorTaskT * monitor){
  if(monitorTaskToSpawnMonitorInstance.find(monitor) != monitorTaskToSpawnMonitorInstance.end()){
    monitorTaskToSpawnMonitorInstance[monitor]->stop();
    // here we have to wait untill the execution of thread finishes,need to figure out more.
    // one way is to remember the thread for this monitor and wait for it.
    delete monitorTaskToSpawnMonitorInstance[monitor];
    monitorTaskToSpawnMonitorInstance.erase(monitor);
  }
}

/********************************************************************************/
/** This function registers all monitor tasks to be spawned.
    /param monitor is monitor to be started
*/
void cellDispatcherTaskT::registerMonitor(monitorTaskT * monitor){
  //If moitor need not call checker,call this function
  // check whether spawnMonitorTaskT instance is already created for this monitor
  if(monitorTaskToSpawnMonitorInstance.find(monitor) == monitorTaskToSpawnMonitorInstance.end()){
    monitorTaskToSpawnMonitorInstance[monitor] = new spawnMonitorTaskT(monitor->getNameP());
    monitorTaskList.push_back(monitor);
    (*monitorTaskToSpawnMonitorInstance[monitor]).setChildTaskP(monitor);
  }
}

/********************************************************************************/
void cellDispatcherTaskT::unregisterMonitor(monitorTaskT * monitor){
  
  monitorTaskList.remove(monitor);
}

/********************************************************************************/
void  cellDispatcherTaskT::registerEventToStop(tbvEventExprT event){
  stopEvent = event;
}

/*******************************************************************************/
void cellDispatcherTaskT::start(){
  // get all monitor instance to be spawned ,call start() on them.
  for(list<monitorTaskT *>::iterator monitorIter = monitorTaskList.begin();
      monitorIter != monitorTaskList.end();++monitorIter){
    (*monitorTaskToSpawnMonitorInstance[*monitorIter]).start();
  }
}
/******************************************************************************/
void  cellDispatcherTaskT::stop(){
   for(list<monitorTaskT *>::iterator monitorIter = monitorTaskList.begin();
      monitorIter != monitorTaskList.end();++monitorIter){
    (*monitorTaskToSpawnMonitorInstance[*monitorIter]).stop();
  }
}
/********************************************************************************/
/** return spwan monitor task object reference for a given monitorTask.
    this could be used stop indivisual monitor at any time
*/
spawnMonitorTaskT & cellDispatcherTaskT::getSpawnMonitorTasK(monitorTaskT * monitor){
  return *(monitorTaskToSpawnMonitorInstance[monitor]);
}

/********************************************************************************/
