// ----------------------------------------------------------------------------
// (c) Copyright 2005, Springer.  All Rights Reserved. The code in this CD-ROM is
// distributed by Springer with ABSOLUTELY NO SUPPORT and NO WARRANTY from
// Springer. Use or reproduction of the information provided on this code for
// commercial gain is strictly prohibited. Explicit permission is given for the
// reproduction and use of this information in an instructional setting provided
// proper reference is given to the original source.  
// 
// Authors and Springer shall not be liable for damage in connection with, or
// arising out of, the furnishing, performance or use of the contents of the
// CD-ROM. 
// ----------------------------------------------------------------------------

#ifndef CELL_DISPATCHER_TASK_H 
#define CELL_DISPATCHER_TASK_H

#include "stl.h"
#include "TestBuilder.h"
#include "checker.h"
#include "spawnMonitor.h"
#include "dataGram.h"
#include "backgroundTask.h"

/** \defgroup cellDispatcher cell dispatcher
    This task spawns spawnMonitorTask ,which spawn the designated monitor.
    The main function of this task is create spawnMonitorTaskT object for
    monitor to be spawned.
    User can also attach multiple checkers to each monitor.
*/

class cellDispatcherTaskT : public backgroundTaskT {
 public:
    cellDispatcherTaskT(); 

  ~cellDispatcherTaskT();

  /// call back method body,must for a task
  void body();
  
  /// typedef checkerProcessFunctionPtr to (checkerT::*)(dataGramT *)
  /// processInput(..) and processOutput(..) has this signature.
  typedef void (checkerT::*checkerProcessFunctionPtr) (dataGramT *);

  /// attach checker's processInput() or processOutput() function pointer
  /// to monitor task.This monitor task call this function with datacomP
  void registerProcessHandleWithMonitor(monitorTaskT * monitor,checkerProcessFunctionPtr ptr,
					checkerT & checker);

  /// register all monitors to be spawned
  void registerMonitor(monitorTaskT * monitor);

  /// register event to stop,it could be combination of events
  void registerEventToStop(tbvEventExprT event);

//    tbvThreadT  start();

  void start();
  void  stop();

  /// get spawnMonitorTast instance for /param monitor .
  spawnMonitorTaskT & getSpawnMonitorTasK(monitorTaskT * monitor);

  /// unregister checker with monitor
  void unregisterProcessHandleWithMonitor(monitorTaskT * monitor);

  /// unregister monitor
  void unregisterMonitor(monitorTaskT * monitor);
 protected:
 private:
  ///map of monitorTask -> list of checker &
  map<monitorTaskT *,spawnMonitorTaskT *> monitorTaskToSpawnMonitorInstance;

  
  /// The cellDispatcher will not wait for the monitor thread when this event happens
  tbvEventExprT stopEvent;
  
  /// event result
  tbvEventResultT stopEventResult;
  
   /// list of monitorTasks
  list<monitorTaskT *> monitorTaskList;
  
//  bool run;
};
  
#endif
