// ----------------------------------------------------------------------------
// (c) Copyright 2005, Springer.  All Rights Reserved. The code in this CD-ROM is
// distributed by Springer with ABSOLUTELY NO SUPPORT and NO WARRANTY from
// Springer. Use or reproduction of the information provided on this code for
// commercial gain is strictly prohibited. Explicit permission is given for the
// reproduction and use of this information in an instructional setting provided
// proper reference is given to the original source.  
// 
// Authors and Springer shall not be liable for damage in connection with, or
// arising out of, the furnishing, performance or use of the contents of the
// CD-ROM. 
// ----------------------------------------------------------------------------

#ifndef CONTROL_DATA_H
#define CONTROL_DATA_H

#include "iostream.h"
/** \defgroup control 
    \ingroup control control data structure
    Base  class for control data structure.
    All side band and inband

    The inherited control(for a given interface) must be bundled togather with dataPayloadT instance.
    This makes a pair for carrying sufficient information for a given interface.

    E.g. Input to Ras say RasInputCell should have pointer to dataPayloadT and pointer to
    rasInputControl( must inherit from this class).
    
*/

class sidebandControlT {
 public:  
  sidebandControlT(const char * nameP = NULL);
  virtual ~sidebandControlT(){}
  sidebandControlT & operator=(const sidebandControlT & rhs);
  unsigned int getValid() const;
  
  void setValid(unsigned int);
  virtual sidebandControlT * duplicate();
 protected:
  sidebandControlT(const sidebandControlT & rhs,const char * nameP = NULL);
 private:
  unsigned int valid;
};

#endif
